/*
 * Decompiled with CFR 0.152.
 */
package org.litepal.tablemanager;

import android.database.sqlite.SQLiteDatabase;
import org.litepal.tablemanager.AssociationCreator;
import org.litepal.tablemanager.model.TableModel;
import org.litepal.util.DBUtility;

class Creator
extends AssociationCreator {
    public static final String TAG = "Creator";

    Creator() {
    }

    @Override
    protected void createOrUpgradeTable(SQLiteDatabase db, boolean force) {
        for (TableModel tableModel : this.getAllTableModels()) {
            this.execute(this.getCreateTableSQLs(tableModel, db, force), db);
            this.giveTableSchemaACopy(tableModel.getTableName(), 0, db);
        }
    }

    protected String[] getCreateTableSQLs(TableModel tableModel, SQLiteDatabase db, boolean force) {
        if (force) {
            return new String[]{this.generateDropTableSQL(tableModel), this.generateCreateTableSQL(tableModel)};
        }
        if (DBUtility.isTableExists(tableModel.getTableName(), db)) {
            return null;
        }
        return new String[]{this.generateCreateTableSQL(tableModel)};
    }

    protected String generateDropTableSQL(TableModel tableModel) {
        return this.generateDropTableSQL(tableModel.getTableName());
    }

    protected String generateCreateTableSQL(TableModel tableModel) {
        return this.generateCreateTableSQL(tableModel.getTableName(), tableModel.getColumns(), true);
    }
}

