/*
 * Decompiled with CFR 0.152.
 */
package org.litepal.tablemanager;

import android.database.sqlite.SQLiteDatabase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.litepal.parser.LitePalAttr;
import org.litepal.tablemanager.Creator;
import org.litepal.tablemanager.model.AssociationsModel;
import org.litepal.tablemanager.model.TableModel;
import org.litepal.util.BaseUtility;
import org.litepal.util.DBUtility;
import org.litepal.util.LogUtil;

public abstract class AssociationUpdater
extends Creator {
    public static final String TAG = "AssociationUpdater";
    private Collection<AssociationsModel> mAssociationModels;
    protected SQLiteDatabase mDb;

    @Override
    protected abstract void createOrUpgradeTable(SQLiteDatabase var1, boolean var2);

    @Override
    protected void addOrUpdateAssociation(SQLiteDatabase db, boolean force) {
        this.mAssociationModels = this.getAllAssociations();
        this.mDb = db;
        this.removeAssociations();
    }

    protected List<String> getForeignKeyColumns(TableModel tableModel) {
        ArrayList<String> foreignKeyColumns = new ArrayList<String>();
        Set<String> columnNamesDB = this.getTableModelFromDB(tableModel.getTableName()).getColumnNames();
        for (String columnNameDB : columnNamesDB) {
            if (!this.isForeignKeyColumnFormat(columnNameDB) || BaseUtility.containsIgnoreCases(tableModel.getColumnNames(), columnNameDB)) continue;
            LogUtil.d(TAG, "getForeignKeyColumnNames >> foreign key column is " + columnNameDB);
            foreignKeyColumns.add(columnNameDB);
        }
        return foreignKeyColumns;
    }

    protected boolean isForeignKeyColumn(TableModel tableModel, String columnName) {
        return BaseUtility.containsIgnoreCases(this.getForeignKeyColumns(tableModel), columnName);
    }

    protected TableModel getTableModelFromDB(String tableName) {
        return DBUtility.findPragmaTableInfo(tableName, this.mDb);
    }

    protected void dropTables(List<String> dropTableNames, SQLiteDatabase db) {
        if (dropTableNames != null && !dropTableNames.isEmpty()) {
            String[] dropTableSQLS = new String[dropTableNames.size()];
            for (int i = 0; i < dropTableSQLS.length; ++i) {
                dropTableSQLS[i] = this.generateDropTableSQL(dropTableNames.get(i));
            }
            this.execute(dropTableSQLS, db);
        }
    }

    protected void removeColumns(Collection<String> removeColumnNames, String tableName) {
        if (removeColumnNames != null && !removeColumnNames.isEmpty()) {
            this.execute(this.getRemoveColumnSQLs(removeColumnNames, tableName), this.mDb);
        }
    }

    protected void clearCopyInTableSchema(List<String> tableNames) {
        if (tableNames != null && !tableNames.isEmpty()) {
            StringBuilder deleteData = new StringBuilder("delete from ");
            deleteData.append("table_schema").append(" where");
            boolean needOr = false;
            for (String tableName : tableNames) {
                if (needOr) {
                    deleteData.append(" or ");
                }
                needOr = true;
                deleteData.append(" lower(").append("name").append(") ");
                deleteData.append("=").append(" lower('").append(tableName).append("')");
            }
            LogUtil.d(TAG, "clear table schema value sql is " + deleteData);
            String[] sqls = new String[]{deleteData.toString()};
            this.execute(sqls, this.mDb);
        }
    }

    private void removeAssociations() {
        this.removeForeignKeyColumns();
        this.removeIntermediateTables();
    }

    private void removeForeignKeyColumns() {
        for (String className : LitePalAttr.getInstance().getClassNames()) {
            TableModel tableModel = this.getTableModel(className);
            this.removeColumns(this.findForeignKeyToRemove(tableModel), tableModel.getTableName());
        }
    }

    private void removeIntermediateTables() {
        List<String> tableNamesToDrop = this.findIntermediateTablesToDrop();
        this.dropTables(tableNamesToDrop, this.mDb);
        this.clearCopyInTableSchema(tableNamesToDrop);
    }

    private List<String> findForeignKeyToRemove(TableModel tableModel) {
        ArrayList<String> removeRelations = new ArrayList<String>();
        List<String> foreignKeyColumns = this.getForeignKeyColumns(tableModel);
        String selfTableName = tableModel.getTableName();
        for (String foreignKeyColumn : foreignKeyColumns) {
            String associatedTableName = DBUtility.getTableNameByForeignColumn(foreignKeyColumn);
            if (!this.shouldDropForeignKey(selfTableName, associatedTableName)) continue;
            removeRelations.add(foreignKeyColumn);
        }
        LogUtil.d(TAG, "findForeignKeyToRemove >> " + tableModel.getTableName() + " " + removeRelations);
        return removeRelations;
    }

    private List<String> findIntermediateTablesToDrop() {
        ArrayList<String> intermediateTables = new ArrayList<String>();
        for (String tableName : DBUtility.findAllTableNames(this.mDb)) {
            if (!DBUtility.isIntermediateTable(tableName, this.mDb)) continue;
            boolean dropIntermediateTable = true;
            for (AssociationsModel associationModel : this.mAssociationModels) {
                String intermediateTableName;
                if (associationModel.getAssociationType() != 3 || !tableName.equalsIgnoreCase(intermediateTableName = DBUtility.getIntermediateTableName(associationModel.getTableName(), associationModel.getAssociatedTableName()))) continue;
                dropIntermediateTable = false;
            }
            if (!dropIntermediateTable) continue;
            intermediateTables.add(tableName);
        }
        LogUtil.d(TAG, "findIntermediateTablesToDrop >> " + intermediateTables);
        return intermediateTables;
    }

    private String generateAlterToTempTableSQL(String tableName) {
        StringBuilder sql = new StringBuilder();
        sql.append("alter table ").append(tableName).append(" rename to ").append(this.getTempTableName(tableName));
        return sql.toString();
    }

    private String generateCreateNewTableSQL(Collection<String> removeColumnNames, String tableName) {
        TableModel tableModelDB = this.getTableModelFromDB(tableName);
        for (String removeColumnName : removeColumnNames) {
            tableModelDB.removeColumnIgnoreCases(removeColumnName);
        }
        return this.generateCreateTableSQL(tableModelDB);
    }

    private String generateDataMigrationSQL(Collection<String> removeColumnNames, String tableName) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (String columnName : this.getTableModelFromDB(tableName).getColumnNames()) {
            if (BaseUtility.containsIgnoreCases(removeColumnNames, columnName)) continue;
            columnNames.add(columnName);
        }
        if (!columnNames.isEmpty()) {
            StringBuilder sql = new StringBuilder();
            sql.append("insert into ").append(tableName).append("(");
            boolean needComma = false;
            for (String columnName : columnNames) {
                if (needComma) {
                    sql.append(", ");
                }
                needComma = true;
                sql.append(columnName);
            }
            sql.append(") ");
            sql.append("select ");
            needComma = false;
            for (String columnName : columnNames) {
                if (needComma) {
                    sql.append(", ");
                }
                needComma = true;
                sql.append(columnName);
            }
            sql.append(" from ").append(this.getTempTableName(tableName));
            return sql.toString();
        }
        return null;
    }

    private String generateDropTempTableSQL(String tableName) {
        return this.generateDropTableSQL(this.getTempTableName(tableName));
    }

    private String getTempTableName(String tableName) {
        return tableName + "_temp";
    }

    private String[] getRemoveColumnSQLs(Collection<String> removeColumnNames, String tableName) {
        String alterToTempTableSQL = this.generateAlterToTempTableSQL(tableName);
        LogUtil.d(TAG, "generateRemoveColumnSQL >> " + alterToTempTableSQL);
        String createNewTableSQL = this.generateCreateNewTableSQL(removeColumnNames, tableName);
        LogUtil.d(TAG, "generateRemoveColumnSQL >> " + createNewTableSQL);
        String dataMigrationSQL = this.generateDataMigrationSQL(removeColumnNames, tableName);
        LogUtil.d(TAG, "generateRemoveColumnSQL >> " + dataMigrationSQL);
        String dropTempTableSQL = this.generateDropTempTableSQL(tableName);
        LogUtil.d(TAG, "generateRemoveColumnSQL >> " + dropTempTableSQL);
        String[] sqls = new String[]{alterToTempTableSQL, createNewTableSQL, dataMigrationSQL, dropTempTableSQL};
        return sqls;
    }

    private boolean shouldDropForeignKey(String selfTableName, String associatedTableName) {
        for (AssociationsModel associationModel : this.mAssociationModels) {
            if (!(associationModel.getAssociationType() == 1 ? selfTableName.equalsIgnoreCase(associationModel.getTableHoldsForeignKey()) && (associationModel.getTableName().equalsIgnoreCase(selfTableName) ? this.isRelationCorrect(associationModel, selfTableName, associatedTableName) : associationModel.getAssociatedTableName().equalsIgnoreCase(selfTableName) && this.isRelationCorrect(associationModel, associatedTableName, selfTableName)) : associationModel.getAssociationType() == 2 && this.isRelationCorrect(associationModel, associatedTableName, selfTableName))) continue;
            return false;
        }
        return true;
    }

    private boolean isRelationCorrect(AssociationsModel associationModel, String tableName1, String tableName2) {
        return associationModel.getTableName().equalsIgnoreCase(tableName1) && associationModel.getAssociatedTableName().equalsIgnoreCase(tableName2);
    }
}

