/*
 * Decompiled with CFR 0.152.
 */
package org.litepal.tablemanager;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.litepal.exceptions.DatabaseGenerateException;
import org.litepal.tablemanager.Generator;
import org.litepal.tablemanager.model.AssociationsModel;
import org.litepal.util.BaseUtility;
import org.litepal.util.DBUtility;
import org.litepal.util.LogUtil;

public abstract class AssociationCreator
extends Generator {
    @Override
    protected abstract void createOrUpgradeTable(SQLiteDatabase var1, boolean var2);

    @Override
    protected void addOrUpdateAssociation(SQLiteDatabase db, boolean force) {
        this.addAssociations(this.getAllAssociations(), db, force);
    }

    protected String generateCreateTableSQL(String tableName, Map<String, String> columnsMap, boolean autoIncrementId) {
        Iterator<String> i;
        Set<String> columnNames = columnsMap.keySet();
        this.removeId(columnNames);
        StringBuilder createTableSQL = new StringBuilder("create table ");
        createTableSQL.append(tableName).append(" (");
        if (autoIncrementId) {
            createTableSQL.append("id integer primary key autoincrement,");
        }
        if (!(i = columnNames.iterator()).hasNext()) {
            createTableSQL.deleteCharAt(createTableSQL.length() - 1);
        }
        boolean needSeparator = false;
        while (i.hasNext()) {
            if (needSeparator) {
                createTableSQL.append(", ");
            }
            needSeparator = true;
            String columnName = i.next();
            createTableSQL.append(columnName).append(" ").append(columnsMap.get(columnName));
        }
        createTableSQL.append(")");
        LogUtil.d("Generator", "add column sql is >> " + createTableSQL);
        return createTableSQL.toString();
    }

    protected String generateDropTableSQL(String tableName) {
        return "drop table if exists " + tableName;
    }

    protected String generateAddColumnSQL(String tableName, String columnName, String columnType) {
        StringBuilder addColumnSQL = new StringBuilder();
        addColumnSQL.append("alter table ").append(tableName).append(" add column ").append(columnName).append(" ").append(columnType);
        LogUtil.d("Generator", "add column sql is >> " + addColumnSQL);
        return addColumnSQL.toString();
    }

    protected boolean isForeignKeyColumnFormat(String columnName) {
        if (!TextUtils.isEmpty((CharSequence)columnName)) {
            return columnName.toLowerCase().endsWith("_id") && !columnName.equalsIgnoreCase("_id");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void giveTableSchemaACopy(String tableName, int tableType, SQLiteDatabase db) {
        StringBuilder sql = new StringBuilder("select * from ");
        sql.append("table_schema");
        LogUtil.d("Generator", "giveTableSchemaACopy SQL is >> " + sql);
        try (Cursor cursor = null;){
            cursor = db.rawQuery(sql.toString(), null);
            if (this.isNeedtoGiveACopy(cursor, tableName)) {
                ContentValues values = new ContentValues();
                values.put("name", BaseUtility.changeCase(tableName));
                values.put("type", Integer.valueOf(tableType));
                db.insert("table_schema", null, values);
            }
        }
    }

    private boolean isNeedtoGiveACopy(Cursor cursor, String tableName) {
        return !this.isValueExists(cursor, tableName) && !this.isSpecialTable(tableName);
    }

    private boolean isValueExists(Cursor cursor, String tableName) {
        boolean exist = false;
        if (cursor.moveToFirst()) {
            do {
                String name;
                if (!(name = cursor.getString(cursor.getColumnIndexOrThrow("name"))).equalsIgnoreCase(tableName)) continue;
                exist = true;
                break;
            } while (cursor.moveToNext());
        }
        return exist;
    }

    private boolean isSpecialTable(String tableName) {
        return "table_schema".equalsIgnoreCase(tableName);
    }

    private void addAssociations(Collection<AssociationsModel> associatedModels, SQLiteDatabase db, boolean force) {
        for (AssociationsModel associationModel : associatedModels) {
            if (2 == associationModel.getAssociationType() || 1 == associationModel.getAssociationType()) {
                this.addForeignKeyColumn(associationModel.getTableName(), associationModel.getAssociatedTableName(), associationModel.getTableHoldsForeignKey(), db);
                continue;
            }
            if (3 != associationModel.getAssociationType()) continue;
            this.createIntermediateTable(associationModel.getTableName(), associationModel.getAssociatedTableName(), db, force);
        }
    }

    private void createIntermediateTable(String tableName, String associatedTableName, SQLiteDatabase db, boolean force) {
        HashMap<String, String> columnsMap = new HashMap<String, String>();
        columnsMap.put(tableName + "_id", "integer");
        columnsMap.put(associatedTableName + "_id", "integer");
        String intermediateTableName = DBUtility.getIntermediateTableName(tableName, associatedTableName);
        ArrayList<String> sqls = new ArrayList<String>();
        if (DBUtility.isTableExists(intermediateTableName, db)) {
            if (force) {
                sqls.add(this.generateDropTableSQL(intermediateTableName));
                sqls.add(this.generateCreateTableSQL(intermediateTableName, columnsMap, false));
            }
        } else {
            sqls.add(this.generateCreateTableSQL(intermediateTableName, columnsMap, false));
        }
        this.execute(sqls.toArray(new String[0]), db);
        this.giveTableSchemaACopy(intermediateTableName, 1, db);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addForeignKeyColumn(String tableName, String associatedTableName, String tableHoldsForeignKey, SQLiteDatabase db) {
        if (!DBUtility.isTableExists(tableName, db)) throw new DatabaseGenerateException("Table doesn't exist with the name of " + tableName);
        if (!DBUtility.isTableExists(associatedTableName, db)) throw new DatabaseGenerateException("Table doesn't exist with the name of " + associatedTableName);
        String foreignKeyColumn = null;
        if (tableName.equals(tableHoldsForeignKey)) {
            foreignKeyColumn = this.getForeignKeyColumnName(associatedTableName);
        } else if (associatedTableName.equals(tableHoldsForeignKey)) {
            foreignKeyColumn = this.getForeignKeyColumnName(tableName);
        }
        if (!DBUtility.isColumnExists(foreignKeyColumn, tableHoldsForeignKey, db)) {
            String[] sqls = new String[]{this.generateAddColumnSQL(tableHoldsForeignKey, foreignKeyColumn, "integer")};
            this.execute(sqls, db);
            return;
        } else {
            LogUtil.d("Generator", "column " + foreignKeyColumn + " is already exist, no need to add one");
        }
    }

    private void removeId(Set<String> columnNames) {
        String idName = "";
        for (String columnName : columnNames) {
            if (!this.isIdColumn(columnName)) continue;
            idName = columnName;
            break;
        }
        if (!TextUtils.isEmpty((CharSequence)idName)) {
            columnNames.remove(idName);
        }
    }
}

