/*
 * Decompiled with CFR 0.152.
 */
package org.litepal.parser;

import android.content.res.AssetManager;
import android.content.res.Resources;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.litepal.LitePalApplication;
import org.litepal.exceptions.ParseConfigurationFileException;
import org.litepal.parser.LitePalAttr;
import org.litepal.parser.LitePalContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class LitePalParser {
    static final String NODE_DB_NAME = "dbname";
    static final String NODE_VERSION = "version";
    static final String NODE_LIST = "list";
    static final String NODE_MAPPING = "mapping";
    static final String NODE_CASES = "cases";
    static final String ATTR_VALUE = "value";
    static final String ATTR_CLASS = "class";
    private static LitePalParser parser;

    public static void parseLitePalConfiguration() {
        if (parser == null) {
            parser = new LitePalParser();
        }
        parser.useSAXParser();
    }

    void useSAXParser() {
        LitePalContentHandler handler = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            XMLReader xmlReader = factory.newSAXParser().getXMLReader();
            handler = new LitePalContentHandler();
            xmlReader.setContentHandler(handler);
            xmlReader.parse(new InputSource(this.getConfigInputStream()));
            return;
        }
        catch (Resources.NotFoundException e) {
            throw new ParseConfigurationFileException("litepal.xml file is missing. Please ensure it under assets folder.");
        }
        catch (SAXException e) {
            throw new ParseConfigurationFileException("can not parse the litepal.xml, check if it's in correct format");
        }
        catch (ParserConfigurationException e) {
            throw new ParseConfigurationFileException("parse configuration is failed");
        }
        catch (IOException e) {
            throw new ParseConfigurationFileException("IO exception happened");
        }
    }

    void usePullParse() {
        try {
            LitePalAttr litePalAttr = LitePalAttr.getInstance();
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            XmlPullParser xmlPullParser = factory.newPullParser();
            xmlPullParser.setInput(this.getConfigInputStream(), "UTF-8");
            int eventType = xmlPullParser.getEventType();
            while (eventType != 1) {
                String nodeName = xmlPullParser.getName();
                switch (eventType) {
                    case 2: {
                        if (NODE_DB_NAME.equals(nodeName)) {
                            String dbName = xmlPullParser.getAttributeValue("", ATTR_VALUE);
                            litePalAttr.setDbName(dbName);
                            break;
                        }
                        if (NODE_VERSION.equals(nodeName)) {
                            String version = xmlPullParser.getAttributeValue("", ATTR_VALUE);
                            litePalAttr.setVersion(Integer.parseInt(version));
                            break;
                        }
                        if (NODE_MAPPING.equals(nodeName)) {
                            String className = xmlPullParser.getAttributeValue("", ATTR_CLASS);
                            litePalAttr.addClassName(className);
                            break;
                        }
                        if (!NODE_CASES.equals(nodeName)) break;
                        String cases = xmlPullParser.getAttributeValue("", ATTR_VALUE);
                        litePalAttr.setCases(cases);
                        break;
                    }
                }
                eventType = xmlPullParser.next();
            }
        }
        catch (XmlPullParserException e) {
            throw new ParseConfigurationFileException("can not parse the litepal.xml, check if it's in correct format");
        }
        catch (IOException e) {
            throw new ParseConfigurationFileException("IO exception happened");
        }
    }

    private InputStream getConfigInputStream() throws IOException {
        AssetManager assetManager = LitePalApplication.getContext().getAssets();
        String[] fileNames = assetManager.list("");
        if (fileNames != null && fileNames.length > 0) {
            for (String fileName : fileNames) {
                if (!"litepal.xml".equalsIgnoreCase(fileName)) continue;
                return assetManager.open(fileName, 3);
            }
        }
        throw new ParseConfigurationFileException("litepal.xml file is missing. Please ensure it under assets folder.");
    }
}

