/*
 * Decompiled with CFR 0.152.
 */
package org.litepal.parser;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import org.litepal.exceptions.InvalidAttributesException;
import org.litepal.util.SharedUtil;

public final class LitePalAttr {
    private static LitePalAttr litePalAttr;
    private int version;
    private String dbName;
    private String cases;
    private List<String> classNames;

    private LitePalAttr() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LitePalAttr getInstance() {
        if (litePalAttr != null) return litePalAttr;
        Class<LitePalAttr> clazz = LitePalAttr.class;
        synchronized (LitePalAttr.class) {
            if (litePalAttr != null) return litePalAttr;
            litePalAttr = new LitePalAttr();
            // ** MonitorExit[var0] (shouldn't be in output)
            return litePalAttr;
        }
    }

    public int getVersion() {
        return this.version;
    }

    void setVersion(int version) {
        this.version = version;
    }

    public String getDbName() {
        return this.dbName;
    }

    void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public List<String> getClassNames() {
        if (this.classNames == null) {
            this.classNames = new ArrayList<String>();
            this.classNames.add("org.litepal.model.Table_Schema");
        } else if (this.classNames.isEmpty()) {
            this.classNames.add("org.litepal.model.Table_Schema");
        }
        return this.classNames;
    }

    void addClassName(String className) {
        this.getClassNames().add(className);
    }

    public String getCases() {
        return this.cases;
    }

    void setCases(String cases) {
        this.cases = cases;
    }

    public boolean checkSelfValid() {
        if (TextUtils.isEmpty((CharSequence)this.dbName)) {
            throw new InvalidAttributesException("dbname is empty or not defined in litepal.xml file");
        }
        if (!this.dbName.endsWith(".db")) {
            this.dbName = this.dbName + ".db";
        }
        if (this.version < 1) {
            throw new InvalidAttributesException("the version of database can not be less than 1");
        }
        if (this.version < SharedUtil.getLastVersion()) {
            throw new InvalidAttributesException("the version in litepal.xml is earlier than the current version");
        }
        if (TextUtils.isEmpty((CharSequence)this.cases)) {
            this.cases = "lower";
        } else if (!(this.cases.equals("upper") || this.cases.equals("lower") || this.cases.equals("keep"))) {
            throw new InvalidAttributesException(this.cases + " is an invalid value for <cases></cases>");
        }
        return true;
    }
}

