/*
 * Decompiled with CFR 0.152.
 */
package org.litepal.crud;

import android.content.ContentValues;
import android.database.sqlite.SQLiteDatabase;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.litepal.crud.DataHandler;
import org.litepal.crud.DataSupport;
import org.litepal.crud.model.AssociationsInfo;
import org.litepal.exceptions.DataSupportException;
import org.litepal.util.BaseUtility;

class UpdateHandler
extends DataHandler {
    UpdateHandler(SQLiteDatabase db) {
        this.mDatabase = db;
    }

    int onUpdate(DataSupport baseObj, long id) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        List<Field> supportedFields = this.getSupportedFields(baseObj.getClassName());
        ContentValues values = new ContentValues();
        this.putFieldsValue(baseObj, supportedFields, values);
        this.putFieldsToDefaultValue(baseObj, values);
        if (values.size() > 0) {
            return this.mDatabase.update(baseObj.getTableName(), values, "id = " + id, null);
        }
        return 0;
    }

    int onUpdate(Class<?> modelClass, long id, ContentValues values) {
        if (values.size() > 0) {
            return this.mDatabase.update(this.getTableName(modelClass), values, "id = " + id, null);
        }
        return 0;
    }

    int onUpdateAll(DataSupport baseObj, String ... conditions) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        List<Field> supportedFields = this.getSupportedFields(baseObj.getClassName());
        ContentValues values = new ContentValues();
        this.putFieldsValue(baseObj, supportedFields, values);
        this.putFieldsToDefaultValue(baseObj, values);
        return this.doUpdateAllAction(baseObj.getTableName(), values, conditions);
    }

    int onUpdateAll(String tableName, ContentValues values, String ... conditions) {
        return this.doUpdateAllAction(tableName, values, conditions);
    }

    private int doUpdateAllAction(String tableName, ContentValues values, String ... conditions) {
        BaseUtility.checkConditionsCorrect(conditions);
        if (values.size() > 0) {
            return this.mDatabase.update(tableName, values, this.getWhereClause(conditions), this.getWhereArgs(conditions));
        }
        return 0;
    }

    private void putFieldsToDefaultValue(DataSupport baseObj, ContentValues values) {
        String fieldName = null;
        try {
            DataSupport emptyModel = this.getEmptyModel(baseObj);
            Class<?> emptyModelClass = emptyModel.getClass();
            for (String name : baseObj.getFieldsToSetToDefault()) {
                if (this.isIdColumn(name)) continue;
                fieldName = name;
                Field field = emptyModelClass.getDeclaredField(fieldName);
                this.putContentValues(emptyModel, field, values);
            }
        }
        catch (NoSuchFieldException e) {
            throw new DataSupportException(DataSupportException.noSuchFieldExceptioin(baseObj.getClassName(), fieldName));
        }
        catch (Exception e) {
            throw new DataSupportException(e.getMessage());
        }
    }

    private int doUpdateAssociations(DataSupport baseObj, long id, ContentValues values) {
        int rowsAffected = 0;
        this.analyzeAssociations(baseObj);
        this.updateSelfTableForeignKey(baseObj, values);
        return rowsAffected += this.updateAssociatedTableForeignKey(baseObj, id);
    }

    private void analyzeAssociations(DataSupport baseObj) {
        try {
            Collection<AssociationsInfo> associationInfos = this.getAssociationInfo(baseObj.getClassName());
            this.analyzeAssociatedModels(baseObj, associationInfos);
        }
        catch (Exception e) {
            throw new DataSupportException(e.getMessage());
        }
    }

    private void updateSelfTableForeignKey(DataSupport baseObj, ContentValues values) {
        Map<String, Long> associatedModelMap = baseObj.getAssociatedModelsMapWithoutFK();
        for (String associatedTable : associatedModelMap.keySet()) {
            String fkName = this.getForeignKeyColumnName(associatedTable);
            values.put(fkName, associatedModelMap.get(associatedTable));
        }
    }

    private int updateAssociatedTableForeignKey(DataSupport baseObj, long id) {
        Map<String, Set<Long>> associatedModelMap = baseObj.getAssociatedModelsMapWithFK();
        ContentValues values = new ContentValues();
        for (String associatedTable : associatedModelMap.keySet()) {
            values.clear();
            String fkName = this.getForeignKeyColumnName(baseObj.getTableName());
            values.put(fkName, Long.valueOf(id));
            Set<Long> ids = associatedModelMap.get(associatedTable);
            if (ids == null || ids.isEmpty()) continue;
            return this.mDatabase.update(associatedTable, values, this.getWhereOfIdsWithOr(ids), null);
        }
        return 0;
    }
}

