/*
 * Decompiled with CFR 0.152.
 */
package org.litepal.crud;

import android.content.ContentValues;
import android.database.sqlite.SQLiteDatabase;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.litepal.crud.DataHandler;
import org.litepal.crud.DataSupport;
import org.litepal.crud.DynamicExecutor;
import org.litepal.crud.model.AssociationsInfo;
import org.litepal.exceptions.DataSupportException;

class SaveHandler
extends DataHandler {
    SaveHandler(SQLiteDatabase db) {
        this.mDatabase = db;
    }

    void onSave(DataSupport baseObj) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String className = baseObj.getClassName();
        List<Field> supportedFields = this.getSupportedFields(className);
        Collection<AssociationsInfo> associationInfos = this.getAssociationInfo(className);
        if (!baseObj.isSaved()) {
            this.analyzeAssociatedModels(baseObj, associationInfos);
            this.doSaveAction(baseObj, supportedFields);
            this.analyzeAssociatedModels(baseObj, associationInfos);
        } else {
            this.analyzeAssociatedModels(baseObj, associationInfos);
            this.doUpdateAction(baseObj, supportedFields);
        }
    }

    <T extends DataSupport> void onSaveAll(Collection<T> collection) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (collection != null && collection.size() > 0) {
            DataSupport[] array = collection.toArray(new DataSupport[0]);
            DataSupport firstObj = array[0];
            String className = firstObj.getClassName();
            List<Field> supportedFields = this.getSupportedFields(className);
            Collection<AssociationsInfo> associationInfos = this.getAssociationInfo(className);
            for (DataSupport baseObj : array) {
                if (!baseObj.isSaved()) {
                    this.analyzeAssociatedModels(baseObj, associationInfos);
                    this.doSaveAction(baseObj, supportedFields);
                    this.analyzeAssociatedModels(baseObj, associationInfos);
                } else {
                    this.analyzeAssociatedModels(baseObj, associationInfos);
                    this.doUpdateAction(baseObj, supportedFields);
                }
                baseObj.clearAssociatedData();
            }
        }
    }

    private void doSaveAction(DataSupport baseObj, List<Field> supportedFields) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ContentValues values = new ContentValues();
        this.beforeSave(baseObj, supportedFields, values);
        long id = this.saving(baseObj, values);
        this.afterSave(baseObj, supportedFields, id);
    }

    private void beforeSave(DataSupport baseObj, List<Field> supportedFields, ContentValues values) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.putFieldsValue(baseObj, supportedFields, values);
        this.putForeignKeyValue(values, baseObj);
    }

    private long saving(DataSupport baseObj, ContentValues values) {
        return this.mDatabase.insert(baseObj.getTableName(), null, values);
    }

    private void afterSave(DataSupport baseObj, List<Field> supportedFields, long id) {
        this.throwIfSaveFailed(id);
        this.assignIdValue(baseObj, this.getIdField(supportedFields), id);
        this.updateAssociatedTableWithFK(baseObj);
        this.insertIntermediateJoinTableValue(baseObj, false);
    }

    private void doUpdateAction(DataSupport baseObj, List<Field> supportedFields) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ContentValues values = new ContentValues();
        this.beforeUpdate(baseObj, supportedFields, values);
        this.updating(baseObj, values);
        this.afterUpdate(baseObj);
    }

    private void beforeUpdate(DataSupport baseObj, List<Field> supportedFields, ContentValues values) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.putFieldsValue(baseObj, supportedFields, values);
        this.putForeignKeyValue(values, baseObj);
        for (String fkName : baseObj.getListToClearSelfFK()) {
            values.putNull(fkName);
        }
    }

    private void updating(DataSupport baseObj, ContentValues values) {
        this.mDatabase.update(baseObj.getTableName(), values, "id = ?", new String[]{String.valueOf(baseObj.getBaseObjId())});
    }

    private void afterUpdate(DataSupport baseObj) {
        this.updateAssociatedTableWithFK(baseObj);
        this.insertIntermediateJoinTableValue(baseObj, true);
        this.clearFKValueInAssociatedTable(baseObj);
    }

    private Field getIdField(List<Field> supportedFields) {
        for (Field field : supportedFields) {
            if (!this.isIdColumn(field.getName())) continue;
            return field;
        }
        return null;
    }

    private void throwIfSaveFailed(long id) {
        if (id == -1L) {
            throw new DataSupportException("Save current model failed.");
        }
    }

    private void assignIdValue(DataSupport baseObj, Field idField, long id) {
        try {
            this.giveBaseObjIdValue(baseObj, id);
            if (idField != null) {
                this.giveModelIdValue(baseObj, idField.getName(), idField.getType(), id);
            }
        }
        catch (Exception e) {
            throw new DataSupportException(e.getMessage());
        }
    }

    private void giveModelIdValue(DataSupport baseObj, String idName, Class<?> idType, long id) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        if (this.shouldGiveModelIdValue(idName, idType, id)) {
            Number value = null;
            if (idType == Integer.TYPE || idType == Integer.class) {
                value = (int)id;
            } else if (idType == Long.TYPE || idType == Long.class) {
                value = id;
            } else {
                throw new DataSupportException("id type is not supported. Only int or long is acceptable for id");
            }
            DynamicExecutor.setField(baseObj, idName, value, baseObj.getClass());
        }
    }

    private void putForeignKeyValue(ContentValues values, DataSupport baseObj) {
        Map<String, Long> associatedModelMap = baseObj.getAssociatedModelsMapWithoutFK();
        for (String associatedTableName : associatedModelMap.keySet()) {
            values.put(this.getForeignKeyColumnName(associatedTableName), associatedModelMap.get(associatedTableName));
        }
    }

    private void updateAssociatedTableWithFK(DataSupport baseObj) {
        Map<String, Set<Long>> associatedModelMap = baseObj.getAssociatedModelsMapWithFK();
        ContentValues values = new ContentValues();
        for (String associatedTableName : associatedModelMap.keySet()) {
            values.clear();
            String fkName = this.getForeignKeyColumnName(baseObj.getTableName());
            values.put(fkName, Long.valueOf(baseObj.getBaseObjId()));
            Set<Long> ids = associatedModelMap.get(associatedTableName);
            if (ids == null || ids.isEmpty()) continue;
            this.mDatabase.update(associatedTableName, values, this.getWhereOfIdsWithOr(ids), null);
        }
    }

    private void clearFKValueInAssociatedTable(DataSupport baseObj) {
        List<String> associatedTableNames = baseObj.getListToClearAssociatedFK();
        for (String associatedTableName : associatedTableNames) {
            String fkColumnName = this.getForeignKeyColumnName(baseObj.getTableName());
            ContentValues values = new ContentValues();
            values.putNull(fkColumnName);
            String whereClause = fkColumnName + " = " + baseObj.getBaseObjId();
            this.mDatabase.update(associatedTableName, values, whereClause, null);
        }
    }

    private void insertIntermediateJoinTableValue(DataSupport baseObj, boolean isUpdate) {
        Map<String, Set<Long>> associatedIdsM2M = baseObj.getAssociatedModelsMapForJoinTable();
        ContentValues values = new ContentValues();
        for (String associatedTableName : associatedIdsM2M.keySet()) {
            String joinTableName = this.getIntermediateTableName(baseObj, associatedTableName);
            if (isUpdate) {
                this.mDatabase.delete(joinTableName, this.getWhereForJoinTableToDelete(baseObj), new String[]{String.valueOf(baseObj.getBaseObjId())});
            }
            Set<Long> associatedIdsM2MSet = associatedIdsM2M.get(associatedTableName);
            for (long associatedId : associatedIdsM2MSet) {
                values.clear();
                values.put(this.getForeignKeyColumnName(baseObj.getTableName()), Long.valueOf(baseObj.getBaseObjId()));
                values.put(this.getForeignKeyColumnName(associatedTableName), Long.valueOf(associatedId));
                this.mDatabase.insert(joinTableName, null, values);
            }
        }
    }

    private String getWhereForJoinTableToDelete(DataSupport baseObj) {
        StringBuilder where = new StringBuilder();
        where.append(this.getForeignKeyColumnName(baseObj.getTableName()));
        where.append(" = ?");
        return where.toString();
    }

    private boolean shouldGiveModelIdValue(String idName, Class<?> idType, long id) {
        return idName != null && idType != null && id > 0L;
    }
}

