/*
 * Decompiled with CFR 0.152.
 */
package org.litepal.crud;

import android.database.sqlite.SQLiteDatabase;
import java.util.List;
import org.litepal.crud.DataHandler;
import org.litepal.util.BaseUtility;

class QueryHandler
extends DataHandler {
    QueryHandler(SQLiteDatabase db) {
        this.mDatabase = db;
    }

    <T> T onFind(Class<T> modelClass, long id, boolean isEager) {
        List<T> dataList = this.query(modelClass, null, "id = ?", new String[]{String.valueOf(id)}, null, null, null, null, this.getForeignKeyAssociations(modelClass.getName(), isEager));
        if (dataList.size() > 0) {
            return dataList.get(0);
        }
        return null;
    }

    <T> T onFindFirst(Class<T> modelClass, boolean isEager) {
        List<T> dataList = this.query(modelClass, null, null, null, null, null, "id", "1", this.getForeignKeyAssociations(modelClass.getName(), isEager));
        if (dataList.size() > 0) {
            return dataList.get(0);
        }
        return null;
    }

    <T> T onFindLast(Class<T> modelClass, boolean isEager) {
        List<T> dataList = this.query(modelClass, null, null, null, null, null, "id desc", "1", this.getForeignKeyAssociations(modelClass.getName(), isEager));
        if (dataList.size() > 0) {
            return dataList.get(0);
        }
        return null;
    }

    <T> List<T> onFindAll(Class<T> modelClass, boolean isEager, long ... ids) {
        List<T> dataList = this.isAffectAllLines(new Object[]{ids}) ? this.query(modelClass, null, null, null, null, null, "id", null, this.getForeignKeyAssociations(modelClass.getName(), isEager)) : this.query(modelClass, null, this.getWhereOfIdsWithOr(ids), null, null, null, "id", null, this.getForeignKeyAssociations(modelClass.getName(), isEager));
        return dataList;
    }

    <T> List<T> onFind(Class<T> modelClass, String[] columns, String[] conditions, String orderBy, String limit, boolean isEager) {
        BaseUtility.checkConditionsCorrect(conditions);
        List<T> dataList = this.query(modelClass, columns, this.getWhereClause(conditions), this.getWhereArgs(conditions), null, null, orderBy, limit, this.getForeignKeyAssociations(modelClass.getName(), isEager));
        return dataList;
    }

    int onCount(String tableName, String[] conditions) {
        return this.mathQuery(tableName, new String[]{"count(1)"}, conditions, Integer.TYPE);
    }

    double onAverage(String tableName, String column, String[] conditions) {
        return this.mathQuery(tableName, new String[]{"avg(" + column + ")"}, conditions, Double.TYPE);
    }

    <T> T onMax(String tableName, String column, String[] conditions, Class<T> type) {
        return this.mathQuery(tableName, new String[]{"max(" + column + ")"}, conditions, type);
    }

    <T> T onMin(String tableName, String column, String[] conditions, Class<T> type) {
        return this.mathQuery(tableName, new String[]{"min(" + column + ")"}, conditions, type);
    }

    <T> T onSum(String tableName, String column, String[] conditions, Class<T> type) {
        return this.mathQuery(tableName, new String[]{"sum(" + column + ")"}, conditions, type);
    }
}

