/*
 * Decompiled with CFR 0.152.
 */
package org.litepal.crud;

import java.lang.reflect.InvocationTargetException;
import org.litepal.crud.AssociationsAnalyzer;
import org.litepal.crud.DataSupport;
import org.litepal.crud.model.AssociationsInfo;
import org.litepal.util.DBUtility;

public class One2OneAnalyzer
extends AssociationsAnalyzer {
    void analyze(DataSupport baseObj, AssociationsInfo associationInfo) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        DataSupport associatedModel = this.getAssociatedModel(baseObj, associationInfo);
        if (associatedModel != null) {
            this.buildBidirectionalAssociations(baseObj, associatedModel, associationInfo);
            this.dealAssociatedModel(baseObj, associatedModel, associationInfo);
        } else {
            String tableName = DBUtility.getTableNameByClassName(associationInfo.getAssociatedClassName());
            baseObj.addAssociatedTableNameToClearFK(tableName);
        }
    }

    private void dealAssociatedModel(DataSupport baseObj, DataSupport associatedModel, AssociationsInfo associationInfo) {
        if (associationInfo.getAssociateSelfFromOtherModel() != null) {
            this.bidirectionalCondition(baseObj, associatedModel);
        } else {
            this.unidirectionalCondition(baseObj, associatedModel);
        }
    }

    private void bidirectionalCondition(DataSupport baseObj, DataSupport associatedModel) {
        if (associatedModel.isSaved()) {
            baseObj.addAssociatedModelWithFK(associatedModel.getTableName(), associatedModel.getBaseObjId());
            baseObj.addAssociatedModelWithoutFK(associatedModel.getTableName(), associatedModel.getBaseObjId());
        }
    }

    private void unidirectionalCondition(DataSupport baseObj, DataSupport associatedModel) {
        this.dealsAssociationsOnTheSideWithoutFK(baseObj, associatedModel);
    }
}

