/*
 * Decompiled with CFR 0.152.
 */
package org.litepal.crud;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.litepal.crud.AssociationsAnalyzer;
import org.litepal.crud.DataSupport;
import org.litepal.crud.model.AssociationsInfo;
import org.litepal.util.DBUtility;

class Many2OneAnalyzer
extends AssociationsAnalyzer {
    Many2OneAnalyzer() {
    }

    void analyze(DataSupport baseObj, AssociationsInfo associationInfo) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (baseObj.getClassName().equals(associationInfo.getClassHoldsForeignKey())) {
            this.analyzeManySide(baseObj, associationInfo);
        } else {
            this.analyzeOneSide(baseObj, associationInfo);
        }
    }

    private void analyzeManySide(DataSupport baseObj, AssociationsInfo associationInfo) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        DataSupport associatedModel = this.getAssociatedModel(baseObj, associationInfo);
        if (associatedModel != null) {
            Collection<DataSupport> tempCollection = this.getReverseAssociatedModels(associatedModel, associationInfo);
            Collection<DataSupport> reverseAssociatedModels = this.checkAssociatedModelCollection(tempCollection, associationInfo.getAssociateSelfFromOtherModel());
            this.setReverseAssociatedModels(associatedModel, associationInfo, reverseAssociatedModels);
            this.dealAssociatedModelOnManySide(reverseAssociatedModels, baseObj, associatedModel);
        } else {
            this.mightClearFKValue(baseObj, associationInfo);
        }
    }

    private void analyzeOneSide(DataSupport baseObj, AssociationsInfo associationInfo) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Collection<DataSupport> associatedModels = this.getAssociatedModels(baseObj, associationInfo);
        if (associatedModels == null || associatedModels.isEmpty()) {
            String tableName = DBUtility.getTableNameByClassName(associationInfo.getAssociatedClassName());
            baseObj.addAssociatedTableNameToClearFK(tableName);
            return;
        }
        for (DataSupport associatedModel : associatedModels) {
            this.buildBidirectionalAssociations(baseObj, associatedModel, associationInfo);
            this.dealAssociatedModelOnOneSide(baseObj, associatedModel);
        }
    }

    private void dealAssociatedModelOnManySide(Collection<DataSupport> associatedModels, DataSupport baseObj, DataSupport associatedModel) {
        if (!associatedModels.contains(baseObj)) {
            associatedModels.add(baseObj);
        }
        if (associatedModel.isSaved()) {
            baseObj.addAssociatedModelWithoutFK(associatedModel.getTableName(), associatedModel.getBaseObjId());
        }
    }

    private void dealAssociatedModelOnOneSide(DataSupport baseObj, DataSupport associatedModel) {
        this.dealsAssociationsOnTheSideWithoutFK(baseObj, associatedModel);
    }
}

