/*
 * Decompiled with CFR 0.152.
 */
package org.litepal.crud;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.litepal.crud.AssociationsAnalyzer;
import org.litepal.crud.DataSupport;
import org.litepal.crud.model.AssociationsInfo;
import org.litepal.tablemanager.Connector;
import org.litepal.util.BaseUtility;
import org.litepal.util.DBUtility;

public class Many2ManyAnalyzer
extends AssociationsAnalyzer {
    void analyze(DataSupport baseObj, AssociationsInfo associationInfo) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Collection<DataSupport> associatedModels = this.getAssociatedModels(baseObj, associationInfo);
        this.declareAssociations(baseObj, associationInfo);
        if (associatedModels != null) {
            for (DataSupport associatedModel : associatedModels) {
                Collection<DataSupport> tempCollection = this.getReverseAssociatedModels(associatedModel, associationInfo);
                Collection<DataSupport> reverseAssociatedModels = this.checkAssociatedModelCollection(tempCollection, associationInfo.getAssociateSelfFromOtherModel());
                this.addNewModelForAssociatedModel(reverseAssociatedModels, baseObj);
                this.setReverseAssociatedModels(associatedModel, associationInfo, reverseAssociatedModels);
                this.dealAssociatedModel(baseObj, associatedModel);
            }
        }
    }

    private void declareAssociations(DataSupport baseObj, AssociationsInfo associationInfo) {
        baseObj.addEmptyModelForJoinTable(this.getAssociatedTableName(associationInfo));
    }

    private void addNewModelForAssociatedModel(Collection<DataSupport> associatedModelCollection, DataSupport baseObj) {
        if (!associatedModelCollection.contains(baseObj)) {
            associatedModelCollection.add(baseObj);
        }
    }

    private void dealAssociatedModel(DataSupport baseObj, DataSupport associatedModel) {
        if (associatedModel.isSaved()) {
            baseObj.addAssociatedModelForJoinTable(associatedModel.getTableName(), associatedModel.getBaseObjId());
        }
    }

    private String getAssociatedTableName(AssociationsInfo associationInfo) {
        return BaseUtility.changeCase(DBUtility.getTableNameByClassName(associationInfo.getAssociatedClassName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private boolean isDataExists(DataSupport baseObj, DataSupport associatedModel) {
        boolean exists = false;
        SQLiteDatabase db = Connector.getDatabase();
        try (Cursor cursor = null;){
            cursor = db.query(this.getJoinTableName(baseObj, associatedModel), null, this.getSelection(baseObj, associatedModel), this.getSelectionArgs(baseObj, associatedModel), null, null, null);
            exists = cursor.getCount() > 0;
        }
        return exists;
    }

    private String getSelection(DataSupport baseObj, DataSupport associatedModel) {
        StringBuilder where = new StringBuilder();
        where.append(this.getForeignKeyColumnName(baseObj.getTableName()));
        where.append(" = ? and ");
        where.append(this.getForeignKeyColumnName(associatedModel.getTableName()));
        where.append(" = ?");
        return where.toString();
    }

    private String[] getSelectionArgs(DataSupport baseObj, DataSupport associatedModel) {
        return new String[]{String.valueOf(baseObj.getBaseObjId()), String.valueOf(associatedModel.getBaseObjId())};
    }

    private String getJoinTableName(DataSupport baseObj, DataSupport associatedModel) {
        return this.getIntermediateTableName(baseObj, associatedModel.getTableName());
    }
}

