/*
 * Decompiled with CFR 0.152.
 */
package org.litepal.crud;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.litepal.exceptions.DataSupportException;

class DynamicExecutor {
    private DynamicExecutor() {
    }

    static Object send(Object object, String methodName, Object[] parameters, Class<?> objectClass, Class<?>[] parameterTypes) throws SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        try {
            if (parameters == null) {
                parameters = new Object[]{};
            }
            if (parameterTypes == null) {
                parameterTypes = new Class[]{};
            }
            Method method = objectClass.getDeclaredMethod(methodName, parameterTypes);
            method.setAccessible(true);
            return method.invoke(object, parameters);
        }
        catch (NoSuchMethodException e) {
            throw new DataSupportException(DataSupportException.noSuchMethodException(objectClass.getSimpleName(), methodName));
        }
    }

    static void setField(Object object, String fieldName, Object value, Class<?> objectClass) throws SecurityException, IllegalArgumentException, IllegalAccessException {
        try {
            Field objectField = objectClass.getDeclaredField(fieldName);
            objectField.setAccessible(true);
            objectField.set(object, value);
        }
        catch (NoSuchFieldException e) {
            throw new DataSupportException(DataSupportException.noSuchFieldExceptioin(objectClass.getSimpleName(), fieldName));
        }
    }

    static Object getField(Object object, String fieldName, Class<?> objectClass) throws IllegalArgumentException, IllegalAccessException {
        try {
            Field objectField = objectClass.getDeclaredField(fieldName);
            objectField.setAccessible(true);
            return objectField.get(object);
        }
        catch (NoSuchFieldException e) {
            throw new DataSupportException(DataSupportException.noSuchFieldExceptioin(objectClass.getSimpleName(), fieldName));
        }
    }
}

