/*
 * Decompiled with CFR 0.152.
 */
package org.litepal.crud;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.litepal.crud.ClusterQuery;
import org.litepal.crud.DeleteHandler;
import org.litepal.crud.QueryHandler;
import org.litepal.crud.SaveHandler;
import org.litepal.crud.UpdateHandler;
import org.litepal.exceptions.DataSupportException;
import org.litepal.tablemanager.Connector;
import org.litepal.util.BaseUtility;

public class DataSupport {
    private long baseObjId;
    private Map<String, Set<Long>> associatedModelsMapWithFK;
    private Map<String, Long> associatedModelsMapWithoutFK;
    private Map<String, Set<Long>> associatedModelsMapForJoinTable;
    private List<String> listToClearSelfFK;
    private List<String> listToClearAssociatedFK;
    private List<String> fieldsToSetToDefault;

    public static synchronized ClusterQuery select(String ... columns) {
        ClusterQuery cQuery = new ClusterQuery();
        cQuery.mColumns = columns;
        return cQuery;
    }

    public static synchronized ClusterQuery where(String ... conditions) {
        ClusterQuery cQuery = new ClusterQuery();
        cQuery.mConditions = conditions;
        return cQuery;
    }

    public static synchronized ClusterQuery order(String column) {
        ClusterQuery cQuery = new ClusterQuery();
        cQuery.mOrderBy = column;
        return cQuery;
    }

    public static synchronized ClusterQuery limit(int value) {
        ClusterQuery cQuery = new ClusterQuery();
        cQuery.mLimit = String.valueOf(value);
        return cQuery;
    }

    public static synchronized ClusterQuery offset(int value) {
        ClusterQuery cQuery = new ClusterQuery();
        cQuery.mOffset = String.valueOf(value);
        return cQuery;
    }

    public static synchronized int count(Class<?> modelClass) {
        return DataSupport.count(BaseUtility.changeCase(modelClass.getSimpleName()));
    }

    public static synchronized int count(String tableName) {
        ClusterQuery cQuery = new ClusterQuery();
        return cQuery.count(tableName);
    }

    public static synchronized double average(Class<?> modelClass, String column) {
        return DataSupport.average(BaseUtility.changeCase(modelClass.getSimpleName()), column);
    }

    public static synchronized double average(String tableName, String column) {
        ClusterQuery cQuery = new ClusterQuery();
        return cQuery.average(tableName, column);
    }

    public static synchronized <T> T max(Class<?> modelClass, String columnName, Class<T> columnType) {
        return DataSupport.max(BaseUtility.changeCase(modelClass.getSimpleName()), columnName, columnType);
    }

    public static synchronized <T> T max(String tableName, String columnName, Class<T> columnType) {
        ClusterQuery cQuery = new ClusterQuery();
        return cQuery.max(tableName, columnName, columnType);
    }

    public static synchronized <T> T min(Class<?> modelClass, String columnName, Class<T> columnType) {
        return DataSupport.min(BaseUtility.changeCase(modelClass.getSimpleName()), columnName, columnType);
    }

    public static synchronized <T> T min(String tableName, String columnName, Class<T> columnType) {
        ClusterQuery cQuery = new ClusterQuery();
        return cQuery.min(tableName, columnName, columnType);
    }

    public static synchronized <T> T sum(Class<?> modelClass, String columnName, Class<T> columnType) {
        return DataSupport.sum(BaseUtility.changeCase(modelClass.getSimpleName()), columnName, columnType);
    }

    public static synchronized <T> T sum(String tableName, String columnName, Class<T> columnType) {
        ClusterQuery cQuery = new ClusterQuery();
        return cQuery.sum(tableName, columnName, columnType);
    }

    public static synchronized <T> T find(Class<T> modelClass, long id) {
        return DataSupport.find(modelClass, id, false);
    }

    public static synchronized <T> T find(Class<T> modelClass, long id, boolean isEager) {
        QueryHandler queryHandler = new QueryHandler(Connector.getDatabase());
        return queryHandler.onFind(modelClass, id, isEager);
    }

    public static synchronized <T> T findFirst(Class<T> modelClass) {
        return DataSupport.findFirst(modelClass, false);
    }

    public static synchronized <T> T findFirst(Class<T> modelClass, boolean isEager) {
        QueryHandler queryHandler = new QueryHandler(Connector.getDatabase());
        return queryHandler.onFindFirst(modelClass, isEager);
    }

    public static synchronized <T> T findLast(Class<T> modelClass) {
        return DataSupport.findLast(modelClass, false);
    }

    public static synchronized <T> T findLast(Class<T> modelClass, boolean isEager) {
        QueryHandler queryHandler = new QueryHandler(Connector.getDatabase());
        return queryHandler.onFindLast(modelClass, isEager);
    }

    public static synchronized <T> List<T> findAll(Class<T> modelClass, long ... ids) {
        return DataSupport.findAll(modelClass, false, ids);
    }

    public static synchronized <T> List<T> findAll(Class<T> modelClass, boolean isEager, long ... ids) {
        QueryHandler queryHandler = new QueryHandler(Connector.getDatabase());
        return queryHandler.onFindAll(modelClass, isEager, ids);
    }

    public static synchronized Cursor findBySQL(String ... sql) {
        String[] selectionArgs;
        BaseUtility.checkConditionsCorrect(sql);
        if (sql == null) {
            return null;
        }
        if (sql.length <= 0) {
            return null;
        }
        if (sql.length == 1) {
            selectionArgs = null;
        } else {
            selectionArgs = new String[sql.length - 1];
            System.arraycopy(sql, 1, selectionArgs, 0, sql.length - 1);
        }
        return Connector.getDatabase().rawQuery(sql[0], selectionArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int delete(Class<?> modelClass, long id) {
        int rowsAffected = 0;
        SQLiteDatabase db = Connector.getDatabase();
        db.beginTransaction();
        try {
            DeleteHandler deleteHandler = new DeleteHandler(db);
            rowsAffected = deleteHandler.onDelete(modelClass, id);
            db.setTransactionSuccessful();
            int n = rowsAffected;
            return n;
        }
        finally {
            db.endTransaction();
        }
    }

    public static synchronized int deleteAll(Class<?> modelClass, String ... conditions) {
        DeleteHandler deleteHandler = new DeleteHandler(Connector.getDatabase());
        return deleteHandler.onDeleteAll(modelClass, conditions);
    }

    public static synchronized int deleteAll(String tableName, String ... conditions) {
        DeleteHandler deleteHandler = new DeleteHandler(Connector.getDatabase());
        return deleteHandler.onDeleteAll(tableName, conditions);
    }

    public static synchronized int update(Class<?> modelClass, ContentValues values, long id) {
        UpdateHandler updateHandler = new UpdateHandler(Connector.getDatabase());
        return updateHandler.onUpdate(modelClass, id, values);
    }

    public static synchronized int updateAll(Class<?> modelClass, ContentValues values, String ... conditions) {
        return DataSupport.updateAll(BaseUtility.changeCase(modelClass.getSimpleName()), values, conditions);
    }

    public static synchronized int updateAll(String tableName, ContentValues values, String ... conditions) {
        UpdateHandler updateHandler = new UpdateHandler(Connector.getDatabase());
        return updateHandler.onUpdateAll(tableName, values, conditions);
    }

    public static synchronized <T extends DataSupport> void saveAll(Collection<T> collection) {
        SQLiteDatabase db = Connector.getDatabase();
        db.beginTransaction();
        try {
            SaveHandler saveHandler = new SaveHandler(db);
            saveHandler.onSaveAll(collection);
            db.setTransactionSuccessful();
        }
        catch (Exception e) {
            throw new DataSupportException(e.getMessage());
        }
        finally {
            db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int delete() {
        SQLiteDatabase db = Connector.getDatabase();
        db.beginTransaction();
        try {
            DeleteHandler deleteHandler = new DeleteHandler(db);
            int rowsAffected = deleteHandler.onDelete(this);
            this.baseObjId = 0L;
            db.setTransactionSuccessful();
            int n = rowsAffected;
            return n;
        }
        finally {
            db.endTransaction();
        }
    }

    public synchronized int update(long id) {
        try {
            UpdateHandler updateHandler = new UpdateHandler(Connector.getDatabase());
            int rowsAffected = updateHandler.onUpdate(this, id);
            this.getFieldsToSetToDefault().clear();
            return rowsAffected;
        }
        catch (Exception e) {
            throw new DataSupportException(e.getMessage());
        }
    }

    public synchronized int updateAll(String ... conditions) {
        try {
            UpdateHandler updateHandler = new UpdateHandler(Connector.getDatabase());
            int rowsAffected = updateHandler.onUpdateAll(this, conditions);
            this.getFieldsToSetToDefault().clear();
            return rowsAffected;
        }
        catch (Exception e) {
            throw new DataSupportException(e.getMessage());
        }
    }

    public synchronized boolean save() {
        try {
            this.saveThrows();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public synchronized void saveThrows() {
        SQLiteDatabase db = Connector.getDatabase();
        db.beginTransaction();
        try {
            SaveHandler saveHandler = new SaveHandler(db);
            saveHandler.onSave(this);
            this.clearAssociatedData();
            db.setTransactionSuccessful();
        }
        catch (Exception e) {
            throw new DataSupportException(e.getMessage());
        }
        finally {
            db.endTransaction();
        }
    }

    public boolean isSaved() {
        return this.baseObjId > 0L;
    }

    public void setToDefault(String fieldName) {
        this.getFieldsToSetToDefault().add(fieldName);
    }

    protected DataSupport() {
    }

    protected long getBaseObjId() {
        return this.baseObjId;
    }

    protected String getClassName() {
        return this.getClass().getName();
    }

    protected String getTableName() {
        return BaseUtility.changeCase(this.getClass().getSimpleName());
    }

    void resetBaseObjId() {
        this.baseObjId = 0L;
    }

    List<String> getFieldsToSetToDefault() {
        if (this.fieldsToSetToDefault == null) {
            this.fieldsToSetToDefault = new ArrayList<String>();
        }
        return this.fieldsToSetToDefault;
    }

    void addAssociatedModelWithFK(String associatedTableName, long associatedId) {
        Set<Long> associatedIdsWithFKSet = this.getAssociatedModelsMapWithFK().get(associatedTableName);
        if (associatedIdsWithFKSet == null) {
            associatedIdsWithFKSet = new HashSet<Long>();
            associatedIdsWithFKSet.add(associatedId);
            this.associatedModelsMapWithFK.put(associatedTableName, associatedIdsWithFKSet);
        } else {
            associatedIdsWithFKSet.add(associatedId);
        }
    }

    Map<String, Set<Long>> getAssociatedModelsMapWithFK() {
        if (this.associatedModelsMapWithFK == null) {
            this.associatedModelsMapWithFK = new HashMap<String, Set<Long>>();
        }
        return this.associatedModelsMapWithFK;
    }

    void addAssociatedModelForJoinTable(String associatedModelName, long associatedId) {
        Set<Long> associatedIdsM2MSet = this.getAssociatedModelsMapForJoinTable().get(associatedModelName);
        if (associatedIdsM2MSet == null) {
            associatedIdsM2MSet = new HashSet<Long>();
            associatedIdsM2MSet.add(associatedId);
            this.associatedModelsMapForJoinTable.put(associatedModelName, associatedIdsM2MSet);
        } else {
            associatedIdsM2MSet.add(associatedId);
        }
    }

    void addEmptyModelForJoinTable(String associatedModelName) {
        Set<Long> associatedIdsM2MSet = this.getAssociatedModelsMapForJoinTable().get(associatedModelName);
        if (associatedIdsM2MSet == null) {
            associatedIdsM2MSet = new HashSet<Long>();
            this.associatedModelsMapForJoinTable.put(associatedModelName, associatedIdsM2MSet);
        }
    }

    Map<String, Set<Long>> getAssociatedModelsMapForJoinTable() {
        if (this.associatedModelsMapForJoinTable == null) {
            this.associatedModelsMapForJoinTable = new HashMap<String, Set<Long>>();
        }
        return this.associatedModelsMapForJoinTable;
    }

    void addAssociatedModelWithoutFK(String associatedTableName, long associatedId) {
        this.getAssociatedModelsMapWithoutFK().put(associatedTableName, associatedId);
    }

    Map<String, Long> getAssociatedModelsMapWithoutFK() {
        if (this.associatedModelsMapWithoutFK == null) {
            this.associatedModelsMapWithoutFK = new HashMap<String, Long>();
        }
        return this.associatedModelsMapWithoutFK;
    }

    void addFKNameToClearSelf(String foreignKeyName) {
        List<String> list = this.getListToClearSelfFK();
        if (!list.contains(foreignKeyName)) {
            list.add(foreignKeyName);
        }
    }

    List<String> getListToClearSelfFK() {
        if (this.listToClearSelfFK == null) {
            this.listToClearSelfFK = new ArrayList<String>();
        }
        return this.listToClearSelfFK;
    }

    void addAssociatedTableNameToClearFK(String associatedTableName) {
        List<String> list = this.getListToClearAssociatedFK();
        if (!list.contains(associatedTableName)) {
            list.add(associatedTableName);
        }
    }

    List<String> getListToClearAssociatedFK() {
        if (this.listToClearAssociatedFK == null) {
            this.listToClearAssociatedFK = new ArrayList<String>();
        }
        return this.listToClearAssociatedFK;
    }

    void clearAssociatedData() {
        this.clearIdOfModelWithFK();
        this.clearIdOfModelWithoutFK();
        this.clearIdOfModelForJoinTable();
        this.clearFKNameList();
    }

    private void clearIdOfModelWithFK() {
        for (String associatedModelName : this.getAssociatedModelsMapWithFK().keySet()) {
            this.associatedModelsMapWithFK.get(associatedModelName).clear();
        }
        this.associatedModelsMapWithFK.clear();
    }

    private void clearIdOfModelWithoutFK() {
        this.getAssociatedModelsMapWithoutFK().clear();
    }

    private void clearIdOfModelForJoinTable() {
        for (String associatedModelName : this.getAssociatedModelsMapForJoinTable().keySet()) {
            this.associatedModelsMapForJoinTable.get(associatedModelName).clear();
        }
        this.associatedModelsMapForJoinTable.clear();
    }

    private void clearFKNameList() {
        this.getListToClearSelfFK().clear();
        this.getListToClearAssociatedFK().clear();
    }
}

