/*
 * Decompiled with CFR 0.152.
 */
package org.litepal.crud;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.SparseArray;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.litepal.LitePalBase;
import org.litepal.crud.DataSupport;
import org.litepal.crud.DynamicExecutor;
import org.litepal.crud.Many2ManyAnalyzer;
import org.litepal.crud.Many2OneAnalyzer;
import org.litepal.crud.One2OneAnalyzer;
import org.litepal.crud.SaveHandler;
import org.litepal.crud.UpdateHandler;
import org.litepal.crud.model.AssociationsInfo;
import org.litepal.exceptions.DataSupportException;
import org.litepal.exceptions.DatabaseGenerateException;
import org.litepal.util.BaseUtility;
import org.litepal.util.DBUtility;

abstract class DataHandler
extends LitePalBase {
    public static final String TAG = "DataHandler";
    SQLiteDatabase mDatabase;
    private DataSupport tempEmptyModel;
    private List<AssociationsInfo> fkInCurrentModel;
    private List<AssociationsInfo> fkInOtherModel;

    DataHandler() {
    }

    protected <T> List<T> query(Class<T> modelClass, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit, List<AssociationsInfo> foreignKeyAssociations) {
        ArrayList<Object> dataList = new ArrayList<Object>();
        try (Cursor cursor = null;){
            List<Field> supportedFields = this.getSupportedFields(modelClass.getName());
            String tableName = this.getTableName(modelClass);
            String[] customizedColumns = this.getCustomizedColumns(columns, foreignKeyAssociations);
            cursor = this.mDatabase.query(tableName, customizedColumns, selection, selectionArgs, groupBy, having, orderBy, limit);
            if (cursor.moveToFirst()) {
                do {
                    Object modelInstance = this.createInstanceFromClass(modelClass);
                    this.giveBaseObjIdValue((DataSupport)modelInstance, cursor.getLong(cursor.getColumnIndexOrThrow("id")));
                    this.setValueToModel(modelInstance, supportedFields, foreignKeyAssociations, cursor);
                    if (foreignKeyAssociations != null) {
                        this.setAssociatedModel((DataSupport)modelInstance);
                    }
                    dataList.add(modelInstance);
                } while (cursor.moveToNext());
            }
            ArrayList<Object> arrayList = dataList;
            return arrayList;
        }
    }

    protected <T> T mathQuery(String tableName, String[] columns, String[] conditions, Class<T> type) {
        BaseUtility.checkConditionsCorrect(conditions);
        Object result = null;
        try (Cursor cursor = null;){
            cursor = this.mDatabase.query(tableName, columns, this.getWhereClause(conditions), this.getWhereArgs(conditions), null, null, null);
            if (cursor.moveToFirst()) {
                Class<?> cursorClass = cursor.getClass();
                Method method = cursorClass.getMethod(this.genGetColumnMethod(type), Integer.TYPE);
                result = method.invoke((Object)cursor, 0);
            }
        }
        return (T)result;
    }

    protected void giveBaseObjIdValue(DataSupport baseObj, long id) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        if (id > 0L) {
            DynamicExecutor.setField(baseObj, "baseObjId", id, DataSupport.class);
        }
    }

    protected void putFieldsValue(DataSupport baseObj, List<Field> supportedFields, ContentValues values) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        for (Field field : supportedFields) {
            if (this.isIdColumn(field.getName())) continue;
            this.putFieldsValueDependsOnSaveOrUpdate(baseObj, field, values);
        }
    }

    protected void putContentValues(DataSupport baseObj, Field field, ContentValues values) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object fieldValue = this.takeGetMethodValueByField(baseObj, field);
        if ("java.util.Date".equals(field.getType().getName()) && fieldValue != null) {
            Date date = (Date)fieldValue;
            fieldValue = date.getTime();
        }
        Object[] parameters = new Object[]{BaseUtility.changeCase(field.getName()), fieldValue};
        Class<?>[] parameterTypes = this.getParameterTypes(field, fieldValue, parameters);
        DynamicExecutor.send(values, "put", parameters, values.getClass(), parameterTypes);
    }

    protected Object takeGetMethodValueByField(DataSupport dataSupport, Field field) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.shouldGetOrSet(dataSupport, field)) {
            String getMethodName = this.makeGetterMethodName(field);
            return DynamicExecutor.send(dataSupport, getMethodName, null, dataSupport.getClass(), null);
        }
        return null;
    }

    protected void putSetMethodValueByField(DataSupport dataSupport, Field field, Object parameter) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.shouldGetOrSet(dataSupport, field)) {
            String setMethodName = this.makeSetterMethodName(field);
            DynamicExecutor.send(dataSupport, setMethodName, new Object[]{parameter}, dataSupport.getClass(), new Class[]{field.getType()});
        }
    }

    protected void analyzeAssociatedModels(DataSupport baseObj, Collection<AssociationsInfo> associationInfos) {
        try {
            for (AssociationsInfo associationInfo : associationInfos) {
                if (associationInfo.getAssociationType() == 2) {
                    new Many2OneAnalyzer().analyze(baseObj, associationInfo);
                    continue;
                }
                if (associationInfo.getAssociationType() == 1) {
                    new One2OneAnalyzer().analyze(baseObj, associationInfo);
                    continue;
                }
                if (associationInfo.getAssociationType() != 3) continue;
                new Many2ManyAnalyzer().analyze(baseObj, associationInfo);
            }
        }
        catch (Exception e) {
            throw new DataSupportException(e.getMessage());
        }
    }

    protected DataSupport getAssociatedModel(DataSupport baseObj, AssociationsInfo associationInfo) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (DataSupport)this.takeGetMethodValueByField(baseObj, associationInfo.getAssociateOtherModelFromSelf());
    }

    protected Collection<DataSupport> getAssociatedModels(DataSupport baseObj, AssociationsInfo associationInfo) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (Collection)this.takeGetMethodValueByField(baseObj, associationInfo.getAssociateOtherModelFromSelf());
    }

    protected DataSupport getEmptyModel(DataSupport baseObj) {
        if (this.tempEmptyModel != null) {
            return this.tempEmptyModel;
        }
        String className = null;
        try {
            className = baseObj.getClassName();
            Class<?> modelClass = Class.forName(className);
            this.tempEmptyModel = (DataSupport)modelClass.newInstance();
            return this.tempEmptyModel;
        }
        catch (ClassNotFoundException e) {
            throw new DatabaseGenerateException("can not find a class named " + className);
        }
        catch (InstantiationException e) {
            throw new DataSupportException(className + " needs a default constructor.");
        }
        catch (Exception e) {
            throw new DataSupportException(e.getMessage());
        }
    }

    protected String getWhereClause(String ... conditions) {
        if (this.isAffectAllLines(new Object[]{conditions})) {
            return null;
        }
        if (conditions != null && conditions.length > 0) {
            return conditions[0];
        }
        return null;
    }

    protected String[] getWhereArgs(String ... conditions) {
        if (this.isAffectAllLines(new Object[]{conditions})) {
            return null;
        }
        if (conditions != null && conditions.length > 1) {
            String[] whereArgs = new String[conditions.length - 1];
            System.arraycopy(conditions, 1, whereArgs, 0, conditions.length - 1);
            return whereArgs;
        }
        return null;
    }

    protected boolean isAffectAllLines(Object ... conditions) {
        return conditions != null && conditions.length == 0;
    }

    protected String getWhereOfIdsWithOr(Collection<Long> ids) {
        StringBuilder whereClause = new StringBuilder();
        boolean needOr = false;
        for (long id : ids) {
            if (needOr) {
                whereClause.append(" or ");
            }
            needOr = true;
            whereClause.append("id = ");
            whereClause.append(id);
        }
        return BaseUtility.changeCase(whereClause.toString());
    }

    protected String getWhereOfIdsWithOr(long ... ids) {
        StringBuilder whereClause = new StringBuilder();
        boolean needOr = false;
        for (long id : ids) {
            if (needOr) {
                whereClause.append(" or ");
            }
            needOr = true;
            whereClause.append("id = ");
            whereClause.append(id);
        }
        return BaseUtility.changeCase(whereClause.toString());
    }

    @Deprecated
    protected Class<?> findDataSupportClass(DataSupport baseObj) {
        Class<?> superClass = null;
        while ((superClass = baseObj.getClass().getSuperclass()) != null && DataSupport.class != superClass) {
        }
        if (superClass == null) {
            throw new DataSupportException(baseObj.getClass().getName() + " should be inherited from DataSupport");
        }
        return superClass;
    }

    protected boolean shouldGetOrSet(DataSupport dataSupport, Field field) {
        return dataSupport != null && field != null;
    }

    protected String getIntermediateTableName(DataSupport baseObj, String associatedTableName) {
        return BaseUtility.changeCase(DBUtility.getIntermediateTableName(baseObj.getTableName(), associatedTableName));
    }

    protected String getTableName(Class<?> modelClass) {
        return BaseUtility.changeCase(modelClass.getSimpleName());
    }

    protected Object createInstanceFromClass(Class<?> modelClass) {
        try {
            Constructor<?> constructor = this.findBestSuitConstructor(modelClass);
            return constructor.newInstance(this.getConstructorParams(modelClass, constructor));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DataSupportException(e.getMessage());
        }
    }

    protected Constructor<?> findBestSuitConstructor(Class<?> modelClass) {
        Constructor<?>[] constructors = modelClass.getDeclaredConstructors();
        SparseArray map = new SparseArray();
        int minKey = Integer.MAX_VALUE;
        for (Constructor<?> constructor : constructors) {
            Class<?>[] types;
            int key = constructor.getParameterTypes().length;
            for (Class<?> parameterType : types = constructor.getParameterTypes()) {
                if (parameterType != modelClass) continue;
                key += 10000;
            }
            if (map.get(key) == null) {
                map.put(key, constructor);
            }
            if (key >= minKey) continue;
            minKey = key;
        }
        Constructor bestSuitConstructor = (Constructor)map.get(minKey);
        if (bestSuitConstructor != null) {
            bestSuitConstructor.setAccessible(true);
        }
        return bestSuitConstructor;
    }

    protected Object[] getConstructorParams(Class<?> modelClass, Constructor<?> constructor) {
        Class<?>[] paramTypes = constructor.getParameterTypes();
        Object[] params = new Object[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            params[i] = this.getInitParamValue(modelClass, paramTypes[i]);
        }
        return params;
    }

    protected void setValueToModel(Object modelInstance, List<Field> supportedFields, List<AssociationsInfo> foreignKeyAssociations, Cursor cursor) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        for (Field field : supportedFields) {
            String getMethodName = this.genGetColumnMethod(field);
            String columnName = this.isIdColumn(field.getName()) ? "id" : field.getName();
            int columnIndex = cursor.getColumnIndex(BaseUtility.changeCase(columnName));
            if (columnIndex == -1) continue;
            Class<?> cursorClass = cursor.getClass();
            Method method = cursorClass.getMethod(getMethodName, Integer.TYPE);
            Object value = method.invoke((Object)cursor, columnIndex);
            if (this.isIdColumn(field.getName())) {
                DynamicExecutor.setField(modelInstance, field.getName(), value, modelInstance.getClass());
                continue;
            }
            if (field.getType() == Boolean.TYPE || field.getType() == Boolean.class) {
                if ("0".equals(String.valueOf(value))) {
                    value = false;
                } else if ("1".equals(String.valueOf(value))) {
                    value = true;
                }
            } else if (field.getType() == Character.TYPE || field.getType() == Character.class) {
                value = Character.valueOf(((String)value).charAt(0));
            } else if (field.getType() == Date.class) {
                long date = (Long)value;
                value = date <= 0L ? null : new Date(date);
            }
            this.putSetMethodValueByField((DataSupport)modelInstance, field, value);
        }
        if (foreignKeyAssociations != null) {
            for (AssociationsInfo associationInfo : foreignKeyAssociations) {
                String foreignKeyColumn = this.getForeignKeyColumnName(DBUtility.getTableNameByClassName(associationInfo.getAssociatedClassName()));
                int columnIndex = cursor.getColumnIndex(foreignKeyColumn);
                if (columnIndex == -1) continue;
                long associatedClassId = cursor.getLong(columnIndex);
                try {
                    DataSupport associatedObj = (DataSupport)DataSupport.find(Class.forName(associationInfo.getAssociatedClassName()), associatedClassId);
                    if (associatedObj == null) continue;
                    this.putSetMethodValueByField((DataSupport)modelInstance, associationInfo.getAssociateOtherModelFromSelf(), associatedObj);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected List<AssociationsInfo> getForeignKeyAssociations(String className, boolean isEager) {
        if (isEager) {
            this.analyzeAssociations(className);
            return this.fkInCurrentModel;
        }
        return null;
    }

    private Class<?>[] getParameterTypes(Field field, Object fieldValue, Object[] parameters) {
        Class[] parameterTypes;
        if (this.isCharType(field)) {
            parameters[1] = String.valueOf(fieldValue);
            parameterTypes = new Class[]{String.class, String.class};
        } else {
            parameterTypes = field.getType().isPrimitive() ? new Class[]{String.class, this.getObjectType(field.getType())} : ("java.util.Date".equals(field.getType().getName()) ? new Class[]{String.class, Long.class} : new Class[]{String.class, field.getType()});
        }
        return parameterTypes;
    }

    private Class<?> getObjectType(Class<?> primitiveType) {
        if (primitiveType != null && primitiveType.isPrimitive()) {
            String basicTypeName = primitiveType.getName();
            if ("int".equals(basicTypeName)) {
                return Integer.class;
            }
            if ("short".equals(basicTypeName)) {
                return Short.class;
            }
            if ("long".equals(basicTypeName)) {
                return Long.class;
            }
            if ("float".equals(basicTypeName)) {
                return Float.class;
            }
            if ("double".equals(basicTypeName)) {
                return Double.class;
            }
            if ("boolean".equals(basicTypeName)) {
                return Boolean.class;
            }
            if ("char".equals(basicTypeName)) {
                return Character.class;
            }
        }
        return null;
    }

    private Object getInitParamValue(Class<?> modelClass, Class<?> paramType) {
        String paramTypeName = paramType.getName();
        if ("boolean".equals(paramTypeName) || "java.lang.Boolean".equals(paramTypeName)) {
            return false;
        }
        if ("float".equals(paramTypeName) || "java.lang.Float".equals(paramTypeName)) {
            return Float.valueOf(0.0f);
        }
        if ("double".equals(paramTypeName) || "java.lang.Double".equals(paramTypeName)) {
            return 0.0;
        }
        if ("int".equals(paramTypeName) || "java.lang.Integer".equals(paramTypeName)) {
            return 0;
        }
        if ("long".equals(paramTypeName) || "java.lang.Long".equals(paramTypeName)) {
            return 0L;
        }
        if ("short".equals(paramTypeName) || "java.lang.Short".equals(paramTypeName)) {
            return 0;
        }
        if ("char".equals(paramTypeName) || "java.lang.Character".equals(paramTypeName)) {
            return Character.valueOf(' ');
        }
        if ("java.lang.String".equals(paramTypeName)) {
            return "";
        }
        if (modelClass == paramType) {
            return null;
        }
        return this.createInstanceFromClass(paramType);
    }

    private boolean isCharType(Field field) {
        String type = field.getType().getName();
        return type.equals("char") || type.endsWith("Character");
    }

    private boolean isPrimitiveBooleanType(Field field) {
        Class<?> fieldType = field.getType();
        return "boolean".equals(fieldType.getName());
    }

    private void putFieldsValueDependsOnSaveOrUpdate(DataSupport baseObj, Field field, ContentValues values) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (this.isUpdating()) {
            if (!this.isFieldWithDefaultValue(baseObj, field)) {
                this.putContentValues(baseObj, field, values);
            }
        } else if (this.isSaving()) {
            this.putContentValues(baseObj, field, values);
        }
    }

    private boolean isUpdating() {
        return UpdateHandler.class.getName().equals(this.getClass().getName());
    }

    private boolean isSaving() {
        return SaveHandler.class.getName().equals(this.getClass().getName());
    }

    private boolean isFieldWithDefaultValue(DataSupport baseObj, Field field) throws IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        DataSupport emptyModel = this.getEmptyModel(baseObj);
        Object realReturn = this.takeGetMethodValueByField(baseObj, field);
        Object defaultReturn = this.takeGetMethodValueByField(emptyModel, field);
        if (realReturn != null && defaultReturn != null) {
            String realFieldValue = this.takeGetMethodValueByField(baseObj, field).toString();
            String defaultFieldValue = this.takeGetMethodValueByField(emptyModel, field).toString();
            return realFieldValue.equals(defaultFieldValue);
        }
        return realReturn == defaultReturn;
    }

    private String makeGetterMethodName(Field field) {
        String getterMethodPrefix;
        String fieldName = field.getName();
        if (this.isPrimitiveBooleanType(field)) {
            if (fieldName.matches("^is[A-Z]{1}.*$")) {
                fieldName = fieldName.substring(2);
            }
            getterMethodPrefix = "is";
        } else {
            getterMethodPrefix = "get";
        }
        if (fieldName.matches("^[a-z]{1}[A-Z]{1}.*")) {
            return getterMethodPrefix + fieldName;
        }
        return getterMethodPrefix + BaseUtility.capitalize(fieldName);
    }

    private String makeSetterMethodName(Field field) {
        String setterMethodPrefix = "set";
        String setterMethodName = this.isPrimitiveBooleanType(field) && field.getName().matches("^is[A-Z]{1}.*$") ? setterMethodPrefix + field.getName().substring(2) : (field.getName().matches("^[a-z]{1}[A-Z]{1}.*") ? setterMethodPrefix + field.getName() : setterMethodPrefix + BaseUtility.capitalize(field.getName()));
        return setterMethodName;
    }

    private String genGetColumnMethod(Field field) {
        return this.genGetColumnMethod(field.getType());
    }

    private String genGetColumnMethod(Class<?> fieldType) {
        String typeName = fieldType.isPrimitive() ? BaseUtility.capitalize(fieldType.getName()) : fieldType.getSimpleName();
        String methodName = "get" + typeName;
        if ("getBoolean".equals(methodName)) {
            methodName = "getInt";
        } else if ("getChar".equals(methodName)) {
            methodName = "getString";
        } else if ("getDate".equals(methodName)) {
            methodName = "getLong";
        } else if ("getInteger".equals(methodName)) {
            methodName = "getInt";
        }
        return methodName;
    }

    private String[] getCustomizedColumns(String[] columns, List<AssociationsInfo> foreignKeyAssociations) {
        if (columns != null) {
            if (foreignKeyAssociations != null && foreignKeyAssociations.size() > 0) {
                String[] tempColumns = new String[columns.length + foreignKeyAssociations.size()];
                System.arraycopy(columns, 0, tempColumns, 0, columns.length);
                for (int i = 0; i < foreignKeyAssociations.size(); ++i) {
                    String associatedTable = DBUtility.getTableNameByClassName(foreignKeyAssociations.get(i).getAssociatedClassName());
                    tempColumns[columns.length + i] = this.getForeignKeyColumnName(associatedTable);
                }
                columns = tempColumns;
            }
            for (int i = 0; i < columns.length; ++i) {
                String columnName = columns[i];
                if (!this.isIdColumn(columnName)) continue;
                if ("_id".equalsIgnoreCase(columnName)) {
                    columns[i] = BaseUtility.changeCase("id");
                }
                return columns;
            }
            String[] customizedColumns = new String[columns.length + 1];
            System.arraycopy(columns, 0, customizedColumns, 0, columns.length);
            customizedColumns[columns.length] = BaseUtility.changeCase("id");
            return customizedColumns;
        }
        return null;
    }

    private void analyzeAssociations(String className) {
        Collection<AssociationsInfo> associationInfos = this.getAssociationInfo(className);
        if (this.fkInCurrentModel == null) {
            this.fkInCurrentModel = new ArrayList<AssociationsInfo>();
        } else {
            this.fkInCurrentModel.clear();
        }
        if (this.fkInOtherModel == null) {
            this.fkInOtherModel = new ArrayList<AssociationsInfo>();
        } else {
            this.fkInOtherModel.clear();
        }
        for (AssociationsInfo associationInfo : associationInfos) {
            if (associationInfo.getAssociationType() == 2 || associationInfo.getAssociationType() == 1) {
                if (associationInfo.getClassHoldsForeignKey().equals(className)) {
                    this.fkInCurrentModel.add(associationInfo);
                    continue;
                }
                this.fkInOtherModel.add(associationInfo);
                continue;
            }
            if (associationInfo.getAssociationType() != 3) continue;
            this.fkInOtherModel.add(associationInfo);
        }
    }

    private void setAssociatedModel(DataSupport baseObj) {
        if (this.fkInOtherModel == null) {
            return;
        }
        for (AssociationsInfo info : this.fkInOtherModel) {
            Cursor cursor = null;
            String associatedClassName = info.getAssociatedClassName();
            boolean isM2M = info.getAssociationType() == 3;
            try {
                String associatedTableName;
                List<Field> supportedFields = this.getSupportedFields(associatedClassName);
                if (isM2M) {
                    String tableName = baseObj.getTableName();
                    associatedTableName = DBUtility.getTableNameByClassName(associatedClassName);
                    String intermediateTableName = DBUtility.getIntermediateTableName(tableName, associatedTableName);
                    StringBuilder sql = new StringBuilder();
                    sql.append("select * from ").append(associatedTableName).append(" a inner join ").append(intermediateTableName).append(" b on a.id = b.").append(associatedTableName + "_id").append(" where b.").append(tableName).append("_id = ?");
                    cursor = DataSupport.findBySQL(BaseUtility.changeCase(sql.toString()), String.valueOf(baseObj.getBaseObjId()));
                } else {
                    String foreignKeyColumn = this.getForeignKeyColumnName(DBUtility.getTableNameByClassName(info.getSelfClassName()));
                    associatedTableName = DBUtility.getTableNameByClassName(associatedClassName);
                    cursor = this.mDatabase.query(BaseUtility.changeCase(associatedTableName), null, foreignKeyColumn + "=?", new String[]{String.valueOf(baseObj.getBaseObjId())}, null, null, null, null);
                }
                if (!cursor.moveToFirst()) continue;
                do {
                    DataSupport modelInstance = (DataSupport)this.createInstanceFromClass(Class.forName(associatedClassName));
                    this.giveBaseObjIdValue(modelInstance, cursor.getLong(cursor.getColumnIndexOrThrow("id")));
                    this.setValueToModel(modelInstance, supportedFields, null, cursor);
                    if (info.getAssociationType() == 2 || isM2M) {
                        Collection collection = (Collection)this.takeGetMethodValueByField(baseObj, info.getAssociateOtherModelFromSelf());
                        collection.add(modelInstance);
                        continue;
                    }
                    if (info.getAssociationType() != 1) continue;
                    this.putSetMethodValueByField(baseObj, info.getAssociateOtherModelFromSelf(), modelInstance);
                } while (cursor.moveToNext());
            }
            catch (Exception e) {
                throw new DataSupportException(e.getMessage());
            }
            finally {
                if (cursor == null) continue;
                cursor.close();
            }
        }
    }
}

