/*
 * Decompiled with CFR 0.152.
 */
package org.litepal.crud;

import java.util.List;
import org.litepal.crud.QueryHandler;
import org.litepal.tablemanager.Connector;
import org.litepal.util.BaseUtility;

public class ClusterQuery {
    String[] mColumns;
    String[] mConditions;
    String mOrderBy;
    String mLimit;
    String mOffset;

    ClusterQuery() {
    }

    public ClusterQuery select(String ... columns) {
        this.mColumns = columns;
        return this;
    }

    public ClusterQuery where(String ... conditions) {
        this.mConditions = conditions;
        return this;
    }

    public ClusterQuery order(String column) {
        this.mOrderBy = column;
        return this;
    }

    public ClusterQuery limit(int value) {
        this.mLimit = String.valueOf(value);
        return this;
    }

    public ClusterQuery offset(int value) {
        this.mOffset = String.valueOf(value);
        return this;
    }

    public <T> List<T> find(Class<T> modelClass) {
        return this.find(modelClass, false);
    }

    public synchronized <T> List<T> find(Class<T> modelClass, boolean isEager) {
        String limit;
        QueryHandler queryHandler = new QueryHandler(Connector.getDatabase());
        if (this.mOffset == null) {
            limit = this.mLimit;
        } else {
            if (this.mLimit == null) {
                this.mLimit = "0";
            }
            limit = this.mOffset + "," + this.mLimit;
        }
        return queryHandler.onFind(modelClass, this.mColumns, this.mConditions, this.mOrderBy, limit, isEager);
    }

    public synchronized int count(Class<?> modelClass) {
        return this.count(BaseUtility.changeCase(modelClass.getSimpleName()));
    }

    public synchronized int count(String tableName) {
        QueryHandler queryHandler = new QueryHandler(Connector.getDatabase());
        return queryHandler.onCount(tableName, this.mConditions);
    }

    public synchronized double average(Class<?> modelClass, String column) {
        return this.average(BaseUtility.changeCase(modelClass.getSimpleName()), column);
    }

    public synchronized double average(String tableName, String column) {
        QueryHandler queryHandler = new QueryHandler(Connector.getDatabase());
        return queryHandler.onAverage(tableName, column, this.mConditions);
    }

    public synchronized <T> T max(Class<?> modelClass, String columnName, Class<T> columnType) {
        return this.max(BaseUtility.changeCase(modelClass.getSimpleName()), columnName, columnType);
    }

    public synchronized <T> T max(String tableName, String columnName, Class<T> columnType) {
        QueryHandler queryHandler = new QueryHandler(Connector.getDatabase());
        return queryHandler.onMax(tableName, columnName, this.mConditions, columnType);
    }

    public synchronized <T> T min(Class<?> modelClass, String columnName, Class<T> columnType) {
        return this.min(BaseUtility.changeCase(modelClass.getSimpleName()), columnName, columnType);
    }

    public synchronized <T> T min(String tableName, String columnName, Class<T> columnType) {
        QueryHandler queryHandler = new QueryHandler(Connector.getDatabase());
        return queryHandler.onMin(tableName, columnName, this.mConditions, columnType);
    }

    public synchronized <T> T sum(Class<?> modelClass, String columnName, Class<T> columnType) {
        return this.sum(BaseUtility.changeCase(modelClass.getSimpleName()), columnName, columnType);
    }

    public synchronized <T> T sum(String tableName, String columnName, Class<T> columnType) {
        QueryHandler queryHandler = new QueryHandler(Connector.getDatabase());
        return queryHandler.onSum(tableName, columnName, this.mConditions, columnType);
    }
}

