/*
 * Decompiled with CFR 0.152.
 */
package org.litepal;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.litepal.crud.model.AssociationsInfo;
import org.litepal.exceptions.DatabaseGenerateException;
import org.litepal.parser.LitePalAttr;
import org.litepal.tablemanager.model.AssociationsModel;
import org.litepal.tablemanager.model.TableModel;
import org.litepal.tablemanager.typechange.BooleanOrm;
import org.litepal.tablemanager.typechange.DateOrm;
import org.litepal.tablemanager.typechange.DecimalOrm;
import org.litepal.tablemanager.typechange.NumericOrm;
import org.litepal.tablemanager.typechange.OrmChange;
import org.litepal.tablemanager.typechange.TextOrm;
import org.litepal.util.BaseUtility;
import org.litepal.util.DBUtility;

public abstract class LitePalBase {
    public static final String TAG = "LitePalBase";
    private static final int GET_ASSOCIATIONS_ACTION = 1;
    private static final int GET_ASSOCIATION_INFO_ACTION = 2;
    private OrmChange[] typeChangeRules = new OrmChange[]{new NumericOrm(), new TextOrm(), new BooleanOrm(), new DecimalOrm(), new DateOrm()};
    private Collection<AssociationsModel> mAssociationModels;
    private Collection<AssociationsInfo> mAssociationInfos;

    protected TableModel getTableModel(String className) {
        String tableName = DBUtility.getTableNameByClassName(className);
        TableModel tableModel = new TableModel();
        tableModel.setTableName(tableName);
        tableModel.setClassName(className);
        List<Field> supportedFields = this.getSupportedFields(className);
        block0: for (Field field : supportedFields) {
            String fieldName = field.getName();
            Class<?> fieldTypeClass = field.getType();
            String fieldType = fieldTypeClass.getName();
            String columnName = null;
            String columnType = null;
            for (OrmChange ormChange : this.typeChangeRules) {
                String[] relations = ormChange.object2Relation(className, fieldName, fieldType);
                if (relations == null) continue;
                columnName = relations[0];
                columnType = relations[1];
                tableModel.addColumn(columnName, columnType);
                continue block0;
            }
        }
        return tableModel;
    }

    protected Collection<AssociationsModel> getAssociations(List<String> classNames) {
        if (this.mAssociationModels == null) {
            this.mAssociationModels = new HashSet<AssociationsModel>();
        }
        this.mAssociationModels.clear();
        for (String className : classNames) {
            this.analyzeClassFields(className, 1);
        }
        return this.mAssociationModels;
    }

    protected Collection<AssociationsInfo> getAssociationInfo(String className) {
        if (this.mAssociationInfos == null) {
            this.mAssociationInfos = new HashSet<AssociationsInfo>();
        }
        this.mAssociationInfos.clear();
        this.analyzeClassFields(className, 2);
        return this.mAssociationInfos;
    }

    protected List<Field> getSupportedFields(String className) {
        Field[] fields;
        ArrayList<Field> supportedFields = new ArrayList<Field>();
        Class<?> dynamicClass = null;
        try {
            dynamicClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new DatabaseGenerateException("can not find a class named " + className);
        }
        for (Field field : fields = dynamicClass.getDeclaredFields()) {
            Class<?> fieldTypeClass;
            String fieldType;
            int modifiers = field.getModifiers();
            if (!Modifier.isPrivate(modifiers) || Modifier.isStatic(modifiers) || !BaseUtility.isFieldTypeSupported(fieldType = (fieldTypeClass = field.getType()).getName())) continue;
            supportedFields.add(field);
        }
        return supportedFields;
    }

    protected boolean isCollection(Class<?> fieldType) {
        return this.isList(fieldType) || this.isSet(fieldType);
    }

    protected boolean isList(Class<?> fieldType) {
        return List.class.isAssignableFrom(fieldType);
    }

    protected boolean isSet(Class<?> fieldType) {
        return Set.class.isAssignableFrom(fieldType);
    }

    protected boolean isIdColumn(String columnName) {
        return "_id".equalsIgnoreCase(columnName) || "id".equalsIgnoreCase(columnName);
    }

    protected String getForeignKeyColumnName(String associatedTableName) {
        return BaseUtility.changeCase(associatedTableName + "_id");
    }

    @Deprecated
    protected String whoHoldsForeignKey(String className, String associatedClassName) {
        String associatedTableName;
        String tableName = DBUtility.getTableNameByClassName(className);
        if (tableName.compareTo(associatedTableName = DBUtility.getTableNameByClassName(associatedClassName)) < 0) {
            return className;
        }
        return associatedClassName;
    }

    private void analyzeClassFields(String className, int action) {
        Class<?> dynamicClass = null;
        try {
            Field[] fields;
            dynamicClass = Class.forName(className);
            for (Field field : fields = dynamicClass.getDeclaredFields()) {
                if (!this.isPrivateAndNonPrimitive(field)) continue;
                this.oneToAnyConditions(className, field, action);
                this.manyToAnyConditions(className, field, action);
            }
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            throw new DatabaseGenerateException("can not find a class named " + className);
        }
    }

    private boolean isPrivateAndNonPrimitive(Field field) {
        return Modifier.isPrivate(field.getModifiers()) && !field.getType().isPrimitive();
    }

    private void oneToAnyConditions(String className, Field field, int action) throws ClassNotFoundException {
        Class<?> fieldTypeClass = field.getType();
        if (LitePalAttr.getInstance().getClassNames().contains(fieldTypeClass.getName())) {
            Class<?> reverseDynamicClass = Class.forName(fieldTypeClass.getName());
            Field[] reverseFields = reverseDynamicClass.getDeclaredFields();
            boolean reverseAssociations = false;
            for (int i = 0; i < reverseFields.length; ++i) {
                String genericTypeName;
                Field reverseField = reverseFields[i];
                if (!Modifier.isPrivate(reverseField.getModifiers())) continue;
                Class<?> reverseFieldTypeClass = reverseField.getType();
                if (className.equals(reverseFieldTypeClass.getName())) {
                    if (action == 1) {
                        this.addIntoAssociationModelCollection(className, fieldTypeClass.getName(), fieldTypeClass.getName(), 1);
                    } else if (action == 2) {
                        this.addIntoAssociationInfoCollection(className, fieldTypeClass.getName(), fieldTypeClass.getName(), field, reverseField, 1);
                    }
                    reverseAssociations = true;
                } else if (this.isCollection(reverseFieldTypeClass) && className.equals(genericTypeName = this.getGenericTypeName(reverseField))) {
                    if (action == 1) {
                        this.addIntoAssociationModelCollection(className, fieldTypeClass.getName(), className, 2);
                    } else if (action == 2) {
                        this.addIntoAssociationInfoCollection(className, fieldTypeClass.getName(), className, field, reverseField, 2);
                    }
                    reverseAssociations = true;
                }
                if (i != reverseFields.length - 1 || reverseAssociations) continue;
                if (action == 1) {
                    this.addIntoAssociationModelCollection(className, fieldTypeClass.getName(), fieldTypeClass.getName(), 1);
                    continue;
                }
                if (action != 2) continue;
                this.addIntoAssociationInfoCollection(className, fieldTypeClass.getName(), fieldTypeClass.getName(), field, null, 1);
            }
        }
    }

    private void manyToAnyConditions(String className, Field field, int action) throws ClassNotFoundException {
        if (this.isCollection(field.getType())) {
            String genericTypeName = this.getGenericTypeName(field);
            if (LitePalAttr.getInstance().getClassNames().contains(genericTypeName)) {
                Class<?> reverseDynamicClass = Class.forName(genericTypeName);
                Field[] reverseFields = reverseDynamicClass.getDeclaredFields();
                boolean reverseAssociations = false;
                for (int i = 0; i < reverseFields.length; ++i) {
                    String reverseGenericTypeName;
                    Field reverseField = reverseFields[i];
                    if (!Modifier.isPrivate(reverseField.getModifiers())) continue;
                    Class<?> reverseFieldTypeClass = reverseField.getType();
                    if (className.equals(reverseFieldTypeClass.getName())) {
                        if (action == 1) {
                            this.addIntoAssociationModelCollection(className, genericTypeName, genericTypeName, 2);
                        } else if (action == 2) {
                            this.addIntoAssociationInfoCollection(className, genericTypeName, genericTypeName, field, reverseField, 2);
                        }
                        reverseAssociations = true;
                    } else if (this.isCollection(reverseFieldTypeClass) && className.equals(reverseGenericTypeName = this.getGenericTypeName(reverseField))) {
                        if (action == 1) {
                            this.addIntoAssociationModelCollection(className, genericTypeName, null, 3);
                        } else if (action == 2) {
                            this.addIntoAssociationInfoCollection(className, genericTypeName, null, field, reverseField, 3);
                        }
                        reverseAssociations = true;
                    }
                    if (i != reverseFields.length - 1 || reverseAssociations) continue;
                    if (action == 1) {
                        this.addIntoAssociationModelCollection(className, genericTypeName, genericTypeName, 2);
                        continue;
                    }
                    if (action != 2) continue;
                    this.addIntoAssociationInfoCollection(className, genericTypeName, genericTypeName, field, null, 2);
                }
            }
        }
    }

    private void addIntoAssociationModelCollection(String className, String associatedClassName, String classHoldsForeignKey, int associationType) {
        AssociationsModel associationModel = new AssociationsModel();
        associationModel.setTableName(DBUtility.getTableNameByClassName(className));
        associationModel.setAssociatedTableName(DBUtility.getTableNameByClassName(associatedClassName));
        associationModel.setTableHoldsForeignKey(DBUtility.getTableNameByClassName(classHoldsForeignKey));
        associationModel.setAssociationType(associationType);
        this.mAssociationModels.add(associationModel);
    }

    private void addIntoAssociationInfoCollection(String selfClassName, String associatedClassName, String classHoldsForeignKey, Field associateOtherModelFromSelf, Field associateSelfFromOtherModel, int associationType) {
        AssociationsInfo associationInfo = new AssociationsInfo();
        associationInfo.setSelfClassName(selfClassName);
        associationInfo.setAssociatedClassName(associatedClassName);
        associationInfo.setClassHoldsForeignKey(classHoldsForeignKey);
        associationInfo.setAssociateOtherModelFromSelf(associateOtherModelFromSelf);
        associationInfo.setAssociateSelfFromOtherModel(associateSelfFromOtherModel);
        associationInfo.setAssociationType(associationType);
        this.mAssociationInfos.add(associationInfo);
    }

    private String getGenericTypeName(Field field) {
        Type genericType = field.getGenericType();
        if (genericType != null && genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Class genericArg = (Class)parameterizedType.getActualTypeArguments()[0];
            return genericArg.getName();
        }
        return null;
    }
}

