/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.tooling.apt.validator;

import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.linkki.tooling.apt.model.AptComponent;
import org.linkki.tooling.apt.model.AptComponentDeclaration;
import org.linkki.tooling.apt.model.AptPmo;
import org.linkki.tooling.apt.validator.Messages;
import org.linkki.tooling.apt.validator.Validator;

public abstract class MethodAnnotationValidator<T extends Annotation>
implements Validator {
    private final ProcessingEnvironment env;
    private final Class<T> annotationClass;

    protected MethodAnnotationValidator(ProcessingEnvironment env, Class<T> annotationClass) {
        this.env = Objects.requireNonNull(env, "env must not be null");
        this.annotationClass = Objects.requireNonNull(annotationClass, "annotationClass must not be null");
        if (annotationClass.getAnnotation(Repeatable.class) != null) {
            throw new IllegalArgumentException("annotationClass must not be repeatable");
        }
    }

    @Override
    public void validate(AptPmo pmo, Messager m) {
        for (AptComponent component : pmo.getComponents()) {
            for (AptComponentDeclaration declaration : component.getComponentDeclarations()) {
                T annotation = declaration.getElement().getAnnotation(this.annotationClass);
                if (annotation == null) continue;
                this.validate(annotation, declaration.getElement());
            }
        }
    }

    public abstract void validate(T var1, ExecutableElement var2);

    protected Types types() {
        return this.env.getTypeUtils();
    }

    protected Elements elements() {
        return this.env.getElementUtils();
    }

    protected void printError(ExecutableElement method, String annotationValue, String key) {
        AnnotationMirror annotation = this.getAnnotationMirror(method);
        AnnotationValue value = this.getAnnotationValue(annotation, annotationValue);
        String message = Messages.getString(key);
        this.env.getMessager().printMessage(Diagnostic.Kind.ERROR, message, method, annotation, value);
    }

    private AnnotationMirror getAnnotationMirror(ExecutableElement method) {
        TypeMirror annotationType = this.elements().getTypeElement(this.annotationClass.getCanonicalName()).asType();
        return method.getAnnotationMirrors().stream().filter(mirror -> this.types().isSameType(annotationType, mirror.getAnnotationType())).findFirst().orElseThrow(() -> new IllegalArgumentException("Method is not annotated with " + this.annotationClass.getCanonicalName()));
    }

    private AnnotationValue getAnnotationValue(AnnotationMirror annotation, String name) {
        return annotation.getElementValues().entrySet().stream().filter(entry -> ((ExecutableElement)entry.getKey()).getSimpleName().toString().equals(name)).map(Map.Entry::getValue).findFirst().orElseThrow(() -> new IllegalArgumentException("Annotation does not have a value with the name " + name));
    }
}

