/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.ips.decimalfield;

import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.binder.ValueContext;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.faktorips.values.Decimal;
import org.linkki.core.ui.converters.FormattedNumberToStringConverter;

public class FormattedDecimalFieldToStringConverter
extends FormattedNumberToStringConverter<Decimal> {
    public static final String DEFAULT_FORMAT = "#,##0.00##";
    private static final long serialVersionUID = 2694562525960273214L;

    public FormattedDecimalFieldToStringConverter() {
        this(DEFAULT_FORMAT);
    }

    public FormattedDecimalFieldToStringConverter(String format) {
        super(format);
    }

    protected Decimal convertToModel(Number value) {
        return Decimal.valueOf((Double)value.doubleValue());
    }

    @NonNull
    protected Decimal getNullValue() {
        return Decimal.NULL;
    }

    public Result<Decimal> convertToModel(@CheckForNull String value, ValueContext context) {
        return super.convertToModel(value, context);
    }

    public String convertToPresentation(@CheckForNull Decimal value, ValueContext context) {
        if (value == null || value.isNull()) {
            return this.getEmptyPresentation(context);
        }
        return super.convertToPresentation((Number)value, context);
    }
}

