/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.zookeeper.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatcherChain
implements Watcher {
    public static final String MODULE = WatcherChain.class.getName();
    public static final Logger log = LoggerFactory.getLogger((String)MODULE);
    private final Collection<Watcher> _watchers;

    public WatcherChain(Watcher ... watchers) {
        this(Arrays.asList(watchers));
    }

    public WatcherChain(Collection<Watcher> watchers) {
        this._watchers = watchers;
    }

    public void process(WatchedEvent event) {
        for (Watcher watcher : this._watchers) {
            try {
                watcher.process(event);
            }
            catch (Throwable th) {
                log.warn("Unexpected exception while processing event [" + event + "] for watcher [" + watcher + "] (ignored)", th);
            }
        }
    }

    public static Watcher createChain(Watcher ... watchers) {
        if (watchers == null || watchers.length == 0) {
            return null;
        }
        ArrayList<Watcher> list = new ArrayList<Watcher>();
        for (Watcher watcher : watchers) {
            if (watcher == null) continue;
            list.add(watcher);
        }
        if (list.size() == 1) {
            return (Watcher)list.get(0);
        }
        return new WatcherChain(list);
    }
}

