/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.zookeeper.server;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.linkedin.util.annotations.Initializable;
import org.linkedin.util.annotations.Initializer;
import org.linkedin.util.clock.Clock;
import org.linkedin.util.clock.SystemClock;
import org.linkedin.util.concurrent.ConcurrentUtils;
import org.linkedin.util.exceptions.InternalException;
import org.linkedin.util.lifecycle.Shutdownable;
import org.linkedin.util.lifecycle.Startable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneZooKeeperServer
implements Startable,
Shutdownable {
    public static final String MODULE = StandaloneZooKeeperServer.class.getName();
    public static final Logger log = LoggerFactory.getLogger((String)MODULE);
    @Initializable
    public Clock clock = SystemClock.INSTANCE;
    private String _tickTime;
    private int _clientPort;
    private String _dataDir;
    private Thread _mainThread;
    private volatile boolean _shutdown = false;
    private NIOServerCnxnFactory _cnxnFactory;
    private ZooKeeperServer _zkServer;

    public StandaloneZooKeeperServer(String tickTime, String dataDir, int clientPort) {
        this._dataDir = dataDir;
        this._clientPort = clientPort;
        this._tickTime = tickTime;
    }

    StandaloneZooKeeperServer() {
        this._tickTime = "2000";
        this._clientPort = 2120;
    }

    public int getClientPort() {
        return this._clientPort;
    }

    @Initializer
    public void setClientPort(int clientPort) {
        this._clientPort = clientPort;
    }

    public String getDataDir() {
        return this._dataDir;
    }

    @Initializer(required=true)
    public void setDataDir(String dataDir) {
        this._dataDir = dataDir;
    }

    public String getTickTime() {
        return this._tickTime;
    }

    @Initializer
    public void setTickTime(String tickTime) {
        this._tickTime = tickTime;
    }

    public synchronized void start() {
        try {
            QuorumPeerConfig qpc = new QuorumPeerConfig();
            Properties p = new Properties();
            p.setProperty("tickTime", this._tickTime);
            p.setProperty("clientPort", String.valueOf(this._clientPort));
            p.setProperty("dataDir", this._dataDir);
            qpc.parseProperties(p);
            ServerConfig serverConfig = new ServerConfig();
            serverConfig.readFrom(qpc);
            this.runFromConfig(serverConfig);
            this._mainThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        StandaloneZooKeeperServer.this._cnxnFactory.join();
                    }
                    catch (InterruptedException e) {
                        throw new InternalException((Throwable)e);
                    }
                }
            });
            this._mainThread.start();
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
    }

    private void runFromConfig(ServerConfig config) throws IOException {
        log.info("Starting server");
        try {
            this._zkServer = new ZooKeeperServer();
            FileTxnSnapLog ftxn = new FileTxnSnapLog(new File(config.getDataLogDir()), new File(config.getDataDir()));
            this._zkServer.setTxnLogFactory(ftxn);
            this._zkServer.setTickTime(config.getTickTime());
            this._zkServer.setMinSessionTimeout(config.getMinSessionTimeout());
            this._zkServer.setMaxSessionTimeout(config.getMaxSessionTimeout());
            this._cnxnFactory = new NIOServerCnxnFactory();
            this._cnxnFactory.configure(config.getClientPortAddress(), config.getMaxClientCnxns());
            this._cnxnFactory.startup(this._zkServer);
        }
        catch (InterruptedException e) {
            log.warn("Server interrupted", (Throwable)e);
        }
    }

    public synchronized void shutdown() {
        if (this._mainThread == null) {
            throw new IllegalStateException("not started");
        }
        if (this._shutdown) {
            return;
        }
        this._cnxnFactory.shutdown();
        this._shutdown = true;
    }

    public void waitForShutdown() throws InterruptedException, IllegalStateException {
        try {
            this.waitForShutdown(-1);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public void waitForShutdown(Object timeout) throws InterruptedException, IllegalStateException, TimeoutException {
        if (!this._shutdown) {
            throw new IllegalStateException("call shutdown first");
        }
        ConcurrentUtils.joinFor((Clock)this.clock, (Thread)this._mainThread, (Object)timeout);
    }
}

