/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.zookeeper.client;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.linkedin.util.io.PathUtils;
import org.linkedin.zookeeper.client.AbstractZooKeeper;
import org.linkedin.zookeeper.client.IZKClient;
import org.linkedin.zookeeper.client.ZKChildren;
import org.linkedin.zookeeper.client.ZKData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractZKClient
extends AbstractZooKeeper
implements IZKClient {
    public static final String MODULE = AbstractZKClient.class.getName();
    public static final Logger log = LoggerFactory.getLogger((String)MODULE);
    private static final String CHARSET = "UTF-8";

    public AbstractZKClient(String chroot) {
        super(chroot);
    }

    @Override
    public Stat exists(String path) throws InterruptedException, KeeperException {
        return this.exists(path, false);
    }

    @Override
    public List<String> getChildren(String path) throws InterruptedException, KeeperException {
        return this.getChildren(path, false);
    }

    @Override
    public ZKChildren getZKChildren(String path, Watcher watcher) throws KeeperException, InterruptedException {
        Stat stat = new Stat();
        List<String> children = this.getChildren(path, watcher, stat);
        return new ZKChildren(children, stat);
    }

    @Override
    public List<String> getAllChildren(String path) throws InterruptedException, KeeperException {
        return this.findAllChildren(path);
    }

    @Override
    public void create(String path, String data, List<ACL> acl, CreateMode createMode) throws InterruptedException, KeeperException {
        this.create(path, this.toByteData(data), acl, createMode);
    }

    @Override
    public void createBytesNode(String path, byte[] data, List<ACL> acl, CreateMode createMode) throws InterruptedException, KeeperException {
        this.create(path, data, acl, createMode);
    }

    @Override
    public void createWithParents(String path, String data, List<ACL> acl, CreateMode createMode) throws InterruptedException, KeeperException {
        this.createParents(path, acl);
        this.create(path, data, acl, createMode);
    }

    @Override
    public void createBytesNodeWithParents(String path, byte[] data, List<ACL> acl, CreateMode createMode) throws InterruptedException, KeeperException {
        this.createParents(path, acl);
        this.createBytesNode(path, data, acl, createMode);
    }

    @Override
    public byte[] getData(String path) throws InterruptedException, KeeperException {
        return this.getData(path, false, null);
    }

    @Override
    public String getStringData(String path) throws InterruptedException, KeeperException {
        return this.toStringData(this.getData(path, false, null));
    }

    private String toStringData(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] toByteData(String data) {
        if (data == null) {
            return null;
        }
        try {
            return data.getBytes(CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ZKData<String> getZKStringData(String path) throws InterruptedException, KeeperException {
        return this.getZKStringData(path, null);
    }

    @Override
    public ZKData<String> getZKStringData(String path, Watcher watcher) throws InterruptedException, KeeperException {
        ZKData<byte[]> zkData = this.getZKByteData(path, watcher);
        return new ZKData<String>(this.toStringData(zkData.getData()), zkData.getStat());
    }

    @Override
    public ZKData<byte[]> getZKByteData(String path) throws InterruptedException, KeeperException {
        return this.getZKByteData(path, null);
    }

    @Override
    public ZKData<byte[]> getZKByteData(String path, Watcher watcher) throws InterruptedException, KeeperException {
        Stat stat = new Stat();
        return new ZKData<byte[]>(this.getData(path, watcher, stat), stat);
    }

    @Override
    public Stat setData(String path, String data) throws InterruptedException, KeeperException {
        return this.setByteData(path, this.toByteData(data));
    }

    @Override
    public Stat setByteData(String path, byte[] data) throws InterruptedException, KeeperException {
        return this.setData(path, data, -1);
    }

    @Override
    public Stat createOrSetWithParents(String path, String data, List<ACL> acl, CreateMode createMode) throws InterruptedException, KeeperException {
        if (this.exists(path) != null) {
            return this.setData(path, data);
        }
        try {
            this.createWithParents(path, data, acl, createMode);
            return null;
        }
        catch (KeeperException.NodeExistsException e) {
            return this.setData(path, data);
        }
    }

    @Override
    public void delete(String path) throws InterruptedException, KeeperException {
        this.delete(path, -1);
    }

    @Override
    public void deleteWithChildren(String path) throws InterruptedException, KeeperException {
        List<String> allChildren = this.findAllChildren(path);
        for (String child : allChildren) {
            this.delete(PathUtils.addPaths((String)path, (String)child));
        }
        this.delete(path);
    }

    private void createParents(String path, List<ACL> acl) throws InterruptedException, KeeperException {
        path = PathUtils.getParentPath((String)this.adjustPath(path));
        path = PathUtils.removeTrailingSlash((String)path);
        ArrayList<String> paths = new ArrayList<String>();
        while (!path.equals("") && this.getZk().exists(path, false) == null) {
            paths.add(path);
            path = PathUtils.getParentPath((String)path);
            path = PathUtils.removeTrailingSlash((String)path);
        }
        Collections.reverse(paths);
        for (String p : paths) {
            try {
                this.getZk().create(p, null, acl, CreateMode.PERSISTENT);
            }
            catch (KeeperException.NodeExistsException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("parent already exists " + p);
            }
        }
    }

    private List<String> findAllChildren(String path) throws InterruptedException, KeeperException {
        ArrayList<String> allChildren = new ArrayList<String>();
        this.findAllChildren(path, null, allChildren);
        return allChildren;
    }

    private void findAllChildren(String path, String parentPath, List<String> allChildren) throws InterruptedException, KeeperException {
        List<String> directChildren = this.getChildren(path);
        Collections.sort(directChildren);
        for (String child : directChildren) {
            String childPath = parentPath == null ? child : PathUtils.addPaths((String)parentPath, (String)child);
            this.findAllChildren(PathUtils.addPaths((String)path, (String)child), childPath, allChildren);
            allChildren.add(childPath);
        }
    }
}

