/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.json.jackson;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.SerializerFactoryConfig;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.std.BooleanSerializer;
import com.fasterxml.jackson.databind.ser.std.NumberSerializers;
import com.fasterxml.jackson.databind.ser.std.StringSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import groovy.lang.GString;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class MetadataStyleSerializerFactory
extends BeanSerializerFactory {
    protected static final Map<String, JsonSerializer<?>> SERIALIZERS = new HashMap();

    public MetadataStyleSerializerFactory(SerializerFactoryConfig config) {
        super(MetadataStyleSerializerFactory.addGroovySerializers(config));
    }

    public MetadataStyleSerializerFactory() {
        this(null);
    }

    public JsonSerializer<Object> createSerializer(SerializerProvider prov, JavaType origType) throws JsonMappingException {
        JsonSerializer<?> serializer = SERIALIZERS.get(origType.getRawClass().getName());
        if (serializer != null) {
            return serializer;
        }
        if (origType.isContainerType()) {
            return super.createSerializer(prov, origType);
        }
        return ToStringSerializer.instance;
    }

    public static SerializerFactoryConfig addGroovySerializers(SerializerFactoryConfig config) {
        if (config == null) {
            config = new SerializerFactoryConfig();
        }
        SimpleSerializers serializers = new SimpleSerializers();
        serializers.addSerializer(GString.class, (JsonSerializer)ToStringSerializer.instance);
        config = config.withAdditionalSerializers((Serializers)serializers);
        return config;
    }

    static {
        NumberSerializers.IntLikeSerializer integerLikeSerializer = new NumberSerializers.IntLikeSerializer();
        NumberSerializers.IntegerSerializer integerSerializer = new NumberSerializers.IntegerSerializer();
        NumberSerializers.NumberSerializer numberSerializer = new NumberSerializers.NumberSerializer();
        NumberSerializers.LongSerializer longSerializer = new NumberSerializers.LongSerializer();
        NumberSerializers.FloatSerializer floatSerializer = new NumberSerializers.FloatSerializer();
        NumberSerializers.DoubleSerializer doubleSerializer = new NumberSerializers.DoubleSerializer();
        SERIALIZERS.put(Boolean.TYPE.getName(), (JsonSerializer<?>)new BooleanSerializer(true));
        SERIALIZERS.put(Boolean.class.getName(), (JsonSerializer<?>)new BooleanSerializer(false));
        SERIALIZERS.put(Character.TYPE.getName(), (JsonSerializer<?>)ToStringSerializer.instance);
        SERIALIZERS.put(Character.class.getName(), (JsonSerializer<?>)ToStringSerializer.instance);
        SERIALIZERS.put(Byte.TYPE.getName(), (JsonSerializer<?>)integerLikeSerializer);
        SERIALIZERS.put(Byte.class.getName(), (JsonSerializer<?>)integerLikeSerializer);
        SERIALIZERS.put(Short.TYPE.getName(), (JsonSerializer<?>)integerLikeSerializer);
        SERIALIZERS.put(Short.class.getName(), (JsonSerializer<?>)integerLikeSerializer);
        SERIALIZERS.put(Integer.TYPE.getName(), (JsonSerializer<?>)integerSerializer);
        SERIALIZERS.put(Integer.class.getName(), (JsonSerializer<?>)integerSerializer);
        SERIALIZERS.put(BigInteger.class.getName(), (JsonSerializer<?>)numberSerializer);
        SERIALIZERS.put(Long.TYPE.getName(), (JsonSerializer<?>)longSerializer);
        SERIALIZERS.put(Long.class.getName(), (JsonSerializer<?>)longSerializer);
        SERIALIZERS.put(Float.TYPE.getName(), (JsonSerializer<?>)floatSerializer);
        SERIALIZERS.put(Float.class.getName(), (JsonSerializer<?>)floatSerializer);
        SERIALIZERS.put(Double.TYPE.getName(), (JsonSerializer<?>)doubleSerializer);
        SERIALIZERS.put(Double.class.getName(), (JsonSerializer<?>)doubleSerializer);
        SERIALIZERS.put(BigDecimal.class.getName(), (JsonSerializer<?>)numberSerializer);
        SERIALIZERS.put(String.class.getName(), (JsonSerializer<?>)new StringSerializer());
    }
}

