/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.groovy.util.encryption;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.linkedin.groovy.util.encryption.EncryptedInputStream;
import org.linkedin.groovy.util.encryption.EncryptionUtils;
import org.linkedin.util.codec.Base64Codec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptionUtils
implements GroovyObject {
    private static final String ALGORITHM = "AES";
    private static final String MODE = "CBC";
    private static final String PADDING = "PKCS5Padding";
    private static final String KEYSTORETYPE = "JCEKS";
    private static final String CRYPTO;
    private static final SecureRandom RANDOM;
    private static final String ENCRYPTEDPREFIX;
    private static final String ENCRYPTEDSUFFIX;
    private static final String REGEXTOMATCH;
    private static final Pattern ENCRYPTEDPATTERN;
    private static final Base64Codec BASE64CODEC;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    public static /* synthetic */ long __timeStamp;
    public static /* synthetic */ long __timeStamp__239_neverHappen1364841017583;
    private static /* synthetic */ SoftReference $callSiteArray;

    public EncryptionUtils() {
        MetaClass metaClass;
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static void createSecretKey(File keyFile, String keyName, String keyStorePassword, String secretKeyPassword) throws GeneralSecurityException, IOException {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        boolean genKey = false;
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call((Object)keyFile))) {
            boolean bl;
            genKey = bl = true;
        } else {
            Map secretKeys = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].callStatic(EncryptionUtils.class, (Object)keyFile, (Object)keyStorePassword, (Object)secretKeyPassword), Map.class);
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].call((Object)secretKeys, (Object)keyName))) {
                boolean bl;
                genKey = bl = true;
            }
        }
        if (genKey) {
            KeyGenerator keyGen = (KeyGenerator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].call(KeyGenerator.class, (Object)ALGORITHM), KeyGenerator.class);
            callSiteArray[4].call((Object)keyGen, (Object)128);
            SecretKey sk = (SecretKey)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].call((Object)keyGen), SecretKey.class);
            callSiteArray[6].callStatic(EncryptionUtils.class, ArrayUtil.createArray((Object)sk, (Object)keyFile, (Object)keyName, (Object)keyStorePassword, (Object)secretKeyPassword));
        }
    }

    private static KeyStore loadKeyStore(File keyFile, String keyStorePassword) {
        KeyStore ks;
        block5: {
            CallSite[] callSiteArray;
            block4: {
                callSiteArray = EncryptionUtils.$getCallSiteArray();
                ks = (KeyStore)ScriptBytecodeAdapter.castToType((Object)callSiteArray[7].call(KeyStore.class, (Object)KEYSTORETYPE), KeyStore.class);
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[8].call((Object)keyFile))) break block4;
                FileInputStream fis = null;
                try {
                    Object object = callSiteArray[9].callConstructor(FileInputStream.class, (Object)keyFile);
                    fis = (FileInputStream)ScriptBytecodeAdapter.castToType((Object)object, FileInputStream.class);
                    callSiteArray[10].call((Object)ks, (Object)fis, callSiteArray[11].call((Object)keyStorePassword));
                }
                catch (Throwable throwable) {
                    if (ScriptBytecodeAdapter.compareNotEqual(fis, null)) {
                        callSiteArray[13].call(fis);
                    }
                    throw throwable;
                }
                if (ScriptBytecodeAdapter.compareNotEqual((Object)fis, null)) {
                    callSiteArray[12].call((Object)fis);
                }
                break block5;
            }
            callSiteArray[14].call((Object)ks, null, callSiteArray[15].call((Object)keyStorePassword));
        }
        return ks;
    }

    public static void saveSecretKey(SecretKey sk, File keyFile, String keyName, String keyStorePassword, String secretKeyPassword) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        KeyStore.SecretKeyEntry skEntry = (KeyStore.SecretKeyEntry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[16].callConstructor(KeyStore.SecretKeyEntry.class, (Object)sk), KeyStore.SecretKeyEntry.class);
        KeyStore ks = (KeyStore)ScriptBytecodeAdapter.castToType((Object)callSiteArray[17].callStatic(EncryptionUtils.class, (Object)keyFile, (Object)keyStorePassword), KeyStore.class);
        callSiteArray[18].call((Object)ks, (Object)keyName, (Object)skEntry, callSiteArray[19].callConstructor(KeyStore.PasswordProtection.class, callSiteArray[20].call((Object)secretKeyPassword)));
        FileOutputStream fos = null;
        try {
            Object object = callSiteArray[21].callConstructor(FileOutputStream.class, (Object)keyFile);
            fos = (FileOutputStream)ScriptBytecodeAdapter.castToType((Object)object, FileOutputStream.class);
            callSiteArray[22].call((Object)ks, (Object)fos, callSiteArray[23].call((Object)keyStorePassword));
        }
        catch (Throwable throwable) {
            if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareNotEqual(fos, null)) {
                    callSiteArray[26].call((Object)fos);
                }
            } else if (ScriptBytecodeAdapter.compareNotEqual((Object)fos, null)) {
                callSiteArray[27].call((Object)fos);
            }
            throw throwable;
        }
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)fos, null)) {
                callSiteArray[24].call((Object)fos);
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)fos, null)) {
            callSiteArray[25].call((Object)fos);
        }
    }

    public static SecretKey getSecretKey(File keyFile, String keyName, String keyStorePassword, String secretKeyPassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableEntryException {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        KeyStore ks = (KeyStore)ScriptBytecodeAdapter.castToType((Object)callSiteArray[28].callStatic(EncryptionUtils.class, (Object)keyFile, (Object)keyStorePassword), KeyStore.class);
        SecretKey sk = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[29].call((Object)ks, (Object)keyName))) {
            KeyStore.SecretKeyEntry skEntry = (KeyStore.SecretKeyEntry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[30].call((Object)ks, (Object)keyName, callSiteArray[31].callConstructor(KeyStore.PasswordProtection.class, callSiteArray[32].call((Object)secretKeyPassword))), KeyStore.SecretKeyEntry.class);
            Object object = callSiteArray[33].call((Object)skEntry);
            sk = (SecretKey)ScriptBytecodeAdapter.castToType((Object)object, SecretKey.class);
        }
        return sk;
    }

    public static Map<String, byte[]> getSecretKeys(String keyFileName, String keyStorePassword, String secretKeyPassword) {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        File keyFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[34].callConstructor(File.class, (Object)keyFileName), File.class);
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[35].callStatic(EncryptionUtils.class, (Object)keyFile, (Object)keyStorePassword, (Object)secretKeyPassword), Map.class);
    }

    public static Map<String, byte[]> getSecretKeys(File keyFile, String keyStorePassword, String secretKeyPassword) {
        Reference secretKeyPassword2 = new Reference((Object)secretKeyPassword);
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        Reference secretKeys = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        Reference ks = new Reference((Object)((KeyStore)ScriptBytecodeAdapter.castToType((Object)callSiteArray[36].callStatic(EncryptionUtils.class, (Object)keyFile, (Object)keyStorePassword), KeyStore.class)));
        callSiteArray[37].call(callSiteArray[38].call((Object)((KeyStore)ks.get())), (Object)new GeneratedClosure(EncryptionUtils.class, EncryptionUtils.class, secretKeyPassword2, secretKeys, ks){
            private /* synthetic */ Reference secretKeyPassword;
            private /* synthetic */ Reference secretKeys;
            private /* synthetic */ Reference ks;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _getSecretKeys_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.secretKeyPassword = reference3 = secretKeyPassword;
                this.secretKeys = reference2 = secretKeys;
                this.ks = reference = ks;
            }

            public Object doCall(Object alias) {
                CallSite[] callSiteArray = _getSecretKeys_closure1.$getCallSiteArray();
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(this.ks.get(), alias, KeyStore.SecretKeyEntry.class))) {
                    KeyStore.SecretKeyEntry skEntry = (KeyStore.SecretKeyEntry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].call(this.ks.get(), alias, callSiteArray[2].callConstructor(KeyStore.PasswordProtection.class, callSiteArray[3].call(this.secretKeyPassword.get()))), KeyStore.SecretKeyEntry.class);
                    return callSiteArray[4].call(this.secretKeys.get(), alias, callSiteArray[5].call(callSiteArray[6].call((Object)skEntry)));
                }
                return null;
            }

            public String getSecretKeyPassword() {
                CallSite[] callSiteArray = _getSecretKeys_closure1.$getCallSiteArray();
                return (String)ScriptBytecodeAdapter.castToType((Object)this.secretKeyPassword.get(), String.class);
            }

            public Object getSecretKeys() {
                CallSite[] callSiteArray = _getSecretKeys_closure1.$getCallSiteArray();
                return this.secretKeys.get();
            }

            public KeyStore getKs() {
                CallSite[] callSiteArray = _getSecretKeys_closure1.$getCallSiteArray();
                return (KeyStore)ScriptBytecodeAdapter.castToType((Object)this.ks.get(), KeyStore.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getSecretKeys_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = _getSecretKeys_closure1.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                _getSecretKeys_closure1.__$swapInit();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "entryInstanceOf";
                stringArray[1] = "getEntry";
                stringArray[2] = "<$constructor$>";
                stringArray[3] = "toCharArray";
                stringArray[4] = "put";
                stringArray[5] = "getEncoded";
                stringArray[6] = "getSecretKey";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[7];
                _getSecretKeys_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getSecretKeys_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getSecretKeys_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        return (Map)ScriptBytecodeAdapter.castToType((Object)secretKeys.get(), Map.class);
    }

    public static String encrypt(String value, Map<String, byte[]> secretKeys, String keyName) throws GeneralSecurityException, IOException {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        SecretKeySpec sks = (SecretKeySpec)ScriptBytecodeAdapter.castToType((Object)callSiteArray[39].callStatic(EncryptionUtils.class, secretKeys, (Object)keyName), SecretKeySpec.class);
        Cipher cipher = (Cipher)ScriptBytecodeAdapter.castToType((Object)callSiteArray[40].call(Cipher.class, (Object)CRYPTO), Cipher.class);
        Object iv = callSiteArray[41].callStatic(EncryptionUtils.class, (Object)cipher);
        callSiteArray[42].call((Object)cipher, callSiteArray[43].callGetProperty(Cipher.class), (Object)sks, callSiteArray[44].callConstructor(IvParameterSpec.class, iv), (Object)RANDOM);
        byte[] encrypted = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[45].call((Object)cipher, callSiteArray[46].call((Object)value)), byte[].class);
        return (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[47].callStatic(EncryptionUtils.class, (Object)encrypted, iv, (Object)keyName), String.class);
    }

    public static String decrypt(String message, Map<String, byte[]> secretKeys) throws GeneralSecurityException, IOException {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        byte[][] decoded = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[48].callStatic(EncryptionUtils.class, (Object)message);
            decoded = (byte[][])ScriptBytecodeAdapter.castToType((Object)object, byte[][].class);
        } else {
            byte[][] byArray;
            decoded = byArray = EncryptionUtils.decode(message);
        }
        byte[] toDecrypt = null;
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[49].call((Object)decoded, (Object)0);
            toDecrypt = (byte[])ScriptBytecodeAdapter.castToType((Object)object, byte[].class);
        } else {
            Object object = BytecodeInterface8.objectArrayGet((Object[])decoded, (int)0);
            toDecrypt = (byte[])ScriptBytecodeAdapter.castToType((Object)object, byte[].class);
        }
        byte[] usingIv = null;
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[50].call((Object)decoded, (Object)1);
            usingIv = (byte[])ScriptBytecodeAdapter.castToType((Object)object, byte[].class);
        } else {
            Object object = BytecodeInterface8.objectArrayGet((Object[])decoded, (int)1);
            usingIv = (byte[])ScriptBytecodeAdapter.castToType((Object)object, byte[].class);
        }
        String keyName = null;
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[51].callConstructor(String.class, callSiteArray[52].call((Object)decoded, (Object)2));
            keyName = (String)ScriptBytecodeAdapter.castToType((Object)object, String.class);
        } else {
            Object object = callSiteArray[53].callConstructor(String.class, BytecodeInterface8.objectArrayGet((Object[])decoded, (int)2));
            keyName = (String)ScriptBytecodeAdapter.castToType((Object)object, String.class);
        }
        SecretKeySpec sks = (SecretKeySpec)ScriptBytecodeAdapter.castToType((Object)callSiteArray[54].callStatic(EncryptionUtils.class, secretKeys, (Object)keyName), SecretKeySpec.class);
        Cipher cipher = (Cipher)ScriptBytecodeAdapter.castToType((Object)callSiteArray[55].call(Cipher.class, (Object)CRYPTO), Cipher.class);
        callSiteArray[56].call((Object)cipher, callSiteArray[57].callGetProperty(Cipher.class), (Object)sks, callSiteArray[58].callConstructor(IvParameterSpec.class, (Object)usingIv), (Object)RANDOM);
        byte[] decrypted = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[59].call((Object)cipher, (Object)toDecrypt), byte[].class);
        return (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[60].callConstructor(String.class, (Object)decrypted), String.class);
    }

    public static String decryptBuffer(String message, Map<String, byte[]> secretKeys) throws GeneralSecurityException, IOException {
        Reference secretKeys2 = new Reference(secretKeys);
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        return (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[61].callStatic(EncryptionUtils.class, (Object)message, (Object)((Map)secretKeys2.get()), (Object)new GeneratedClosure(EncryptionUtils.class, EncryptionUtils.class, secretKeys2){
            private /* synthetic */ Reference secretKeys;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                CallSite[] callSiteArray = _decryptBuffer_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.secretKeys = reference = secretKeys;
            }

            public Object doCall(Object line, Object encrypted, Object keys) {
                CallSite[] callSiteArray = _decryptBuffer_closure2.$getCallSiteArray();
                return callSiteArray[0].callStatic(EncryptionUtils.class, encrypted, this.secretKeys.get());
            }

            public Object call(Object line, Object encrypted, Object keys) {
                CallSite[] callSiteArray = _decryptBuffer_closure2.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, line, encrypted, keys);
            }

            public Map getSecretKeys() {
                CallSite[] callSiteArray = _decryptBuffer_closure2.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.secretKeys.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _decryptBuffer_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = _decryptBuffer_closure2.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                _decryptBuffer_closure2.__$swapInit();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "decrypt";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _decryptBuffer_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_decryptBuffer_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _decryptBuffer_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }), String.class);
    }

    public static String processBuffer(String message, Map<String, byte[]> secretKeys, Closure c) {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        Matcher matcher = (Matcher)ScriptBytecodeAdapter.castToType((Object)callSiteArray[62].call((Object)ENCRYPTEDPATTERN, (Object)message), Matcher.class);
        StringBuffer destination = (StringBuffer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[63].callConstructor(StringBuffer.class), StringBuffer.class);
        while (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[64].call((Object)matcher))) {
            callSiteArray[65].call((Object)matcher, (Object)destination, (Object)"");
            callSiteArray[66].call((Object)destination, callSiteArray[67].call((Object)c, (Object)message, callSiteArray[68].call((Object)matcher, (Object)1), secretKeys));
        }
        callSiteArray[69].call((Object)matcher, (Object)destination);
        return (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[70].call((Object)destination), String.class);
    }

    /*
     * WARNING - void declaration
     */
    public static Object decryptFiles(File fromDir, File toDir, Map<String, byte[]> secretKeys) throws FileNotFoundException, IOException {
        void var2_2;
        Reference toDir2 = new Reference((Object)toDir);
        Reference secretKeys2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        File[] fromFiles = (File[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[71].call((Object)fromDir), File[].class);
        return callSiteArray[72].call((Object)fromFiles, (Object)new GeneratedClosure(EncryptionUtils.class, EncryptionUtils.class, secretKeys2, toDir2){
            private /* synthetic */ Reference secretKeys;
            private /* synthetic */ Reference toDir;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _decryptFiles_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.secretKeys = reference2 = secretKeys;
                this.toDir = reference = toDir;
            }

            public Object doCall(Object fromFile) {
                CallSite[] callSiteArray = _decryptFiles_closure3.$getCallSiteArray();
                Reference toFile = new Reference((Object)((File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callConstructor(File.class, this.toDir.get(), callSiteArray[1].call(fromFile)), File.class)));
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].call(fromFile))) {
                    return callSiteArray[3].call(fromFile, (Object)new GeneratedClosure((Object)this, this.getThisObject(), this.secretKeys, toFile){
                        private /* synthetic */ Reference secretKeys;
                        private /* synthetic */ Reference toFile;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;
                        {
                            Reference reference;
                            Reference reference2;
                            CallSite[] callSiteArray = _decryptFiles_closure3_closure4.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                            this.secretKeys = reference2 = secretKeys;
                            this.toFile = reference = toFile;
                        }

                        public Object doCall(Object fis) {
                            CallSite[] callSiteArray = _decryptFiles_closure3_closure4.$getCallSiteArray();
                            Reference cis = new Reference((Object)((EncryptedInputStream)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callConstructor(EncryptedInputStream.class, fis, this.secretKeys.get()), EncryptedInputStream.class)));
                            return callSiteArray[1].call(this.toFile.get(), (Object)new GeneratedClosure((Object)((Object)this), this.getThisObject(), cis){
                                private /* synthetic */ Reference cis;
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;
                                private static /* synthetic */ SoftReference $callSiteArray;
                                {
                                    Reference reference;
                                    CallSite[] callSiteArray = _decryptFiles_closure3_closure4_closure5.$getCallSiteArray();
                                    super(_outerInstance, _thisObject);
                                    this.cis = reference = cis;
                                }

                                public Object doCall(Object fos) {
                                    CallSite[] callSiteArray = _decryptFiles_closure3_closure4_closure5.$getCallSiteArray();
                                    return callSiteArray[0].call(fos, this.cis.get());
                                }

                                public EncryptedInputStream getCis() {
                                    CallSite[] callSiteArray = _decryptFiles_closure3_closure4_closure5.$getCallSiteArray();
                                    return (EncryptedInputStream)ScriptBytecodeAdapter.castToType((Object)this.cis.get(), EncryptedInputStream.class);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _decryptFiles_closure3_closure4_closure5.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }

                                public static /* synthetic */ void __$swapInit() {
                                    CallSite[] callSiteArray = _decryptFiles_closure3_closure4_closure5.$getCallSiteArray();
                                    $callSiteArray = null;
                                }

                                static {
                                    _decryptFiles_closure3_closure4_closure5.__$swapInit();
                                }

                                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                    stringArray[0] = "leftShift";
                                }

                                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                    String[] stringArray = new String[1];
                                    _decryptFiles_closure3_closure4_closure5.$createCallSiteArray_1(stringArray);
                                    return new CallSiteArray(_decryptFiles_closure3_closure4_closure5.class, stringArray);
                                }

                                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                    CallSiteArray callSiteArray;
                                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                        callSiteArray = _decryptFiles_closure3_closure4_closure5.$createCallSiteArray();
                                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                    }
                                    return callSiteArray.array;
                                }

                                static /* synthetic */ Class class$(String string) {
                                    try {
                                        return Class.forName(string);
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                            });
                        }

                        public Map getSecretKeys() {
                            CallSite[] callSiteArray = _decryptFiles_closure3_closure4.$getCallSiteArray();
                            return (Map)ScriptBytecodeAdapter.castToType((Object)this.secretKeys.get(), Map.class);
                        }

                        public File getToFile() {
                            CallSite[] callSiteArray = _decryptFiles_closure3_closure4.$getCallSiteArray();
                            return (File)ScriptBytecodeAdapter.castToType((Object)this.toFile.get(), File.class);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _decryptFiles_closure3_closure4.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public static /* synthetic */ void __$swapInit() {
                            CallSite[] callSiteArray = _decryptFiles_closure3_closure4.$getCallSiteArray();
                            $callSiteArray = null;
                        }

                        static {
                            _decryptFiles_closure3_closure4.__$swapInit();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "<$constructor$>";
                            stringArray[1] = "withOutputStream";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[2];
                            _decryptFiles_closure3_closure4.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_decryptFiles_closure3_closure4.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _decryptFiles_closure3_closure4.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }

                        static /* synthetic */ Class class$(String string) {
                            try {
                                return Class.forName(string);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                    });
                }
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].call((Object)((File)toFile.get())))) {
                    callSiteArray[5].call((Object)((File)toFile.get()));
                }
                return callSiteArray[6].callStatic(EncryptionUtils.class, fromFile, (Object)((File)toFile.get()), this.secretKeys.get());
            }

            public Map getSecretKeys() {
                CallSite[] callSiteArray = _decryptFiles_closure3.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.secretKeys.get(), Map.class);
            }

            public File getToDir() {
                CallSite[] callSiteArray = _decryptFiles_closure3.$getCallSiteArray();
                return (File)ScriptBytecodeAdapter.castToType((Object)this.toDir.get(), File.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _decryptFiles_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = _decryptFiles_closure3.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                _decryptFiles_closure3.__$swapInit();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "<$constructor$>";
                stringArray[1] = "getName";
                stringArray[2] = "isFile";
                stringArray[3] = "withInputStream";
                stringArray[4] = "exists";
                stringArray[5] = "mkdir";
                stringArray[6] = "decryptFiles";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[7];
                _decryptFiles_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_decryptFiles_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _decryptFiles_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    public static boolean isEncrypted(String encrypted) {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        int startIndex = DefaultTypeTransformation.intUnbox((Object)callSiteArray[73].call((Object)encrypted, (Object)ENCRYPTEDPREFIX));
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ScriptBytecodeAdapter.compareGreaterThan((Object)startIndex, (Object)-1);
        }
        return ScriptBytecodeAdapter.compareGreaterThan((Object)startIndex, (Object)-1);
    }

    public static String encryptionKeyName(String encrypted) {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[74].callStatic(EncryptionUtils.class, (Object)encrypted))) {
                byte[][] decoded = (byte[][])ScriptBytecodeAdapter.castToType((Object)callSiteArray[75].callStatic(EncryptionUtils.class, (Object)encrypted), byte[][].class);
                return (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[76].callConstructor(String.class, callSiteArray[77].call((Object)decoded, (Object)2)), String.class);
            }
            return (String)ScriptBytecodeAdapter.castToType(null, String.class);
        }
        if (EncryptionUtils.isEncrypted(encrypted)) {
            byte[][] decoded = EncryptionUtils.decode(encrypted);
            return (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[78].callConstructor(String.class, BytecodeInterface8.objectArrayGet((Object[])decoded, (int)2)), String.class);
        }
        return (String)ScriptBytecodeAdapter.castToType(null, String.class);
    }

    private static SecretKeySpec getSecretKeySpec(Map<String, byte[]> secretKeys, String keyName) throws NoSuchAlgorithmException, IOException {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        SecretKeySpec sks = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[79].call(secretKeys, (Object)keyName))) {
            byte[] secretKey = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[80].call(secretKeys, (Object)keyName), byte[].class);
            Object object = callSiteArray[81].callConstructor(SecretKeySpec.class, (Object)secretKey, (Object)ALGORITHM);
            sks = (SecretKeySpec)ScriptBytecodeAdapter.castToType((Object)object, SecretKeySpec.class);
        }
        return sks;
    }

    private static String encode(byte[] bytes, byte[] iv, String keyName) {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        StringBuilder builder = (StringBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[82].callConstructor(StringBuilder.class), StringBuilder.class);
        callSiteArray[83].call((Object)builder, (Object)ENCRYPTEDPREFIX);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[84].call((Object)builder, callSiteArray[85].callStatic(EncryptionUtils.class, (Object)bytes));
        } else {
            callSiteArray[86].call((Object)builder, (Object)EncryptionUtils.encodeToBase64(bytes));
        }
        callSiteArray[87].call((Object)builder, (Object)",");
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[88].call((Object)builder, callSiteArray[89].callStatic(EncryptionUtils.class, (Object)iv));
        } else {
            callSiteArray[90].call((Object)builder, (Object)EncryptionUtils.encodeToBase64(iv));
        }
        callSiteArray[91].call((Object)builder, (Object)",");
        callSiteArray[92].call((Object)builder, callSiteArray[93].callStatic(EncryptionUtils.class, callSiteArray[94].call((Object)keyName)));
        callSiteArray[95].call((Object)builder, (Object)ENCRYPTEDSUFFIX);
        return (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[96].call((Object)builder), String.class);
    }

    private static byte[][] decode(String encoded) throws IOException {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        byte[][] decoded = (byte[][])ScriptBytecodeAdapter.castToType((Object)new byte[3], byte[][].class);
        int startIndex = DefaultTypeTransformation.intUnbox((Object)callSiteArray[97].call((Object)encoded, (Object)ENCRYPTEDPREFIX));
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)startIndex, (Object)-1)) {
                startIndex = DefaultTypeTransformation.intUnbox((Object)callSiteArray[98].call((Object)startIndex, callSiteArray[99].call((Object)ENCRYPTEDPREFIX)));
                int endIndex = DefaultTypeTransformation.intUnbox((Object)callSiteArray[100].call((Object)encoded, (Object)ENCRYPTEDSUFFIX, (Object)startIndex));
                if (ScriptBytecodeAdapter.compareGreaterThan((Object)endIndex, (Object)-1)) {
                    String stringToDecode = (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[101].call((Object)encoded, (Object)startIndex, (Object)endIndex), String.class);
                    int i = 0;
                    String part = null;
                    Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[102].call(callSiteArray[103].call((Object)stringToDecode, (Object)",")), Iterator.class);
                    while (iterator.hasNext()) {
                        part = (String)ScriptBytecodeAdapter.castToType(iterator.next(), String.class);
                        Object object = callSiteArray[104].callStatic(EncryptionUtils.class, (Object)part);
                        int n = i;
                        i = DefaultTypeTransformation.intUnbox((Object)callSiteArray[106].call((Object)n));
                        callSiteArray[105].call((Object)decoded, (Object)n, object);
                    }
                    return decoded;
                }
                throw (Throwable)callSiteArray[107].callConstructor(IOException.class, callSiteArray[108].call(callSiteArray[109].call((Object)"Incorrrectly encoded string, Missing ENCRYPTEDSUFFIX '", (Object)ENCRYPTEDSUFFIX), (Object)"'"));
            }
            throw (Throwable)callSiteArray[110].callConstructor(IOException.class, callSiteArray[111].call(callSiteArray[112].call((Object)"Input not correctly encoded, missing ENCRYPTEDPREFIX '", (Object)ENCRYPTEDPREFIX), (Object)"'"));
        }
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)startIndex, (Object)-1)) {
            startIndex = DefaultTypeTransformation.intUnbox((Object)callSiteArray[113].call((Object)startIndex, callSiteArray[114].call((Object)ENCRYPTEDPREFIX)));
            int endIndex = DefaultTypeTransformation.intUnbox((Object)callSiteArray[115].call((Object)encoded, (Object)ENCRYPTEDSUFFIX, (Object)startIndex));
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)endIndex, (Object)-1)) {
                String stringToDecode = (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[116].call((Object)encoded, (Object)startIndex, (Object)endIndex), String.class);
                int i = 0;
                String part = null;
                Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[117].call(callSiteArray[118].call((Object)stringToDecode, (Object)",")), Iterator.class);
                while (iterator.hasNext()) {
                    part = (String)ScriptBytecodeAdapter.castToType(iterator.next(), String.class);
                    byte[] byArray = EncryptionUtils.decodeFromBase64(part);
                    int n = i;
                    int cfr_ignored_0 = n + 1;
                    BytecodeInterface8.objectArraySet((Object[])decoded, (int)n, (Object)byArray);
                }
                return decoded;
            }
            throw (Throwable)callSiteArray[119].callConstructor(IOException.class, callSiteArray[120].call(callSiteArray[121].call((Object)"Incorrrectly encoded string, Missing ENCRYPTEDSUFFIX '", (Object)ENCRYPTEDSUFFIX), (Object)"'"));
        }
        throw (Throwable)callSiteArray[122].callConstructor(IOException.class, callSiteArray[123].call(callSiteArray[124].call((Object)"Input not correctly encoded, missing ENCRYPTEDPREFIX '", (Object)ENCRYPTEDPREFIX), (Object)"'"));
    }

    private static byte[] generateIV(Cipher cipher) {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        byte[] ivBytes = new byte[DefaultTypeTransformation.intUnbox((Object)callSiteArray[125].call((Object)cipher))];
        callSiteArray[126].call((Object)RANDOM, (Object)ivBytes);
        return ivBytes;
    }

    private static String encodeToBase64(byte ... b) {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        return (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[127].call((Object)BASE64CODEC, (Object)b), String.class);
    }

    private static byte[] decodeFromBase64(String s) {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        return (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[128].call((Object)BASE64CODEC, (Object)s), byte[].class);
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(EncryptionUtils.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectField((Object)object, EncryptionUtils.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectField(EncryptionUtils.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != EncryptionUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        $callSiteArray = null;
    }

    static {
        String string;
        long l;
        long l2;
        EncryptionUtils.__$swapInit();
        __timeStamp__239_neverHappen1364841017583 = l2 = 0L;
        __timeStamp = l = 1364841017583L;
        ENCRYPTEDSUFFIX = string = ")";
        Object object = EncryptionUtils.$getCallSiteArray()[129].call(EncryptionUtils.$getCallSiteArray()[130].call(EncryptionUtils.$getCallSiteArray()[131].call(EncryptionUtils.$getCallSiteArray()[132].call((Object)ALGORITHM, (Object)"/"), (Object)MODE), (Object)"/"), (Object)PADDING);
        CRYPTO = (String)ScriptBytecodeAdapter.castToType((Object)object, String.class);
        Object object2 = EncryptionUtils.$getCallSiteArray()[133].callConstructor(SecureRandom.class);
        RANDOM = (SecureRandom)ScriptBytecodeAdapter.castToType((Object)object2, SecureRandom.class);
        Object object3 = EncryptionUtils.$getCallSiteArray()[134].call(EncryptionUtils.$getCallSiteArray()[135].call((Object)"Encrypted-", (Object)CRYPTO), (Object)"(");
        ENCRYPTEDPREFIX = (String)ScriptBytecodeAdapter.castToType((Object)object3, String.class);
        Object object4 = EncryptionUtils.$getCallSiteArray()[136].call(EncryptionUtils.$getCallSiteArray()[137].call(EncryptionUtils.$getCallSiteArray()[138].call(EncryptionUtils.$getCallSiteArray()[139].call(EncryptionUtils.$getCallSiteArray()[140].call(EncryptionUtils.$getCallSiteArray()[141].call((Object)"Encrypted-", (Object)CRYPTO), (Object)"\\("), (Object)"[^\\"), (Object)ENCRYPTEDSUFFIX), (Object)"]+\\"), (Object)ENCRYPTEDSUFFIX);
        REGEXTOMATCH = (String)ScriptBytecodeAdapter.castToType((Object)object4, String.class);
        Object object5 = EncryptionUtils.$getCallSiteArray()[142].call(Pattern.class, EncryptionUtils.$getCallSiteArray()[143].call(EncryptionUtils.$getCallSiteArray()[144].call((Object)"(", (Object)REGEXTOMATCH), (Object)")"));
        ENCRYPTEDPATTERN = (Pattern)ScriptBytecodeAdapter.castToType((Object)object5, Pattern.class);
        Object object6 = EncryptionUtils.$getCallSiteArray()[145].callConstructor(Base64Codec.class);
        BASE64CODEC = (Base64Codec)ScriptBytecodeAdapter.castToType((Object)object6, Base64Codec.class);
    }

    public /* synthetic */ void super$1$wait() {
        super.wait();
    }

    public /* synthetic */ String super$1$toString() {
        return super.toString();
    }

    public /* synthetic */ void super$1$wait(long l) {
        super.wait(l);
    }

    public /* synthetic */ void super$1$wait(long l, int n) {
        super.wait(l, n);
    }

    public /* synthetic */ void super$1$notify() {
        super.notify();
    }

    public /* synthetic */ void super$1$notifyAll() {
        super.notifyAll();
    }

    public /* synthetic */ Class super$1$getClass() {
        return super.getClass();
    }

    public /* synthetic */ Object super$1$clone() {
        return super.clone();
    }

    public /* synthetic */ boolean super$1$equals(Object object) {
        return super.equals(object);
    }

    public /* synthetic */ int super$1$hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ void super$1$finalize() {
        super.finalize();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "exists";
        stringArray[1] = "getSecretKeys";
        stringArray[2] = "getAt";
        stringArray[3] = "getInstance";
        stringArray[4] = "init";
        stringArray[5] = "generateKey";
        stringArray[6] = "saveSecretKey";
        stringArray[7] = "getInstance";
        stringArray[8] = "exists";
        stringArray[9] = "<$constructor$>";
        stringArray[10] = "load";
        stringArray[11] = "toCharArray";
        stringArray[12] = "close";
        stringArray[13] = "close";
        stringArray[14] = "load";
        stringArray[15] = "toCharArray";
        stringArray[16] = "<$constructor$>";
        stringArray[17] = "loadKeyStore";
        stringArray[18] = "setEntry";
        stringArray[19] = "<$constructor$>";
        stringArray[20] = "toCharArray";
        stringArray[21] = "<$constructor$>";
        stringArray[22] = "store";
        stringArray[23] = "toCharArray";
        stringArray[24] = "close";
        stringArray[25] = "close";
        stringArray[26] = "close";
        stringArray[27] = "close";
        stringArray[28] = "loadKeyStore";
        stringArray[29] = "isKeyEntry";
        stringArray[30] = "getEntry";
        stringArray[31] = "<$constructor$>";
        stringArray[32] = "toCharArray";
        stringArray[33] = "getSecretKey";
        stringArray[34] = "<$constructor$>";
        stringArray[35] = "getSecretKeys";
        stringArray[36] = "loadKeyStore";
        stringArray[37] = "each";
        stringArray[38] = "aliases";
        stringArray[39] = "getSecretKeySpec";
        stringArray[40] = "getInstance";
        stringArray[41] = "generateIV";
        stringArray[42] = "init";
        stringArray[43] = "ENCRYPT_MODE";
        stringArray[44] = "<$constructor$>";
        stringArray[45] = "doFinal";
        stringArray[46] = "getBytes";
        stringArray[47] = "encode";
        stringArray[48] = "decode";
        stringArray[49] = "getAt";
        stringArray[50] = "getAt";
        stringArray[51] = "<$constructor$>";
        stringArray[52] = "getAt";
        stringArray[53] = "<$constructor$>";
        stringArray[54] = "getSecretKeySpec";
        stringArray[55] = "getInstance";
        stringArray[56] = "init";
        stringArray[57] = "DECRYPT_MODE";
        stringArray[58] = "<$constructor$>";
        stringArray[59] = "doFinal";
        stringArray[60] = "<$constructor$>";
        stringArray[61] = "processBuffer";
        stringArray[62] = "matcher";
        stringArray[63] = "<$constructor$>";
        stringArray[64] = "find";
        stringArray[65] = "appendReplacement";
        stringArray[66] = "append";
        stringArray[67] = "call";
        stringArray[68] = "group";
        stringArray[69] = "appendTail";
        stringArray[70] = "toString";
        stringArray[71] = "listFiles";
        stringArray[72] = "each";
        stringArray[73] = "indexOf";
        stringArray[74] = "isEncrypted";
        stringArray[75] = "decode";
        stringArray[76] = "<$constructor$>";
        stringArray[77] = "getAt";
        stringArray[78] = "<$constructor$>";
        stringArray[79] = "getAt";
        stringArray[80] = "getAt";
        stringArray[81] = "<$constructor$>";
        stringArray[82] = "<$constructor$>";
        stringArray[83] = "append";
        stringArray[84] = "append";
        stringArray[85] = "encodeToBase64";
        stringArray[86] = "append";
        stringArray[87] = "append";
        stringArray[88] = "append";
        stringArray[89] = "encodeToBase64";
        stringArray[90] = "append";
        stringArray[91] = "append";
        stringArray[92] = "append";
        stringArray[93] = "encodeToBase64";
        stringArray[94] = "getBytes";
        stringArray[95] = "append";
        stringArray[96] = "toString";
        stringArray[97] = "indexOf";
        stringArray[98] = "plus";
        stringArray[99] = "length";
        stringArray[100] = "indexOf";
        stringArray[101] = "substring";
        stringArray[102] = "iterator";
        stringArray[103] = "split";
        stringArray[104] = "decodeFromBase64";
        stringArray[105] = "putAt";
        stringArray[106] = "next";
        stringArray[107] = "<$constructor$>";
        stringArray[108] = "plus";
        stringArray[109] = "plus";
        stringArray[110] = "<$constructor$>";
        stringArray[111] = "plus";
        stringArray[112] = "plus";
        stringArray[113] = "plus";
        stringArray[114] = "length";
        stringArray[115] = "indexOf";
        stringArray[116] = "substring";
        stringArray[117] = "iterator";
        stringArray[118] = "split";
        stringArray[119] = "<$constructor$>";
        stringArray[120] = "plus";
        stringArray[121] = "plus";
        stringArray[122] = "<$constructor$>";
        stringArray[123] = "plus";
        stringArray[124] = "plus";
        stringArray[125] = "getBlockSize";
        stringArray[126] = "nextBytes";
        stringArray[127] = "encode";
        stringArray[128] = "decode";
        stringArray[129] = "plus";
        stringArray[130] = "plus";
        stringArray[131] = "plus";
        stringArray[132] = "plus";
        stringArray[133] = "<$constructor$>";
        stringArray[134] = "plus";
        stringArray[135] = "plus";
        stringArray[136] = "plus";
        stringArray[137] = "plus";
        stringArray[138] = "plus";
        stringArray[139] = "plus";
        stringArray[140] = "plus";
        stringArray[141] = "plus";
        stringArray[142] = "compile";
        stringArray[143] = "plus";
        stringArray[144] = "plus";
        stringArray[145] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[146];
        EncryptionUtils.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(EncryptionUtils.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = EncryptionUtils.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

