/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.json.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.IOException;
import java.util.Arrays;

public class LfNSpacesIndenter
implements DefaultPrettyPrinter.Indenter {
    private final int _numSpaces;
    static final String SYSTEM_LINE_SEPARATOR;
    static final int SPACE_COUNT = 64;
    static final char[] SPACES;

    public LfNSpacesIndenter(int numSpaces) {
        if (numSpaces <= 0) {
            throw new IllegalArgumentException(numSpaces + " must be > 0");
        }
        this._numSpaces = numSpaces;
    }

    public boolean isInline() {
        return false;
    }

    public void writeIndentation(JsonGenerator jg, int level) throws IOException {
        int numSpaces;
        jg.writeRaw(SYSTEM_LINE_SEPARATOR);
        switch (this._numSpaces) {
            case 1: {
                numSpaces = level;
                break;
            }
            case 2: {
                numSpaces = level + level;
                break;
            }
            case 3: {
                numSpaces = level + level + level;
                break;
            }
            case 4: {
                numSpaces = level + level + level + level;
                break;
            }
            default: {
                numSpaces = level * this._numSpaces;
            }
        }
        while (numSpaces > 64) {
            jg.writeRaw(SPACES, 0, 64);
            numSpaces -= SPACES.length;
        }
        jg.writeRaw(SPACES, 0, numSpaces);
    }

    static {
        String lf = null;
        try {
            lf = System.getProperty("line.separator");
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        SYSTEM_LINE_SEPARATOR = lf == null ? "\n" : lf;
        SPACES = new char[64];
        Arrays.fill(SPACES, ' ');
    }
}

