/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.groovy.util.encryption;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.linkedin.groovy.util.encryption.EncryptionUtils$_decryptBuffer_closure2;
import org.linkedin.groovy.util.encryption.EncryptionUtils$_decryptFiles_closure3;
import org.linkedin.groovy.util.encryption.EncryptionUtils$_getSecretKeys_closure1;
import org.linkedin.util.codec.Base64Codec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptionUtils
implements GroovyObject {
    private static final String ALGORITHM;
    private static final String MODE;
    private static final String PADDING;
    private static final String KEYSTORETYPE;
    private static final String CRYPTO;
    private static final SecureRandom RANDOM;
    private static final String ENCRYPTEDPREFIX;
    private static final String ENCRYPTEDSUFFIX;
    private static final String REGEXTOMATCH;
    private static final Pattern ENCRYPTEDPATTERN;
    private static final Base64Codec BASE64CODEC;
    private static final /* synthetic */ Integer $const$0;
    private static final /* synthetic */ Integer $const$1;
    private static final /* synthetic */ Integer $const$2;
    private static final /* synthetic */ Integer $const$3;
    private static final /* synthetic */ Integer $const$4;
    private static final /* synthetic */ Integer $const$5;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    private transient /* synthetic */ MetaClass metaClass;
    public static /* synthetic */ Long __timeStamp;
    public static /* synthetic */ Long __timeStamp__239_neverHappen1304448616588;
    private static /* synthetic */ SoftReference $callSiteArray;
    private static /* synthetic */ Class $class$java$io$FileOutputStream;
    private static /* synthetic */ Class array$$class$java$io$File;
    private static /* synthetic */ Class $class$java$security$KeyStore;
    private static /* synthetic */ Class $class$java$lang$StringBuilder;
    private static /* synthetic */ Class $class$org$linkedin$groovy$util$encryption$EncryptionUtils;
    private static /* synthetic */ Class array$$class$byte;
    private static /* synthetic */ Class $class$java$lang$String;
    private static /* synthetic */ Class $class$java$io$File;
    private static /* synthetic */ Class $class$javax$crypto$KeyGenerator;
    private static /* synthetic */ Class $class$java$util$Map;
    private static /* synthetic */ Class $class$java$security$SecureRandom;
    private static /* synthetic */ Class array$$$class$byte;
    private static /* synthetic */ Class $class$java$util$regex$Pattern;
    private static /* synthetic */ Class $class$javax$crypto$spec$SecretKeySpec;
    private static /* synthetic */ Class $class$java$util$regex$Matcher;
    private static /* synthetic */ Class $class$java$lang$StringBuffer;
    private static /* synthetic */ Class $class$org$linkedin$util$codec$Base64Codec;
    private static /* synthetic */ Class $class$javax$crypto$spec$IvParameterSpec;
    private static /* synthetic */ Class $class$javax$crypto$Cipher;
    private static /* synthetic */ Class $class$java$io$FileInputStream;
    private static /* synthetic */ Class $class$java$io$IOException;
    private static /* synthetic */ Class $class$java$lang$Integer;
    private static /* synthetic */ Class $class$groovy$lang$MetaClass;
    private static /* synthetic */ Class $class$javax$crypto$SecretKey;
    private static /* synthetic */ Class $class$java$lang$Boolean;
    private static /* synthetic */ Class $class$java$security$KeyStore$SecretKeyEntry;
    private static /* synthetic */ Class $class$java$security$KeyStore$PasswordProtection;

    public EncryptionUtils() {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        this.metaClass = (MetaClass)ScriptBytecodeAdapter.castToType((Object)this.$getStaticMetaClass(), (Class)EncryptionUtils.$get$$class$groovy$lang$MetaClass());
    }

    public static void createSecretKey(File keyFile, String keyName, String keyStorePassword, String secretKeyPassword) throws GeneralSecurityException, IOException {
        block3: {
            CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
            Boolean genKey = Boolean.FALSE;
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call((Object)keyFile))) {
                genKey = Boolean.TRUE;
            } else {
                Map secretKeys = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].callStatic(EncryptionUtils.$get$$class$org$linkedin$groovy$util$encryption$EncryptionUtils(), (Object)keyFile, (Object)keyStorePassword, (Object)secretKeyPassword), (Class)EncryptionUtils.$get$$class$java$util$Map());
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].call((Object)secretKeys, (Object)keyName))) {
                    genKey = Boolean.TRUE;
                }
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)genKey)) break block3;
            KeyGenerator keyGen = (KeyGenerator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].call((Object)EncryptionUtils.$get$$class$javax$crypto$KeyGenerator(), (Object)ALGORITHM), (Class)EncryptionUtils.$get$$class$javax$crypto$KeyGenerator());
            callSiteArray[4].call((Object)keyGen, (Object)$const$0);
            SecretKey sk = (SecretKey)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].call((Object)keyGen), (Class)EncryptionUtils.$get$$class$javax$crypto$SecretKey());
            callSiteArray[6].callStatic(EncryptionUtils.$get$$class$org$linkedin$groovy$util$encryption$EncryptionUtils(), ArrayUtil.createArray((Object)sk, (Object)keyFile, (Object)keyName, (Object)keyStorePassword, (Object)secretKeyPassword));
        }
    }

    private static KeyStore loadKeyStore(File keyFile, String keyStorePassword) {
        KeyStore ks;
        block5: {
            CallSite[] callSiteArray;
            block4: {
                callSiteArray = EncryptionUtils.$getCallSiteArray();
                ks = (KeyStore)ScriptBytecodeAdapter.castToType((Object)callSiteArray[7].call((Object)EncryptionUtils.$get$$class$java$security$KeyStore(), (Object)KEYSTORETYPE), (Class)EncryptionUtils.$get$$class$java$security$KeyStore());
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[8].call((Object)keyFile))) break block4;
                Object fis = (FileInputStream)ScriptBytecodeAdapter.castToType(null, (Class)EncryptionUtils.$get$$class$java$io$FileInputStream());
                try {
                    fis = callSiteArray[9].callConstructor((Object)EncryptionUtils.$get$$class$java$io$FileInputStream(), (Object)keyFile);
                    callSiteArray[10].call((Object)ks, fis, callSiteArray[11].call((Object)keyStorePassword));
                }
                catch (Throwable throwable) {
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)fis, null)) {
                        callSiteArray[13].call(fis);
                    }
                    throw throwable;
                }
                if (ScriptBytecodeAdapter.compareNotEqual((Object)fis, null)) {
                    callSiteArray[12].call(fis);
                }
                break block5;
            }
            callSiteArray[14].call((Object)ks, null, callSiteArray[15].call((Object)keyStorePassword));
        }
        return (KeyStore)ScriptBytecodeAdapter.castToType((Object)ks, (Class)EncryptionUtils.$get$$class$java$security$KeyStore());
    }

    public static void saveSecretKey(SecretKey sk, File keyFile, String keyName, String keyStorePassword, String secretKeyPassword) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        Object skEntry = callSiteArray[16].callConstructor((Object)EncryptionUtils.$get$$class$java$security$KeyStore$SecretKeyEntry(), (Object)sk);
        KeyStore ks = (KeyStore)ScriptBytecodeAdapter.castToType((Object)callSiteArray[17].callStatic(EncryptionUtils.$get$$class$org$linkedin$groovy$util$encryption$EncryptionUtils(), (Object)keyFile, (Object)keyStorePassword), (Class)EncryptionUtils.$get$$class$java$security$KeyStore());
        callSiteArray[18].call((Object)ks, (Object)keyName, skEntry, callSiteArray[19].callConstructor((Object)EncryptionUtils.$get$$class$java$security$KeyStore$PasswordProtection(), callSiteArray[20].call((Object)secretKeyPassword)));
        Object fos = (FileOutputStream)ScriptBytecodeAdapter.castToType(null, (Class)EncryptionUtils.$get$$class$java$io$FileOutputStream());
        try {
            fos = callSiteArray[21].callConstructor((Object)EncryptionUtils.$get$$class$java$io$FileOutputStream(), (Object)keyFile);
            callSiteArray[22].call((Object)ks, fos, callSiteArray[23].call((Object)keyStorePassword));
        }
        catch (Throwable throwable) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)fos, null)) {
                callSiteArray[25].call(fos);
            }
            throw throwable;
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)fos, null)) {
            callSiteArray[24].call(fos);
        }
    }

    public static SecretKey getSecretKey(File keyFile, String keyName, String keyStorePassword, String secretKeyPassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableEntryException {
        SecretKey sk;
        block0: {
            CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
            KeyStore ks = (KeyStore)ScriptBytecodeAdapter.castToType((Object)callSiteArray[26].callStatic(EncryptionUtils.$get$$class$org$linkedin$groovy$util$encryption$EncryptionUtils(), (Object)keyFile, (Object)keyStorePassword), (Class)EncryptionUtils.$get$$class$java$security$KeyStore());
            sk = (SecretKey)ScriptBytecodeAdapter.castToType(null, (Class)EncryptionUtils.$get$$class$javax$crypto$SecretKey());
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[27].call((Object)ks, (Object)keyName))) break block0;
            KeyStore.SecretKeyEntry skEntry = (KeyStore.SecretKeyEntry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[28].call((Object)ks, (Object)keyName, callSiteArray[29].callConstructor((Object)EncryptionUtils.$get$$class$java$security$KeyStore$PasswordProtection(), callSiteArray[30].call((Object)secretKeyPassword))), (Class)EncryptionUtils.$get$$class$java$security$KeyStore$SecretKeyEntry());
            sk = (SecretKey)ScriptBytecodeAdapter.castToType((Object)callSiteArray[31].call((Object)skEntry), (Class)EncryptionUtils.$get$$class$javax$crypto$SecretKey());
        }
        return (SecretKey)ScriptBytecodeAdapter.castToType((Object)sk, (Class)EncryptionUtils.$get$$class$javax$crypto$SecretKey());
    }

    public static Map<String, byte[]> getSecretKeys(String keyFileName, String keyStorePassword, String secretKeyPassword) {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        Object keyFile = callSiteArray[32].callConstructor((Object)EncryptionUtils.$get$$class$java$io$File(), (Object)keyFileName);
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[33].callStatic(EncryptionUtils.$get$$class$org$linkedin$groovy$util$encryption$EncryptionUtils(), keyFile, (Object)keyStorePassword, (Object)secretKeyPassword), (Class)EncryptionUtils.$get$$class$java$util$Map());
    }

    public static Map<String, byte[]> getSecretKeys(File keyFile, String keyStorePassword, String string) {
        Reference secretKeyPassword = new Reference((Object)string);
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        Reference secretKeys = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        Reference ks = new Reference((Object)((KeyStore)ScriptBytecodeAdapter.castToType((Object)callSiteArray[34].callStatic(EncryptionUtils.$get$$class$org$linkedin$groovy$util$encryption$EncryptionUtils(), (Object)keyFile, (Object)keyStorePassword), (Class)EncryptionUtils.$get$$class$java$security$KeyStore())));
        callSiteArray[35].call(callSiteArray[36].call(ks.get()), (Object)new EncryptionUtils$_getSecretKeys_closure1(EncryptionUtils.$get$$class$org$linkedin$groovy$util$encryption$EncryptionUtils(), EncryptionUtils.$get$$class$org$linkedin$groovy$util$encryption$EncryptionUtils(), secretKeyPassword, secretKeys, ks));
        return (Map)ScriptBytecodeAdapter.castToType((Object)secretKeys.get(), (Class)EncryptionUtils.$get$$class$java$util$Map());
    }

    public static String encrypt(String value, Map<String, byte[]> secretKeys, String keyName) throws GeneralSecurityException, IOException {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        SecretKeySpec sks = (SecretKeySpec)ScriptBytecodeAdapter.castToType((Object)callSiteArray[37].callStatic(EncryptionUtils.$get$$class$org$linkedin$groovy$util$encryption$EncryptionUtils(), secretKeys, (Object)keyName), (Class)EncryptionUtils.$get$$class$javax$crypto$spec$SecretKeySpec());
        Cipher cipher = (Cipher)ScriptBytecodeAdapter.castToType((Object)callSiteArray[38].call((Object)EncryptionUtils.$get$$class$javax$crypto$Cipher(), (Object)CRYPTO), (Class)EncryptionUtils.$get$$class$javax$crypto$Cipher());
        Object iv = callSiteArray[39].callStatic(EncryptionUtils.$get$$class$org$linkedin$groovy$util$encryption$EncryptionUtils(), (Object)cipher);
        callSiteArray[40].call((Object)cipher, callSiteArray[41].callGetProperty((Object)EncryptionUtils.$get$$class$javax$crypto$Cipher()), (Object)sks, callSiteArray[42].callConstructor((Object)EncryptionUtils.$get$$class$javax$crypto$spec$IvParameterSpec(), iv), (Object)RANDOM);
        byte[] encrypted = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[43].call((Object)cipher, callSiteArray[44].call((Object)value)), (Class)EncryptionUtils.$get$array$$class$byte());
        return (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[45].callStatic(EncryptionUtils.$get$$class$org$linkedin$groovy$util$encryption$EncryptionUtils(), (Object)encrypted, iv, (Object)keyName), (Class)EncryptionUtils.$get$$class$java$lang$String());
    }

    public static String decrypt(String message, Map<String, byte[]> secretKeys) throws GeneralSecurityException, IOException {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        byte[][] decoded = (byte[][])ScriptBytecodeAdapter.castToType((Object)callSiteArray[46].callStatic(EncryptionUtils.$get$$class$org$linkedin$groovy$util$encryption$EncryptionUtils(), (Object)message), (Class)EncryptionUtils.$get$array$$$class$byte());
        byte[] toDecrypt = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[47].call((Object)decoded, (Object)$const$1), (Class)EncryptionUtils.$get$array$$class$byte());
        byte[] usingIv = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[48].call((Object)decoded, (Object)$const$2), (Class)EncryptionUtils.$get$array$$class$byte());
        Object keyName = callSiteArray[49].callConstructor((Object)EncryptionUtils.$get$$class$java$lang$String(), callSiteArray[50].call((Object)decoded, (Object)$const$3));
        SecretKeySpec sks = (SecretKeySpec)ScriptBytecodeAdapter.castToType((Object)callSiteArray[51].callStatic(EncryptionUtils.$get$$class$org$linkedin$groovy$util$encryption$EncryptionUtils(), secretKeys, keyName), (Class)EncryptionUtils.$get$$class$javax$crypto$spec$SecretKeySpec());
        Cipher cipher = (Cipher)ScriptBytecodeAdapter.castToType((Object)callSiteArray[52].call((Object)EncryptionUtils.$get$$class$javax$crypto$Cipher(), (Object)CRYPTO), (Class)EncryptionUtils.$get$$class$javax$crypto$Cipher());
        callSiteArray[53].call((Object)cipher, callSiteArray[54].callGetProperty((Object)EncryptionUtils.$get$$class$javax$crypto$Cipher()), (Object)sks, callSiteArray[55].callConstructor((Object)EncryptionUtils.$get$$class$javax$crypto$spec$IvParameterSpec(), (Object)usingIv), (Object)RANDOM);
        byte[] decrypted = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[56].call((Object)cipher, (Object)toDecrypt), (Class)EncryptionUtils.$get$array$$class$byte());
        return (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[57].callConstructor((Object)EncryptionUtils.$get$$class$java$lang$String(), (Object)decrypted), (Class)EncryptionUtils.$get$$class$java$lang$String());
    }

    public static String decryptBuffer(String message, Map<String, byte[]> map) throws GeneralSecurityException, IOException {
        Reference secretKeys = new Reference(map);
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        return (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[58].callStatic(EncryptionUtils.$get$$class$org$linkedin$groovy$util$encryption$EncryptionUtils(), (Object)message, secretKeys.get(), (Object)new EncryptionUtils$_decryptBuffer_closure2(EncryptionUtils.$get$$class$org$linkedin$groovy$util$encryption$EncryptionUtils(), EncryptionUtils.$get$$class$org$linkedin$groovy$util$encryption$EncryptionUtils(), secretKeys)), (Class)EncryptionUtils.$get$$class$java$lang$String());
    }

    public static String processBuffer(String message, Map<String, byte[]> secretKeys, Closure c) {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        Matcher matcher = (Matcher)ScriptBytecodeAdapter.castToType((Object)callSiteArray[59].call((Object)ENCRYPTEDPATTERN, (Object)message), (Class)EncryptionUtils.$get$$class$java$util$regex$Matcher());
        Object destination = callSiteArray[60].callConstructor((Object)EncryptionUtils.$get$$class$java$lang$StringBuffer());
        while (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[61].call((Object)matcher))) {
            callSiteArray[62].call((Object)matcher, destination, (Object)"");
            callSiteArray[63].call(destination, callSiteArray[64].call((Object)c, (Object)message, callSiteArray[65].call((Object)matcher, (Object)$const$2), secretKeys));
        }
        callSiteArray[66].call((Object)matcher, destination);
        return (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[67].call(destination), (Class)EncryptionUtils.$get$$class$java$lang$String());
    }

    public static Object decryptFiles(File fromDir, File file, Map<String, byte[]> map) throws FileNotFoundException, IOException {
        Reference toDir = new Reference((Object)file);
        Reference secretKeys = new Reference(map);
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        File[] fromFiles = (File[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[68].call((Object)fromDir), (Class)EncryptionUtils.$get$array$$class$java$io$File());
        return callSiteArray[69].call((Object)fromFiles, (Object)new EncryptionUtils$_decryptFiles_closure3(EncryptionUtils.$get$$class$org$linkedin$groovy$util$encryption$EncryptionUtils(), EncryptionUtils.$get$$class$org$linkedin$groovy$util$encryption$EncryptionUtils(), secretKeys, toDir));
    }

    public static boolean isEncrypted(String encrypted) {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        Integer startIndex = (Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[70].call((Object)encrypted, (Object)ENCRYPTEDPREFIX), (Class)EncryptionUtils.$get$$class$java$lang$Integer());
        return DefaultTypeTransformation.booleanUnbox((Object)((Boolean)ScriptBytecodeAdapter.castToType((Object)(ScriptBytecodeAdapter.compareGreaterThan((Object)startIndex, (Object)$const$4) ? Boolean.TRUE : Boolean.FALSE), (Class)EncryptionUtils.$get$$class$java$lang$Boolean())));
    }

    public static String encryptionKeyName(String encrypted) {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[71].callStatic(EncryptionUtils.$get$$class$org$linkedin$groovy$util$encryption$EncryptionUtils(), (Object)encrypted))) {
            byte[][] decoded = (byte[][])ScriptBytecodeAdapter.castToType((Object)callSiteArray[72].callStatic(EncryptionUtils.$get$$class$org$linkedin$groovy$util$encryption$EncryptionUtils(), (Object)encrypted), (Class)EncryptionUtils.$get$array$$$class$byte());
            return (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[73].callConstructor((Object)EncryptionUtils.$get$$class$java$lang$String(), callSiteArray[74].call((Object)decoded, (Object)$const$3)), (Class)EncryptionUtils.$get$$class$java$lang$String());
        }
        return (String)ScriptBytecodeAdapter.castToType(null, (Class)EncryptionUtils.$get$$class$java$lang$String());
    }

    private static SecretKeySpec getSecretKeySpec(Map<String, byte[]> secretKeys, String keyName) throws NoSuchAlgorithmException, IOException {
        Object sks;
        block0: {
            CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
            sks = (SecretKeySpec)ScriptBytecodeAdapter.castToType(null, (Class)EncryptionUtils.$get$$class$javax$crypto$spec$SecretKeySpec());
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[75].call(secretKeys, (Object)keyName))) break block0;
            byte[] secretKey = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[76].call(secretKeys, (Object)keyName), (Class)EncryptionUtils.$get$array$$class$byte());
            sks = callSiteArray[77].callConstructor((Object)EncryptionUtils.$get$$class$javax$crypto$spec$SecretKeySpec(), (Object)secretKey, (Object)ALGORITHM);
        }
        return (SecretKeySpec)ScriptBytecodeAdapter.castToType((Object)sks, (Class)EncryptionUtils.$get$$class$javax$crypto$spec$SecretKeySpec());
    }

    private static String encode(byte[] bytes, byte[] iv, String keyName) {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        Object builder = callSiteArray[78].callConstructor((Object)EncryptionUtils.$get$$class$java$lang$StringBuilder());
        callSiteArray[79].call(builder, (Object)ENCRYPTEDPREFIX);
        callSiteArray[80].call(builder, callSiteArray[81].callStatic(EncryptionUtils.$get$$class$org$linkedin$groovy$util$encryption$EncryptionUtils(), (Object)bytes));
        callSiteArray[82].call(builder, (Object)",");
        callSiteArray[83].call(builder, callSiteArray[84].callStatic(EncryptionUtils.$get$$class$org$linkedin$groovy$util$encryption$EncryptionUtils(), (Object)iv));
        callSiteArray[85].call(builder, (Object)",");
        callSiteArray[86].call(builder, callSiteArray[87].callStatic(EncryptionUtils.$get$$class$org$linkedin$groovy$util$encryption$EncryptionUtils(), callSiteArray[88].call((Object)keyName)));
        callSiteArray[89].call(builder, (Object)ENCRYPTEDSUFFIX);
        return (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[90].call(builder), (Class)EncryptionUtils.$get$$class$java$lang$String());
    }

    private static byte[][] decode(String encoded) throws IOException {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        byte[][] decoded = (byte[][])ScriptBytecodeAdapter.castToType((Object)new byte[DefaultTypeTransformation.intUnbox((Object)$const$5)], (Class)EncryptionUtils.$get$array$$$class$byte());
        Integer startIndex = (Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[91].call((Object)encoded, (Object)ENCRYPTEDPREFIX), (Class)EncryptionUtils.$get$$class$java$lang$Integer());
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)startIndex, (Object)$const$4)) {
            startIndex = (Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[92].call((Object)startIndex, callSiteArray[93].call((Object)ENCRYPTEDPREFIX)), (Class)EncryptionUtils.$get$$class$java$lang$Integer());
            Integer endIndex = (Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[94].call((Object)encoded, (Object)ENCRYPTEDSUFFIX, (Object)startIndex), (Class)EncryptionUtils.$get$$class$java$lang$Integer());
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)endIndex, (Object)$const$4)) {
                String stringToDecode = (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[95].call((Object)encoded, (Object)startIndex, (Object)endIndex), (Class)EncryptionUtils.$get$$class$java$lang$String());
                Integer i = $const$1;
                Object part = null;
                Object object = callSiteArray[96].call(callSiteArray[97].call((Object)stringToDecode, (Object)","));
                while (object.hasNext()) {
                    part = object.next();
                    Integer n = i;
                    callSiteArray[99].call((Object)i);
                    Object object2 = callSiteArray[100].callStatic(EncryptionUtils.$get$$class$org$linkedin$groovy$util$encryption$EncryptionUtils(), part);
                    callSiteArray[98].call((Object)decoded, (Object)n, object2);
                }
                return (byte[][])ScriptBytecodeAdapter.castToType((Object)decoded, (Class)EncryptionUtils.$get$array$$$class$byte());
            }
            throw (Throwable)callSiteArray[101].callConstructor((Object)EncryptionUtils.$get$$class$java$io$IOException(), callSiteArray[102].call(callSiteArray[103].call((Object)"Incorrrectly encoded string, Missing ENCRYPTEDSUFFIX '", (Object)ENCRYPTEDSUFFIX), (Object)"'"));
        }
        throw (Throwable)callSiteArray[104].callConstructor((Object)EncryptionUtils.$get$$class$java$io$IOException(), callSiteArray[105].call(callSiteArray[106].call((Object)"Input not correctly encoded, missing ENCRYPTEDPREFIX '", (Object)ENCRYPTEDPREFIX), (Object)"'"));
    }

    private static byte[] generateIV(Cipher cipher) {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        byte[] ivBytes = new byte[DefaultTypeTransformation.intUnbox((Object)callSiteArray[107].call((Object)cipher))];
        callSiteArray[108].call((Object)RANDOM, (Object)ivBytes);
        return (byte[])ScriptBytecodeAdapter.castToType((Object)ivBytes, (Class)EncryptionUtils.$get$array$$class$byte());
    }

    private static String encodeToBase64(byte ... b) {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        return (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[109].call((Object)BASE64CODEC, (Object)b), (Class)EncryptionUtils.$get$$class$java$lang$String());
    }

    private static byte[] decodeFromBase64(String s) {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        return (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[110].call((Object)BASE64CODEC, (Object)s), (Class)EncryptionUtils.$get$array$$class$byte());
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        int[] nArray = new int[]{DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.castToType((Object)0, Integer.TYPE))};
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN((Class)EncryptionUtils.$get$$class$org$linkedin$groovy$util$encryption$EncryptionUtils(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)EncryptionUtils.$get$$class$java$lang$String())), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])nArray));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        ScriptBytecodeAdapter.setGroovyObjectField((Object)value, (Class)EncryptionUtils.$get$$class$org$linkedin$groovy$util$encryption$EncryptionUtils(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)EncryptionUtils.$get$$class$java$lang$String())));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        CallSite[] callSiteArray = EncryptionUtils.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectField((Class)EncryptionUtils.$get$$class$org$linkedin$groovy$util$encryption$EncryptionUtils(), (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), (Class)EncryptionUtils.$get$$class$java$lang$String())));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() == EncryptionUtils.$get$$class$org$linkedin$groovy$util$encryption$EncryptionUtils()) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        __timeStamp__239_neverHappen1304448616588 = 0L;
        __timeStamp = 1304448616588L;
        $const$5 = 3;
        $const$4 = -1;
        $const$3 = 2;
        $const$2 = 1;
        $const$1 = 0;
        $const$0 = 128;
        ENCRYPTEDSUFFIX = ")";
        KEYSTORETYPE = "JCEKS";
        PADDING = "PKCS5Padding";
        MODE = "CBC";
        ALGORITHM = "AES";
        CRYPTO = (String)ScriptBytecodeAdapter.castToType((Object)EncryptionUtils.$getCallSiteArray()[111].call(EncryptionUtils.$getCallSiteArray()[112].call(EncryptionUtils.$getCallSiteArray()[113].call(EncryptionUtils.$getCallSiteArray()[114].call((Object)ALGORITHM, (Object)"/"), (Object)MODE), (Object)"/"), (Object)PADDING), (Class)EncryptionUtils.$get$$class$java$lang$String());
        RANDOM = (SecureRandom)EncryptionUtils.$getCallSiteArray()[115].callConstructor((Object)EncryptionUtils.$get$$class$java$security$SecureRandom());
        ENCRYPTEDPREFIX = (String)ScriptBytecodeAdapter.castToType((Object)EncryptionUtils.$getCallSiteArray()[116].call(EncryptionUtils.$getCallSiteArray()[117].call((Object)"Encrypted-", (Object)CRYPTO), (Object)"("), (Class)EncryptionUtils.$get$$class$java$lang$String());
        REGEXTOMATCH = (String)ScriptBytecodeAdapter.castToType((Object)EncryptionUtils.$getCallSiteArray()[118].call(EncryptionUtils.$getCallSiteArray()[119].call(EncryptionUtils.$getCallSiteArray()[120].call(EncryptionUtils.$getCallSiteArray()[121].call(EncryptionUtils.$getCallSiteArray()[122].call(EncryptionUtils.$getCallSiteArray()[123].call((Object)"Encrypted-", (Object)CRYPTO), (Object)"\\("), (Object)"[^\\"), (Object)ENCRYPTEDSUFFIX), (Object)"]+\\"), (Object)ENCRYPTEDSUFFIX), (Class)EncryptionUtils.$get$$class$java$lang$String());
        ENCRYPTEDPATTERN = (Pattern)ScriptBytecodeAdapter.castToType((Object)EncryptionUtils.$getCallSiteArray()[124].call((Object)EncryptionUtils.$get$$class$java$util$regex$Pattern(), EncryptionUtils.$getCallSiteArray()[125].call(EncryptionUtils.$getCallSiteArray()[126].call((Object)"(", (Object)REGEXTOMATCH), (Object)")")), (Class)EncryptionUtils.$get$$class$java$util$regex$Pattern());
        BASE64CODEC = (Base64Codec)EncryptionUtils.$getCallSiteArray()[127].callConstructor((Object)EncryptionUtils.$get$$class$org$linkedin$util$codec$Base64Codec());
    }

    public /* synthetic */ void super$1$wait() {
        super.wait();
    }

    public /* synthetic */ String super$1$toString() {
        return super.toString();
    }

    public /* synthetic */ void super$1$wait(long l) {
        super.wait(l);
    }

    public /* synthetic */ void super$1$wait(long l, int n) {
        super.wait(l, n);
    }

    public /* synthetic */ void super$1$notify() {
        super.notify();
    }

    public /* synthetic */ void super$1$notifyAll() {
        super.notifyAll();
    }

    public /* synthetic */ Class super$1$getClass() {
        return super.getClass();
    }

    public /* synthetic */ Object super$1$clone() {
        return super.clone();
    }

    public /* synthetic */ boolean super$1$equals(Object object) {
        return super.equals(object);
    }

    public /* synthetic */ int super$1$hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ void super$1$finalize() {
        super.finalize();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "exists";
        stringArray[1] = "getSecretKeys";
        stringArray[2] = "getAt";
        stringArray[3] = "getInstance";
        stringArray[4] = "init";
        stringArray[5] = "generateKey";
        stringArray[6] = "saveSecretKey";
        stringArray[7] = "getInstance";
        stringArray[8] = "exists";
        stringArray[9] = "<$constructor$>";
        stringArray[10] = "load";
        stringArray[11] = "toCharArray";
        stringArray[12] = "close";
        stringArray[13] = "close";
        stringArray[14] = "load";
        stringArray[15] = "toCharArray";
        stringArray[16] = "<$constructor$>";
        stringArray[17] = "loadKeyStore";
        stringArray[18] = "setEntry";
        stringArray[19] = "<$constructor$>";
        stringArray[20] = "toCharArray";
        stringArray[21] = "<$constructor$>";
        stringArray[22] = "store";
        stringArray[23] = "toCharArray";
        stringArray[24] = "close";
        stringArray[25] = "close";
        stringArray[26] = "loadKeyStore";
        stringArray[27] = "isKeyEntry";
        stringArray[28] = "getEntry";
        stringArray[29] = "<$constructor$>";
        stringArray[30] = "toCharArray";
        stringArray[31] = "getSecretKey";
        stringArray[32] = "<$constructor$>";
        stringArray[33] = "getSecretKeys";
        stringArray[34] = "loadKeyStore";
        stringArray[35] = "each";
        stringArray[36] = "aliases";
        stringArray[37] = "getSecretKeySpec";
        stringArray[38] = "getInstance";
        stringArray[39] = "generateIV";
        stringArray[40] = "init";
        stringArray[41] = "ENCRYPT_MODE";
        stringArray[42] = "<$constructor$>";
        stringArray[43] = "doFinal";
        stringArray[44] = "getBytes";
        stringArray[45] = "encode";
        stringArray[46] = "decode";
        stringArray[47] = "getAt";
        stringArray[48] = "getAt";
        stringArray[49] = "<$constructor$>";
        stringArray[50] = "getAt";
        stringArray[51] = "getSecretKeySpec";
        stringArray[52] = "getInstance";
        stringArray[53] = "init";
        stringArray[54] = "DECRYPT_MODE";
        stringArray[55] = "<$constructor$>";
        stringArray[56] = "doFinal";
        stringArray[57] = "<$constructor$>";
        stringArray[58] = "processBuffer";
        stringArray[59] = "matcher";
        stringArray[60] = "<$constructor$>";
        stringArray[61] = "find";
        stringArray[62] = "appendReplacement";
        stringArray[63] = "append";
        stringArray[64] = "call";
        stringArray[65] = "group";
        stringArray[66] = "appendTail";
        stringArray[67] = "toString";
        stringArray[68] = "listFiles";
        stringArray[69] = "each";
        stringArray[70] = "indexOf";
        stringArray[71] = "isEncrypted";
        stringArray[72] = "decode";
        stringArray[73] = "<$constructor$>";
        stringArray[74] = "getAt";
        stringArray[75] = "getAt";
        stringArray[76] = "getAt";
        stringArray[77] = "<$constructor$>";
        stringArray[78] = "<$constructor$>";
        stringArray[79] = "append";
        stringArray[80] = "append";
        stringArray[81] = "encodeToBase64";
        stringArray[82] = "append";
        stringArray[83] = "append";
        stringArray[84] = "encodeToBase64";
        stringArray[85] = "append";
        stringArray[86] = "append";
        stringArray[87] = "encodeToBase64";
        stringArray[88] = "getBytes";
        stringArray[89] = "append";
        stringArray[90] = "toString";
        stringArray[91] = "indexOf";
        stringArray[92] = "plus";
        stringArray[93] = "length";
        stringArray[94] = "indexOf";
        stringArray[95] = "substring";
        stringArray[96] = "iterator";
        stringArray[97] = "split";
        stringArray[98] = "putAt";
        stringArray[99] = "next";
        stringArray[100] = "decodeFromBase64";
        stringArray[101] = "<$constructor$>";
        stringArray[102] = "plus";
        stringArray[103] = "plus";
        stringArray[104] = "<$constructor$>";
        stringArray[105] = "plus";
        stringArray[106] = "plus";
        stringArray[107] = "getBlockSize";
        stringArray[108] = "nextBytes";
        stringArray[109] = "encode";
        stringArray[110] = "decode";
        stringArray[111] = "plus";
        stringArray[112] = "plus";
        stringArray[113] = "plus";
        stringArray[114] = "plus";
        stringArray[115] = "<$constructor$>";
        stringArray[116] = "plus";
        stringArray[117] = "plus";
        stringArray[118] = "plus";
        stringArray[119] = "plus";
        stringArray[120] = "plus";
        stringArray[121] = "plus";
        stringArray[122] = "plus";
        stringArray[123] = "plus";
        stringArray[124] = "compile";
        stringArray[125] = "plus";
        stringArray[126] = "plus";
        stringArray[127] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[128];
        EncryptionUtils.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(EncryptionUtils.$get$$class$org$linkedin$groovy$util$encryption$EncryptionUtils(), stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = EncryptionUtils.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    private static /* synthetic */ Class $get$$class$java$io$FileOutputStream() {
        Class clazz = $class$java$io$FileOutputStream;
        if (clazz == null) {
            clazz = $class$java$io$FileOutputStream = EncryptionUtils.class$("java.io.FileOutputStream");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$array$$class$java$io$File() {
        Class clazz = array$$class$java$io$File;
        if (clazz == null) {
            clazz = array$$class$java$io$File = EncryptionUtils.class$("[Ljava.io.File;");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$security$KeyStore() {
        Class clazz = $class$java$security$KeyStore;
        if (clazz == null) {
            clazz = $class$java$security$KeyStore = EncryptionUtils.class$("java.security.KeyStore");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$lang$StringBuilder() {
        Class clazz = $class$java$lang$StringBuilder;
        if (clazz == null) {
            clazz = $class$java$lang$StringBuilder = EncryptionUtils.class$("java.lang.StringBuilder");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$org$linkedin$groovy$util$encryption$EncryptionUtils() {
        Class clazz = $class$org$linkedin$groovy$util$encryption$EncryptionUtils;
        if (clazz == null) {
            clazz = $class$org$linkedin$groovy$util$encryption$EncryptionUtils = EncryptionUtils.class$("org.linkedin.groovy.util.encryption.EncryptionUtils");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$array$$class$byte() {
        Class clazz = array$$class$byte;
        if (clazz == null) {
            clazz = array$$class$byte = EncryptionUtils.class$("[B");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$lang$String() {
        Class clazz = $class$java$lang$String;
        if (clazz == null) {
            clazz = $class$java$lang$String = EncryptionUtils.class$("java.lang.String");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$io$File() {
        Class clazz = $class$java$io$File;
        if (clazz == null) {
            clazz = $class$java$io$File = EncryptionUtils.class$("java.io.File");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$javax$crypto$KeyGenerator() {
        Class clazz = $class$javax$crypto$KeyGenerator;
        if (clazz == null) {
            clazz = $class$javax$crypto$KeyGenerator = EncryptionUtils.class$("javax.crypto.KeyGenerator");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$util$Map() {
        Class clazz = $class$java$util$Map;
        if (clazz == null) {
            clazz = $class$java$util$Map = EncryptionUtils.class$("java.util.Map");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$security$SecureRandom() {
        Class clazz = $class$java$security$SecureRandom;
        if (clazz == null) {
            clazz = $class$java$security$SecureRandom = EncryptionUtils.class$("java.security.SecureRandom");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$array$$$class$byte() {
        Class clazz = array$$$class$byte;
        if (clazz == null) {
            clazz = array$$$class$byte = EncryptionUtils.class$("[[B");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$util$regex$Pattern() {
        Class clazz = $class$java$util$regex$Pattern;
        if (clazz == null) {
            clazz = $class$java$util$regex$Pattern = EncryptionUtils.class$("java.util.regex.Pattern");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$javax$crypto$spec$SecretKeySpec() {
        Class clazz = $class$javax$crypto$spec$SecretKeySpec;
        if (clazz == null) {
            clazz = $class$javax$crypto$spec$SecretKeySpec = EncryptionUtils.class$("javax.crypto.spec.SecretKeySpec");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$util$regex$Matcher() {
        Class clazz = $class$java$util$regex$Matcher;
        if (clazz == null) {
            clazz = $class$java$util$regex$Matcher = EncryptionUtils.class$("java.util.regex.Matcher");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$lang$StringBuffer() {
        Class clazz = $class$java$lang$StringBuffer;
        if (clazz == null) {
            clazz = $class$java$lang$StringBuffer = EncryptionUtils.class$("java.lang.StringBuffer");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$org$linkedin$util$codec$Base64Codec() {
        Class clazz = $class$org$linkedin$util$codec$Base64Codec;
        if (clazz == null) {
            clazz = $class$org$linkedin$util$codec$Base64Codec = EncryptionUtils.class$("org.linkedin.util.codec.Base64Codec");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$javax$crypto$spec$IvParameterSpec() {
        Class clazz = $class$javax$crypto$spec$IvParameterSpec;
        if (clazz == null) {
            clazz = $class$javax$crypto$spec$IvParameterSpec = EncryptionUtils.class$("javax.crypto.spec.IvParameterSpec");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$javax$crypto$Cipher() {
        Class clazz = $class$javax$crypto$Cipher;
        if (clazz == null) {
            clazz = $class$javax$crypto$Cipher = EncryptionUtils.class$("javax.crypto.Cipher");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$io$FileInputStream() {
        Class clazz = $class$java$io$FileInputStream;
        if (clazz == null) {
            clazz = $class$java$io$FileInputStream = EncryptionUtils.class$("java.io.FileInputStream");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$io$IOException() {
        Class clazz = $class$java$io$IOException;
        if (clazz == null) {
            clazz = $class$java$io$IOException = EncryptionUtils.class$("java.io.IOException");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$lang$Integer() {
        Class clazz = $class$java$lang$Integer;
        if (clazz == null) {
            clazz = $class$java$lang$Integer = EncryptionUtils.class$("java.lang.Integer");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$groovy$lang$MetaClass() {
        Class clazz = $class$groovy$lang$MetaClass;
        if (clazz == null) {
            clazz = $class$groovy$lang$MetaClass = EncryptionUtils.class$("groovy.lang.MetaClass");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$javax$crypto$SecretKey() {
        Class clazz = $class$javax$crypto$SecretKey;
        if (clazz == null) {
            clazz = $class$javax$crypto$SecretKey = EncryptionUtils.class$("javax.crypto.SecretKey");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$lang$Boolean() {
        Class clazz = $class$java$lang$Boolean;
        if (clazz == null) {
            clazz = $class$java$lang$Boolean = EncryptionUtils.class$("java.lang.Boolean");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$security$KeyStore$SecretKeyEntry() {
        Class clazz = $class$java$security$KeyStore$SecretKeyEntry;
        if (clazz == null) {
            clazz = $class$java$security$KeyStore$SecretKeyEntry = EncryptionUtils.class$("java.security.KeyStore$SecretKeyEntry");
        }
        return clazz;
    }

    private static /* synthetic */ Class $get$$class$java$security$KeyStore$PasswordProtection() {
        Class clazz = $class$java$security$KeyStore$PasswordProtection;
        if (clazz == null) {
            clazz = $class$java$security$KeyStore$PasswordProtection = EncryptionUtils.class$("java.security.KeyStore$PasswordProtection");
        }
        return clazz;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

