/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.security;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.spongycastle.crypto.BlockCipher;
import org.spongycastle.crypto.BufferedBlockCipher;
import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.crypto.engines.AESEngine;
import org.spongycastle.crypto.engines.AESFastEngine;
import org.spongycastle.crypto.io.CipherInputStream;
import org.spongycastle.crypto.io.CipherOutputStream;
import org.spongycastle.crypto.modes.CBCBlockCipher;
import org.spongycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.spongycastle.crypto.params.KeyParameter;
import org.spongycastle.crypto.params.ParametersWithIV;

public class Encryption {
    public static byte[] getDigest(String string) {
        return Encryption.getDigest(string, "UTF-8");
    }

    public static byte[] getDigest(String string, String encoding) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("String cannot be null or empty");
        }
        if (encoding == null || encoding.length() == 0) {
            throw new IllegalArgumentException("Encoding cannot be null or empty");
        }
        MessageDigest md = Encryption.getMessageDigestInstance();
        try {
            byte[] bytes = string.getBytes(encoding);
            md.update(bytes, 0, bytes.length);
            return md.digest();
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(encoding + " is not supported");
        }
    }

    public static MessageDigest getMessageDigestInstance() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("SHA-256 is not supported");
        }
    }

    public static byte[] getFinalKeyDigest(byte[] key, byte[] masterSeed, byte[] transformSeed, long transformRounds) {
        AESEngine engine = new AESEngine();
        engine.init(true, (CipherParameters)new KeyParameter(transformSeed));
        byte[] transformedKey = new byte[key.length];
        System.arraycopy(key, 0, transformedKey, 0, transformedKey.length);
        for (long rounds = 0L; rounds < transformRounds; ++rounds) {
            engine.processBlock(transformedKey, 0, transformedKey, 0);
            engine.processBlock(transformedKey, 16, transformedKey, 16);
        }
        MessageDigest md = Encryption.getMessageDigestInstance();
        byte[] transformedKeyDigest = md.digest(transformedKey);
        md.update(masterSeed);
        return md.digest(transformedKeyDigest);
    }

    public static InputStream getDecryptedInputStream(InputStream encryptedInputStream, byte[] keyData, byte[] ivData) {
        ParametersWithIV keyAndIV = new ParametersWithIV((CipherParameters)new KeyParameter(keyData), ivData);
        PaddedBufferedBlockCipher pbbc = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESFastEngine()));
        pbbc.init(false, (CipherParameters)keyAndIV);
        return new CipherInputStream(encryptedInputStream, (BufferedBlockCipher)pbbc);
    }

    public static OutputStream getEncryptedOutputStream(OutputStream decryptedOutputStream, byte[] keyData, byte[] ivData) {
        ParametersWithIV keyAndIV = new ParametersWithIV((CipherParameters)new KeyParameter(keyData), ivData);
        PaddedBufferedBlockCipher pbbc = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESFastEngine()));
        pbbc.init(true, (CipherParameters)keyAndIV);
        return new CipherOutputStream(decryptedOutputStream, (BufferedBlockCipher)pbbc);
    }
}

