/*
 * Decompiled with CFR 0.152.
 */
package org.lilicurroad.jenkins.packageversion.yum.model.common;

import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.lilicurroad.jenkins.packageversion.PackageMetadata;
import org.lilicurroad.jenkins.packageversion.yum.model.common.Location;
import org.lilicurroad.jenkins.packageversion.yum.model.common.Time;
import org.lilicurroad.jenkins.packageversion.yum.model.common.Version;

@XmlRootElement(name="package", namespace="http://linux.duke.edu/metadata/common")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Package
implements Comparable<Package>,
PackageMetadata {
    private String name;
    private String arch;
    private Location location;
    private Version version;
    private Time time;

    @XmlElement(required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement
    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    @XmlElement
    public String getArch() {
        return this.arch;
    }

    public void setArch(String arch) {
        this.arch = arch;
    }

    @XmlElement
    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    @XmlElement
    public Time getTime() {
        return this.time;
    }

    public void setTime(Time time) {
        this.time = time;
    }

    @Override
    public String getPackageName() {
        return this.name;
    }

    @Override
    public String getPackageVersion() {
        return String.format("%s-%s", this.version.getVer(), this.version.getRel());
    }

    @Override
    public int compareTo(Package o) {
        if (o == null || o.getTime() == null || o.getTime().getBuild() == null) {
            return 1;
        }
        if (this.time.getBuild() == null) {
            return -1;
        }
        return this.time.getBuild().compareTo(o.getTime().getBuild());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Package)) {
            return false;
        }
        Package aPackage = (Package)o;
        return Objects.equals(this.name, aPackage.name) && Objects.equals(this.arch, aPackage.arch) && Objects.equals(this.location, aPackage.location) && Objects.equals(this.version, aPackage.version) && Objects.equals(this.time, aPackage.time);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.arch, this.location, this.version, this.time);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("arch", (Object)this.arch).append("location", (Object)this.location).append("version", (Object)this.version).append("time", (Object)this.time).toString();
    }
}

