/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.connections.socket;

import com.sun.star.comp.loader.FactoryHelper;
import com.sun.star.connection.AlreadyAcceptingException;
import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.connection.XAcceptor;
import com.sun.star.connection.XConnection;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.lib.connections.socket.ConnectionDescriptor;
import com.sun.star.lib.connections.socket.SocketConnection;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.uno.RuntimeException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;

public final class socketAcceptor
implements XAcceptor {
    public static final String __serviceName = "com.sun.star.connection.socketAcceptor";
    private static final boolean DEBUG = false;
    private ServerSocket server = null;
    private String acceptingDescription;
    private Boolean tcpNoDelay;

    public static XSingleServiceFactory __getServiceFactory(String implName, XMultiServiceFactory multiFactory, XRegistryKey regKey) {
        return implName.equals(socketAcceptor.class.getName()) ? FactoryHelper.getServiceFactory(socketAcceptor.class, __serviceName, multiFactory, regKey) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XConnection accept(String connectionDescription) throws AlreadyAcceptingException, ConnectionSetupException, IllegalArgumentException {
        ServerSocket serv;
        socketAcceptor socketAcceptor2 = this;
        synchronized (socketAcceptor2) {
            if (this.server == null) {
                ConnectionDescriptor desc = new ConnectionDescriptor(connectionDescription);
                String host = desc.getHost();
                if (host.equals("0")) {
                    host = null;
                }
                try {
                    this.server = new ServerSocket(desc.getPort(), desc.getBacklog(), host == null ? null : InetAddress.getByName(host));
                }
                catch (IOException e) {
                    throw new ConnectionSetupException((Throwable)e);
                }
                this.acceptingDescription = connectionDescription;
                this.tcpNoDelay = desc.getTcpNoDelay();
            } else if (!connectionDescription.equals(this.acceptingDescription)) {
                throw new AlreadyAcceptingException(this.acceptingDescription + " vs. " + connectionDescription);
            }
            serv = this.server;
        }
        try {
            Socket socket = serv.accept();
            if (this.tcpNoDelay != null) {
                socket.setTcpNoDelay(this.tcpNoDelay);
            } else if (((InetSocketAddress)socket.getRemoteSocketAddress()).getAddress().isLoopbackAddress()) {
                socket.setTcpNoDelay(true);
            }
            return new SocketConnection(this.acceptingDescription, socket);
        }
        catch (IOException e) {
            throw new ConnectionSetupException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAccepting() {
        ServerSocket serv;
        socketAcceptor socketAcceptor2 = this;
        synchronized (socketAcceptor2) {
            serv = this.server;
        }
        try {
            serv.close();
        }
        catch (IOException e) {
            throw new RuntimeException((Throwable)e);
        }
    }
}

