/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.helper;

import com.sun.star.lang.EventObject;
import com.sun.star.lang.XEventListener;
import com.sun.star.uno.UnoRuntime;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class InterfaceContainer
implements Cloneable {
    static final boolean DEBUG = false;
    Object[] elementData;
    private int size;

    public InterfaceContainer() {
        this(10);
    }

    public InterfaceContainer(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new Object[initialCapacity];
    }

    private InterfaceContainer(Object[] data) {
        this.elementData = data;
        this.size = this.elementData == null ? 0 : this.elementData.length;
    }

    public synchronized void trimToSize() {
        int oldCapacity = this.elementData.length;
        if (this.size < oldCapacity) {
            Object[] oldData = this.elementData;
            this.elementData = new Object[this.size];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    public synchronized void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            Object[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new Object[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    public synchronized boolean add(Object o) {
        boolean ret = false;
        if (this.elementData != null && o != null) {
            this.ensureCapacity(this.size + 1);
            this.elementData[this.size++] = o;
            ret = true;
        }
        return ret;
    }

    public synchronized void add(int index, Object element) {
        if (this.elementData != null && element != null) {
            if (index > this.size || index < 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
            this.ensureCapacity(this.size + 1);
            System.arraycopy(this.elementData, index, this.elementData, index + 1, this.size - index);
            this.elementData[index] = element;
            ++this.size;
        }
    }

    public synchronized boolean addAll(Collection c) {
        int numNew = c.size();
        this.ensureCapacity(this.size + numNew);
        Iterator e = c.iterator();
        for (int i = 0; i < numNew; ++i) {
            Object o = e.next();
            if (o == null) continue;
            this.elementData[this.size++] = o;
        }
        return numNew != 0;
    }

    public synchronized boolean addAll(int index, Collection c) {
        boolean ret = false;
        if (this.elementData != null) {
            if (index > this.size || index < 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
            int sizeCol = c.size();
            Object[] arColl = new Object[sizeCol];
            Iterator icol = c.iterator();
            int curIndex = 0;
            for (int i = 0; i < sizeCol; ++i) {
                Object o = icol.next();
                if (o == null) continue;
                arColl[curIndex++] = o;
            }
            int numNew = curIndex;
            this.ensureCapacity(this.size + numNew);
            int numMoved = this.size - index;
            if (numMoved > 0) {
                System.arraycopy(this.elementData, index, this.elementData, index + numNew, numMoved);
            }
            for (int i = 0; i < numNew; ++i) {
                this.elementData[index++] = arColl[i];
            }
            this.size += numNew;
            ret = numNew != 0;
        }
        return ret;
    }

    public synchronized void clear() {
        if (this.elementData != null) {
            for (int i = 0; i < this.size; ++i) {
                this.elementData[i] = null;
            }
            this.size = 0;
        }
    }

    public synchronized boolean contains(Object elem) {
        return this.indexOf(elem) >= 0;
    }

    public synchronized boolean containsAll(Collection collection) {
        boolean retVal = true;
        if (this.elementData != null && collection != null) {
            for (Object obj : collection) {
                if (this.contains(obj)) continue;
                retVal = false;
                break;
            }
        }
        return retVal;
    }

    public synchronized Object get(int index) {
        if (this.elementData != null) {
            this.RangeCheck(index);
            return this.elementData[index];
        }
        return null;
    }

    public synchronized int indexOf(Object elem) {
        int i;
        if (this.elementData == null || elem == null) {
            return -1;
        }
        int index = -1;
        for (i = 0; i < this.size; ++i) {
            if (elem != this.elementData[i]) continue;
            index = i;
            break;
        }
        if (index == -1) {
            for (i = 0; i < this.size; ++i) {
                if (!UnoRuntime.areSame((Object)elem, (Object)this.elementData[i])) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    public synchronized Iterator iterator() {
        if (this.elementData != null) {
            InterfaceContainer aCopy = (InterfaceContainer)this.clone();
            return new Itr(aCopy);
        }
        return null;
    }

    public synchronized int lastIndexOf(Object elem) {
        int i;
        if (this.elementData == null || elem == null) {
            return -1;
        }
        int index = -1;
        for (i = this.size - 1; i >= 0; --i) {
            if (elem != this.elementData[i]) continue;
            index = i;
            break;
        }
        if (index == -1) {
            for (i = this.size - 1; i >= 0; --i) {
                if (!UnoRuntime.areSame((Object)elem, (Object)this.elementData[i])) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    public synchronized Object clone() {
        Object[] data;
        if (this.elementData == null) {
            data = null;
        } else {
            data = new Object[this.size];
            System.arraycopy(this.elementData, 0, data, 0, this.size);
        }
        return new InterfaceContainer(data);
    }

    public synchronized ListIterator listIterator() {
        return this.listIterator(0);
    }

    public synchronized ListIterator listIterator(int index) {
        if (this.elementData != null) {
            InterfaceContainer aCopy = (InterfaceContainer)this.clone();
            return new LstItr(aCopy, index);
        }
        return null;
    }

    public synchronized Object remove(int index) {
        Object ret = null;
        if (this.elementData != null) {
            this.RangeCheck(index);
            ret = this.elementData[index];
            int numMoved = this.size - index - 1;
            if (numMoved > 0) {
                System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
            }
            this.elementData[--this.size] = null;
        }
        return ret;
    }

    public synchronized boolean remove(Object obj) {
        int index;
        boolean ret = false;
        if (this.elementData != null && obj != null && (index = this.indexOf(obj)) != -1) {
            ret = true;
            this.remove(index);
        }
        return ret;
    }

    public synchronized boolean removeAll(Collection collection) {
        boolean retVal = false;
        if (this.elementData != null && collection != null) {
            for (Object obj : collection) {
                boolean bMod = this.remove(obj);
                if (!bMod) continue;
                retVal = true;
            }
        }
        return retVal;
    }

    public synchronized boolean retainAll(Collection collection) {
        if (this.elementData == null || collection == null) {
            return false;
        }
        boolean retVal = false;
        Object[] arRetained = new Object[this.size];
        int indexRetained = 0;
        for (int i = 0; i < this.size; ++i) {
            Object curElem = this.elementData[i];
            Iterator itColl = collection.iterator();
            boolean bExists = false;
            while (itColl.hasNext()) {
                if (curElem != itColl.next()) continue;
                bExists = true;
                break;
            }
            if (!bExists) {
                for (Object o : collection) {
                    if (o == null || !UnoRuntime.areSame(o, (Object)curElem)) continue;
                    bExists = true;
                    break;
                }
            }
            if (!bExists) continue;
            arRetained[indexRetained++] = curElem;
        }
        boolean bl = retVal = this.size != indexRetained;
        if (indexRetained > 0) {
            this.elementData = arRetained;
            this.size = indexRetained;
        }
        return retVal;
    }

    public synchronized Object set(int index, Object element) {
        Object ret = null;
        if (this.elementData != null && element != null) {
            this.RangeCheck(index);
            ret = this.elementData[index];
            this.elementData[index] = element;
        }
        return ret;
    }

    public synchronized int size() {
        if (this.elementData != null) {
            return this.size;
        }
        return 0;
    }

    public synchronized Object[] toArray() {
        if (this.elementData != null) {
            Object[] result = new Object[this.size];
            System.arraycopy(this.elementData, 0, result, 0, this.size);
            return result;
        }
        return null;
    }

    public synchronized Object[] toArray(Object[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        if (this.elementData != null) {
            System.arraycopy(this.elementData, 0, a, 0, this.size);
        }
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    private void RangeCheck(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeAndClear(EventObject evt) {
        Iterator aIt;
        InterfaceContainer interfaceContainer = this;
        synchronized (interfaceContainer) {
            aIt = this.iterator();
            this.clear();
            this.elementData = null;
            this.size = 0;
        }
        if (aIt != null) {
            while (aIt.hasNext()) {
                try {
                    Object o = aIt.next();
                    XEventListener evtListener = (XEventListener)UnoRuntime.queryInterface(XEventListener.class, o);
                    if (evtListener == null) continue;
                    evtListener.disposing(evt);
                }
                catch (RuntimeException runtimeException) {}
            }
        }
    }

    private class LstItr
    extends Itr
    implements ListIterator {
        LstItr(InterfaceContainer _data, int _index) {
            super(_data);
            this.cursor = _index;
        }

        public synchronized void add(Object o) {
            InterfaceContainer.this.add(o);
            this.dataIt.add(this.cursor++, o);
            this.lastRet = -1;
            this.lastRetObj = null;
        }

        public synchronized boolean hasPrevious() {
            return this.cursor != 0;
        }

        public synchronized int nextIndex() {
            return this.cursor;
        }

        public synchronized Object previous() {
            try {
                Object previous = this.dataIt.get(--this.cursor);
                this.lastRet = this.cursor;
                this.lastRetObj = previous;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                NoSuchElementException ex2 = new NoSuchElementException();
                ex2.initCause(e);
                throw ex2;
            }
        }

        public synchronized int previousIndex() {
            return this.cursor - 1;
        }

        public synchronized void set(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    private class Itr
    implements Iterator {
        InterfaceContainer dataIt;
        int cursor = 0;
        int lastRet = -1;
        Object lastRetObj = null;

        Itr(InterfaceContainer _data) {
            this.dataIt = _data;
        }

        public synchronized boolean hasNext() {
            return this.cursor != this.dataIt.size();
        }

        public synchronized Object next() {
            try {
                Object next = this.dataIt.get(this.cursor);
                this.lastRet = this.cursor++;
                this.lastRetObj = next;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                NoSuchElementException ex2 = new NoSuchElementException();
                ex2.initCause(e);
                throw ex2;
            }
        }

        public synchronized void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            InterfaceContainer.this.remove(this.lastRetObj);
            this.dataIt.remove(this.lastRet);
            if (this.lastRet < this.cursor) {
                --this.cursor;
            }
            this.lastRet = -1;
            this.lastRetObj = null;
        }
    }
}

