/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.helper;

import com.sun.star.lang.IllegalArgumentException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnoUrl {
    private static final String FORMAT_ERROR = "syntax: [uno:]connection-type,parameters;protocol-name,parameters;objectname";
    private static final String VALUE_CHAR_SET = "!$&'()*+-./:?@_~";
    private static final String OID_CHAR_SET = "!$&'()*+-./:?@_~,=";
    private final UnoUrlPart connection;
    private final UnoUrlPart protocol;
    private final String rootOid;

    private UnoUrl(UnoUrlPart connectionPart, UnoUrlPart protocolPart, String rootOid) {
        this.connection = connectionPart;
        this.protocol = protocolPart;
        this.rootOid = rootOid;
    }

    public String getConnection() {
        return this.connection.getPartTypeName();
    }

    public String getProtocol() {
        return this.protocol.getPartTypeName();
    }

    public String getRootOid() {
        return this.rootOid;
    }

    public HashMap<String, String> getProtocolParameters() {
        return this.protocol.getPartParameters();
    }

    public HashMap<String, String> getConnectionParameters() {
        return this.connection.getPartParameters();
    }

    public String getProtocolParametersAsString() {
        return this.protocol.getUninterpretedParameterString();
    }

    public String getConnectionParametersAsString() {
        return this.connection.getUninterpretedParameterString();
    }

    public String getProtocolAndParametersAsString() {
        return this.protocol.getUninterpretedString();
    }

    public String getConnectionAndParametersAsString() {
        return this.connection.getUninterpretedString();
    }

    private static String decodeUTF8(String s) throws IllegalArgumentException {
        if (!s.contains("%")) {
            return s;
        }
        try {
            int length = s.length();
            ByteBuffer bb = ByteBuffer.allocate(length);
            for (int i = 0; i < length; ++i) {
                int ch = s.charAt(i);
                if (ch == 37) {
                    if (i + 3 > length) {
                        throw new IllegalArgumentException("Incomplete trailing escape (%) pattern");
                    }
                    try {
                        ch = Integer.parseInt(s.substring(i + 1, i + 3), 16);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException((Throwable)e);
                    }
                    if (ch < 0) {
                        throw new IllegalArgumentException("Illegal hex characters in escape (%) pattern - negative value");
                    }
                    i += 2;
                }
                bb.put((byte)(ch & 0xFF));
            }
            byte[] bytes = new byte[bb.position()];
            System.arraycopy(bb.array(), 0, bytes, 0, bytes.length);
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException((Throwable)e, "Couldn't convert parameter string to UTF-8 string");
        }
    }

    private static HashMap<String, String> buildParamHashMap(String paramString) throws IllegalArgumentException {
        char c;
        HashMap<String, String> params = new HashMap<String, String>();
        int pos = 0;
        do {
            c = ',';
            String aKey = "";
            String aValue = "";
            while (pos < paramString.length()) {
                char c2 = paramString.charAt(pos++);
                c = c2;
                if (c2 == '=') break;
                aKey = aKey + c;
            }
            while (pos < paramString.length()) {
                char c3 = paramString.charAt(pos++);
                c = c3;
                if (c3 == ',' || c == 59) break;
                aValue = aValue + c;
            }
            if (aKey.length() <= 0 || aValue.length() <= 0) continue;
            if (!UnoUrl.isAlphaNumeric(aKey)) {
                throw new IllegalArgumentException("The parameter key '" + aKey + "' may only consist of alpha numeric ASCII characters.");
            }
            if (!UnoUrl.isValidString(aValue, "!$&'()*+-./:?@_~%")) {
                throw new IllegalArgumentException("The parameter value for key '" + aKey + "' contains illegal characters.");
            }
            params.put(aKey, UnoUrl.decodeUTF8(aValue));
        } while (pos < paramString.length() && c == 44);
        return params;
    }

    private static UnoUrlPart parseUnoUrlPart(String thePart) throws IllegalArgumentException {
        String theParamPart;
        String partName;
        int index = thePart.indexOf(44);
        if (index != -1) {
            partName = thePart.substring(0, index).trim();
            theParamPart = thePart.substring(index + 1).trim();
        } else {
            partName = thePart;
            theParamPart = "";
        }
        if (!UnoUrl.isAlphaNumeric(partName)) {
            throw new IllegalArgumentException("The part name '" + partName + "' may only consist of alpha numeric ASCII characters.");
        }
        HashMap<String, String> params = UnoUrl.buildParamHashMap(theParamPart);
        return new UnoUrlPart(theParamPart, partName, params);
    }

    private static boolean isAlphaNumeric(String s) {
        return UnoUrl.isValidString(s, null);
    }

    private static boolean isValidString(String identifier, String validCharSet) {
        int len = identifier.length();
        for (int i = 0; i < len; ++i) {
            boolean isValidChar;
            char ch = identifier.charAt(i);
            boolean bl = isValidChar = 'A' <= ch && ch <= 'Z' || 'a' <= ch && ch <= 'z' || '0' <= ch && ch <= '9';
            if (!isValidChar && validCharSet != null) {
                boolean bl2 = isValidChar = validCharSet.indexOf(ch) != -1;
            }
            if (isValidChar) continue;
            return false;
        }
        return true;
    }

    public static UnoUrl parseUnoUrl(String unoUrl) throws IllegalArgumentException {
        String unoStr;
        String url = unoUrl;
        int index = url.indexOf(58);
        if (index != -1 && !"uno".equals(unoStr = url.substring(0, index).trim())) {
            throw new IllegalArgumentException("Uno Urls must start with 'uno:'. syntax: [uno:]connection-type,parameters;protocol-name,parameters;objectname");
        }
        if ((index = (url = url.substring(index + 1).trim()).indexOf(59)) == -1) {
            throw new IllegalArgumentException("'" + unoUrl + "' is an invalid Uno Url. " + FORMAT_ERROR);
        }
        String connection = url.substring(0, index).trim();
        url = url.substring(index + 1).trim();
        UnoUrlPart connectionPart = UnoUrl.parseUnoUrlPart(connection);
        index = url.indexOf(59);
        if (index == -1) {
            throw new IllegalArgumentException("'" + unoUrl + "' is an invalid Uno Url. " + FORMAT_ERROR);
        }
        String protocol = url.substring(0, index).trim();
        url = url.substring(index + 1).trim();
        UnoUrlPart protocolPart = UnoUrl.parseUnoUrlPart(protocol);
        String rootOid = url.trim();
        if (!UnoUrl.isValidString(rootOid, OID_CHAR_SET)) {
            throw new IllegalArgumentException("Root OID '" + rootOid + "' contains illegal characters.");
        }
        return new UnoUrl(connectionPart, protocolPart, rootOid);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnoUrlPart {
        private final String partTypeName;
        private final HashMap<String, String> partParameters;
        private final String uninterpretedParameterString;

        public UnoUrlPart(String uninterpretedParameterString, String partTypeName, HashMap<String, String> partParameters) {
            this.uninterpretedParameterString = uninterpretedParameterString;
            this.partTypeName = partTypeName;
            this.partParameters = partParameters;
        }

        public String getPartTypeName() {
            return this.partTypeName;
        }

        public HashMap<String, String> getPartParameters() {
            return this.partParameters;
        }

        public String getUninterpretedParameterString() {
            return this.uninterpretedParameterString;
        }

        public String getUninterpretedString() {
            StringBuffer buf = new StringBuffer(this.partTypeName);
            if (this.uninterpretedParameterString.length() > 0) {
                buf.append(',');
                buf.append(this.uninterpretedParameterString);
            }
            return buf.toString();
        }
    }
}

