package org.libj.util;

import java.util.Objects;
import java.util.TimerTask;

public class DelegateTimerTask extends TimerTask {
  protected TimerTask target;

  /**
   * Creates a new {@link DelegateTimerTask} with the specified target {@link TimerTask}.
   *
   * @param target The target {@link TimerTask}.
   * @throws NullPointerException If the target {@link TimerTask} is null.
   */
  public DelegateTimerTask(final TimerTask target) {
    this.target = Objects.requireNonNull(target);
  }

  /**
   * Creates a new {@link DelegateTimerTask} with a null target.
   */
  protected DelegateTimerTask() {
  }

  public TimerTask getTarget() {
    return target;
  }

  public void setTarget(final TimerTask target) {
    this.target = target;
  }

  @Override
  public void run() {
    target.run();
  }
}