/*
 * Decompiled with CFR 0.152.
 */
package org.libj.net;

import java.io.IOException;
import java.net.ServerSocket;

public final class Sockets {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int findOpenPort(int from, int to) throws IOException {
        if (from < 1) {
            throw new IllegalArgumentException("from < 1: " + from);
        }
        if (from > to) {
            throw new IllegalArgumentException("from (" + from + ") > to (" + to + ")");
        }
        if (to > 65536) {
            throw new IllegalArgumentException("to > 65536: " + to);
        }
        int port = from;
        while (port < to) {
            try (ServerSocket socket = new ServerSocket(port);){
                int n = socket.getLocalPort();
                return n;
            }
            catch (IOException iOException) {
                ++port;
            }
        }
        throw new IOException("No available port found");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int findRandomOpenPort() {
        while (true) {
            try (ServerSocket socket = new ServerSocket(1 + (int)(Math.random() * 65535.0));){
                int n = socket.getLocalPort();
                return n;
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    private Sockets() {
    }
}

