/*
 * Decompiled with CFR 0.152.
 */
package org.libj.net;

import java.net.URL;
import java.net.URLStreamHandler;
import java.util.concurrent.ConcurrentHashMap;
import org.libj.net.URLStreamHandlers;
import org.libj.net.URLs;
import org.libj.net.memory.Handler;

public abstract class MemoryURLStreamHandler
extends URLStreamHandler {
    protected static final ConcurrentHashMap<String, byte[]> idToData;

    public static URL createURL(byte[] data) {
        String path = "/" + Integer.toHexString(System.identityHashCode(data));
        URL url = URLs.create("memory", null, path);
        idToData.put(path, data);
        return url;
    }

    public static byte[] getData(URL url) {
        if (!"memory".equals(url.getProtocol())) {
            throw new IllegalArgumentException("Illegal protocol: " + url.getProtocol());
        }
        if (url.getHost() != null && url.getHost().length() > 0) {
            throw new IllegalArgumentException("Illegal host: " + url.getHost());
        }
        return idToData.get(url.getPath());
    }

    static {
        URLStreamHandlers.register(Handler.class, Handler.Factory.class);
        idToData = new ConcurrentHashMap();
    }
}

