/*
 * Decompiled with CFR 0.152.
 */
package org.libj.net;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.libj.util.CollectionUtil;

public final class Cookies {
    public static String getCookieValue(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (cookie == null || !name.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    public static void setCookieValue(HttpServletResponse response, String name, String value, int maxAge) {
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(maxAge);
        response.addCookie(cookie);
    }

    public static void removeCookie(HttpServletResponse response, String name) {
        Cookies.setCookieValue(response, name, null, 0);
    }

    public static Map.Entry<String, String> createCookieHeader(Collection<String> cookies) {
        return new AbstractMap.SimpleEntry<String, String>("Cookie", CollectionUtil.toString(cookies, (String)";"));
    }

    private Cookies() {
    }
}

