/*
 * Decompiled with CFR 0.152.
 */
package org.libj.lang;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class Resources {
    public static void walk(ClassLoader classLoader, String name, ForEachEntry forEachEntry) throws IOException {
        Resources.traverse(classLoader.getResources(name), name, true, forEachEntry);
    }

    public static void list(ClassLoader classLoader, String name, ForEachEntry forEachEntry) throws IOException {
        Resources.traverse(classLoader.getResources(name), name, false, forEachEntry);
    }

    public static void traverse(Enumeration<URL> resources, String name, boolean recursive, ForEachEntry forEachEntry) throws IOException {
        if (!resources.hasMoreElements()) {
            return;
        }
        int nameLen = name.length();
        Reporter reporter = null;
        do {
            URL url = resources.nextElement();
            String str = url.toString();
            URL root = new URL(str.substring(0, str.length() - nameLen));
            if ("file".equals(url.getProtocol())) {
                String decodedUrl;
                try {
                    decodedUrl = URLDecoder.decode(url.getPath(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                File file = new File(decodedUrl);
                Path path = file.toPath();
                if (reporter == null) {
                    reporter = new Reporter(forEachEntry);
                }
                reporter.update(root, new File(decodedUrl.substring(0, decodedUrl.length() - nameLen)).toPath());
                if (file.isFile()) {
                    reporter.test(path, file);
                    continue;
                }
                if (recursive) {
                    Files.walk(path, new FileVisitOption[0]).allMatch(reporter);
                    continue;
                }
                if (nameLen == 0 && !forEachEntry.test(root, "/", true)) {
                    return;
                }
                Files.list(path).allMatch(reporter);
                continue;
            }
            if ("jar".equals(url.getProtocol())) {
                JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                jarURLConnection.setUseCaches(false);
                try (JarFile jarFile = jarURLConnection.getJarFile();){
                    String rootName = jarURLConnection.getEntryName();
                    if (nameLen == 0) {
                        forEachEntry.test(root, "/", true);
                    }
                    Enumeration<JarEntry> enumeration = jarFile.entries();
                    while (enumeration.hasMoreElements()) {
                        int s;
                        JarEntry entry = enumeration.nextElement();
                        String entryName = entry.getName();
                        int prefix = entryName.startsWith(rootName) ? rootName.length() : (entryName.startsWith(name) ? nameLen : 0);
                        if (prefix == 0 || !recursive && (s = entryName.indexOf(47, prefix + 1)) != -1 && s != entryName.length() - 1) continue;
                        forEachEntry.test(root, entryName, entry.isDirectory());
                    }
                }
            } else {
                throw new UnsupportedOperationException("Unsupported URL protocol: " + url);
            }
        } while (resources.hasMoreElements());
    }

    public static URL getResourceOrFile(String name) {
        URL resource = Thread.currentThread().getContextClassLoader().getResource(name);
        if (resource != null) {
            return resource;
        }
        File file = new File(name);
        if (!file.exists()) {
            return null;
        }
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(name, e);
        }
    }

    public static URL getFileOrResource(String name) {
        File file = new File(name);
        if (file.exists()) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(name, e);
            }
        }
        return Thread.currentThread().getContextClassLoader().getResource(name);
    }

    private Resources() {
    }

    private static class Reporter
    implements Predicate<Path> {
        private final ForEachEntry callback;
        private URL root;
        private Path path;

        private Reporter(ForEachEntry callback) {
            this.callback = callback;
        }

        private void update(URL root, Path path) {
            this.root = root;
            this.path = path;
        }

        private boolean test(Path entry, File file) {
            boolean isDirectory = file.isDirectory();
            String relativePath = this.path.relativize(entry).toString();
            return this.callback.test(this.root, isDirectory ? relativePath + File.separator : relativePath, isDirectory);
        }

        @Override
        public boolean test(Path entry) {
            return this.test(entry, entry.toFile());
        }
    }

    @FunctionalInterface
    public static interface ForEachEntry {
        public boolean test(URL var1, String var2, boolean var3);
    }
}

