/*
 * Decompiled with CFR 0.152.
 */
package org.libj.lang;

import org.libj.lang.Sys;

public enum OperatingSystem {
    WINDOWS(Sys.OS_NAME.contains("win")),
    UNIX(Sys.OS_NAME.contains("nix") || Sys.OS_NAME.contains("nux") || Sys.OS_NAME.contains("aix")),
    SOLARIS(Sys.OS_NAME.contains("sunos")),
    MAC(Sys.OS_NAME.contains("mac"));

    private static OperatingSystem current;

    public static OperatingSystem get() {
        return current;
    }

    private OperatingSystem(boolean token) {
        if (token) {
            this.setCurrent();
        }
    }

    private void setCurrent() {
        current = this;
    }

    public boolean isWindows() {
        return this == WINDOWS;
    }

    public boolean isUnix() {
        return this == UNIX;
    }

    public boolean isSolaris() {
        return this == SOLARIS;
    }

    public boolean isMac() {
        return this == MAC;
    }
}

