/*
 * Decompiled with CFR 0.152.
 */
package org.libj.lang;

import java.util.Arrays;

public final class Characters {
    private static final char[] escapableChars = new char[]{'\"', '\'', '0', '1', '2', '3', '4', '5', '6', '7', '\\', 'b', 'f', 'n', 'r', 't'};
    private static final char[] escapedChars = new char[]{'\"', '\'', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\\', '\b', '\f', '\n', '\r', '\t'};
    private static final String[] asciiCharToString = new String[128];

    public static String toString(char ch) {
        return ch < '\u0080' ? asciiCharToString[ch] : String.valueOf(ch);
    }

    public static char escape(char ch) {
        int i = Arrays.binarySearch(escapableChars, ch);
        if (i < 0) {
            throw new IllegalArgumentException(ch + " is not an escapable character");
        }
        return escapedChars[i];
    }

    public static boolean isEscapable(char ch) {
        return Arrays.binarySearch(escapableChars, ch) > -1;
    }

    public static boolean isPrintable(char ch) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(ch);
        return block != null && block != Character.UnicodeBlock.SPECIALS && ch != '\uffff' && !Character.isISOControl(ch);
    }

    public static char[] valueOf(String str) {
        return str == null ? null : str.toCharArray();
    }

    private Characters() {
    }

    static {
        for (int i = 0; i < 128; ++i) {
            Characters.asciiCharToString[i] = String.valueOf((char)i);
        }
    }
}

