/*
 * Decompiled with CFR 0.152.
 */
package org.libj.io;

import java.io.IOException;
import java.io.Reader;
import org.libj.lang.Assertions;

public class UnsynchronizedStringReader
extends Reader {
    private String str;
    private final int length;
    private int next = 0;
    private int mark = 0;

    public UnsynchronizedStringReader(String s) {
        this.str = s;
        this.length = s.length();
    }

    private void ensureOpen() throws IOException {
        if (this.str == null) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        return this.next >= this.length ? -1 : (int)this.str.charAt(this.next++);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.ensureOpen();
        Assertions.assertBoundsOffsetCount((String)"cbuf.length", (int)cbuf.length, (String)"off", (int)off, (String)"len", (int)len);
        if (len == 0) {
            return 0;
        }
        if (this.next >= this.length) {
            return -1;
        }
        int n = Math.min(this.length - this.next, len);
        this.str.getChars(this.next, this.next += n, cbuf, off);
        return n;
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureOpen();
        if (this.next >= this.length) {
            return 0L;
        }
        long r = Math.max((long)(-this.next), Math.min((long)(this.length - this.next), n));
        this.next = (int)((long)this.next + r);
        return r;
    }

    @Override
    public boolean ready() throws IOException {
        this.ensureOpen();
        return true;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        Assertions.assertNotNegative((int)readAheadLimit, (String)"Read-ahead limit < 0");
        this.ensureOpen();
        this.mark = this.next;
    }

    @Override
    public void reset() throws IOException {
        this.ensureOpen();
        this.next = this.mark;
    }

    @Override
    public void close() {
        this.str = null;
    }
}

