/*
 * Decompiled with CFR 0.152.
 */
package org.libj.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.libj.io.SerializableStreamStore;

public class SerializableInputStreamFileStore
extends FileOutputStream
implements SerializableStreamStore<InputStream> {
    private final File file;

    SerializableInputStreamFileStore() throws IOException {
        this(File.createTempFile("serializable_stream_", "_store"));
    }

    private SerializableInputStreamFileStore(File file) throws IOException {
        super(file);
        this.file = file;
        file.deleteOnExit();
    }

    @Override
    public InputStream consume() throws IOException {
        super.close();
        return new FileInputStream(this.file);
    }

    @Override
    public void close() throws IOException {
        this.file.delete();
    }
}

