/*
 * Decompiled with CFR 0.152.
 */
package org.libj.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Random;
import org.libj.lang.Assertions;

public class RandomInputStream
extends InputStream {
    private final Random random;
    private volatile boolean closed;
    private final int length;
    private int pos;

    public RandomInputStream(int length, Random random) {
        this.length = Assertions.assertNotNegative((int)length);
        this.random = Objects.requireNonNull(random);
    }

    public RandomInputStream(int length) {
        this(length, new Random());
    }

    private void assertNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Input stream closed");
        }
    }

    @Override
    public int read() throws IOException {
        this.assertNotClosed();
        if (this.pos++ >= this.length) {
            return -1;
        }
        int val = this.random.nextInt() % 256;
        return val < 0 ? -val : val;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    private void nextBytes(byte[] b, int off, int len) {
        int i = off;
        while (i < len) {
            int rnd = this.random.nextInt();
            int n = Math.min(len - i, 4);
            while (n-- > 0) {
                b[i++] = (byte)rnd;
                rnd >>= 8;
            }
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.assertNotClosed();
        if (this.pos >= this.length) {
            return -1;
        }
        len = Math.min(len, this.available());
        this.nextBytes(b, off, len);
        this.pos += len;
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        this.assertNotClosed();
        if (this.pos >= this.length) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + n);
        return n;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public int available() {
        return this.length - this.pos;
    }
}

