/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.processor.model.typefactories;

import java.util.List;
import java.util.Set;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.leandreck.endpoints.processor.config.TemplateConfiguration;
import org.leandreck.endpoints.processor.model.EnumValue;
import org.leandreck.endpoints.processor.model.TypeNode;
import org.leandreck.endpoints.processor.model.TypeNodeFactory;
import org.leandreck.endpoints.processor.model.typefactories.ConcreteTypeNodeFactory;
import org.leandreck.endpoints.processor.model.typefactories.TypeNodeKind;
import org.leandreck.endpoints.processor.model.typefactories.TypeNodeUtils;

final class OptionalTypeNodeFactory
implements ConcreteTypeNodeFactory {
    private final TypeNodeFactory typeNodeFactory;
    private final TypeMirror objectMirror;

    OptionalTypeNodeFactory() {
        this.typeNodeFactory = null;
        this.objectMirror = null;
    }

    private OptionalTypeNodeFactory(TypeNodeFactory typeNodeFactory, Elements elementUtils) {
        this.typeNodeFactory = typeNodeFactory;
        this.objectMirror = TypeNodeUtils.getObjectMirror(elementUtils);
    }

    @Override
    public ConcreteTypeNodeFactory newConfiguredInstance(TypeNodeFactory typeNodeFactory, TemplateConfiguration configuration, Types typeUtils, Elements elementUtils) {
        return new OptionalTypeNodeFactory(typeNodeFactory, elementUtils);
    }

    @Override
    public TypeNode createTypeNode(String fieldName, String parameterName, boolean optional, TypeMirror typeMirror, DeclaredType containingType) {
        TypeNode componentType = this.typeNodeFactory.createTypeNode(fieldName, parameterName, this.defineValueMirror(typeMirror), containingType);
        return new OptionalTypeNode(componentType);
    }

    private TypeMirror defineValueMirror(TypeMirror typeMirror) {
        DeclaredType declaredType = (DeclaredType)typeMirror;
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        return typeArguments.stream().map(t -> t.getKind().equals((Object)TypeKind.WILDCARD) ? this.objectMirror : t).findFirst().orElse(this.objectMirror);
    }

    private final class OptionalTypeNode
    extends TypeNode {
        private final TypeNode valueType;

        private OptionalTypeNode(TypeNode valueType) {
            super(true);
            this.valueType = valueType;
        }

        @Override
        public String getFieldName() {
            return this.valueType.getFieldName();
        }

        @Override
        public String getParameterName() {
            return this.valueType.getParameterName();
        }

        @Override
        public String getTypeName() {
            return this.valueType.getTypeName();
        }

        @Override
        public String getType() {
            return this.valueType.getType();
        }

        @Override
        public String getTemplate() {
            return this.valueType.getTemplate();
        }

        @Override
        public boolean isMappedType() {
            return this.valueType.isMappedType();
        }

        @Override
        public TypeNodeKind getKind() {
            return TypeNodeKind.OPTIONAL;
        }

        @Override
        public List<TypeNode> getTypeParameters() {
            return this.valueType.getTypeParameters();
        }

        @Override
        public List<TypeNode> getChildren() {
            return this.valueType.getChildren();
        }

        @Override
        public Set<TypeNode> getTypes() {
            return this.valueType.getTypes();
        }

        @Override
        public Set<TypeNode> getImports() {
            return this.valueType.getImports();
        }

        @Override
        public Set<EnumValue> getEnumValues() {
            return this.valueType.getEnumValues();
        }

        @Override
        public boolean isDeclaredComplexType() {
            return this.valueType.isDeclaredComplexType();
        }
    }
}

