/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.processor.model.typefactories;

import java.util.List;
import java.util.Set;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.leandreck.endpoints.processor.config.TemplateConfiguration;
import org.leandreck.endpoints.processor.model.EnumValue;
import org.leandreck.endpoints.processor.model.TypeNode;
import org.leandreck.endpoints.processor.model.TypeNodeFactory;
import org.leandreck.endpoints.processor.model.typefactories.ConcreteTypeNodeFactory;
import org.leandreck.endpoints.processor.model.typefactories.TypeNodeKind;
import org.leandreck.endpoints.processor.model.typefactories.TypeNodeUtils;

class CollectionTypeNodeFactory
implements ConcreteTypeNodeFactory {
    private final TypeNodeFactory typeNodeFactory;
    private final TypeMirror objectMirror;

    CollectionTypeNodeFactory() {
        this.typeNodeFactory = null;
        this.objectMirror = null;
    }

    private CollectionTypeNodeFactory(TypeNodeFactory typeNodeFactory, Elements elementUtils) {
        this.typeNodeFactory = typeNodeFactory;
        this.objectMirror = TypeNodeUtils.getObjectMirror(elementUtils);
    }

    @Override
    public ConcreteTypeNodeFactory newConfiguredInstance(TypeNodeFactory typeNodeFactory, TemplateConfiguration configuration, Types typeUtils, Elements elementUtils) {
        return new CollectionTypeNodeFactory(typeNodeFactory, elementUtils);
    }

    @Override
    public TypeNode createTypeNode(String fieldName, String parameterName, boolean optional, TypeMirror typeMirror, DeclaredType containingType) {
        TypeMirror containingTypeMirror = this.defineContainingTypeMirror(typeMirror);
        TypeNode componentType = this.typeNodeFactory.createTypeNode(fieldName, parameterName, containingTypeMirror, containingType);
        return new CollectionTypeNode(optional, componentType);
    }

    private TypeMirror defineContainingTypeMirror(TypeMirror typeMirror) {
        DeclaredType declaredType = (DeclaredType)typeMirror;
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        return typeArguments.stream().map(t -> t.getKind().equals((Object)TypeKind.WILDCARD) ? this.objectMirror : t).findFirst().orElse(this.objectMirror);
    }

    private final class CollectionTypeNode
    extends TypeNode {
        private final TypeNode containingType;

        private CollectionTypeNode(boolean optional, TypeNode containingType) {
            super(optional);
            this.containingType = containingType;
        }

        @Override
        public String getFieldName() {
            return this.containingType.getFieldName();
        }

        @Override
        public String getParameterName() {
            return this.containingType.getParameterName();
        }

        @Override
        public String getTypeName() {
            return this.containingType.getTypeName();
        }

        @Override
        public String getType() {
            return this.containingType.getType() + "[]";
        }

        @Override
        public String getTemplate() {
            return this.containingType.getTemplate();
        }

        @Override
        public boolean isMappedType() {
            return this.containingType.isMappedType();
        }

        @Override
        public TypeNodeKind getKind() {
            return TypeNodeKind.ARRAY;
        }

        @Override
        public List<TypeNode> getTypeParameters() {
            return this.containingType.getTypeParameters();
        }

        @Override
        public List<TypeNode> getChildren() {
            return this.containingType.getChildren();
        }

        @Override
        public Set<TypeNode> getTypes() {
            return this.containingType.getTypes();
        }

        @Override
        public Set<TypeNode> getImports() {
            return this.containingType.getImports();
        }

        @Override
        public Set<EnumValue> getEnumValues() {
            return this.containingType.getEnumValues();
        }

        @Override
        public boolean isDeclaredComplexType() {
            return this.containingType.isDeclaredComplexType();
        }

        @Override
        public String getTypeNameVariable() {
            return this.containingType.getTypeNameVariable() + "[]";
        }
    }
}

