/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.processor.model.typefactories;

import java.util.List;
import java.util.Set;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.leandreck.endpoints.processor.config.TemplateConfiguration;
import org.leandreck.endpoints.processor.model.EnumValue;
import org.leandreck.endpoints.processor.model.TypeNode;
import org.leandreck.endpoints.processor.model.TypeNodeFactory;
import org.leandreck.endpoints.processor.model.typefactories.ConcreteTypeNodeFactory;
import org.leandreck.endpoints.processor.model.typefactories.TypeNodeKind;

final class ArrayTypeNodeFactory
implements ConcreteTypeNodeFactory {
    private final TypeNodeFactory typeNodeFactory;

    ArrayTypeNodeFactory() {
        this.typeNodeFactory = null;
    }

    private ArrayTypeNodeFactory(TypeNodeFactory typeNodeFactory) {
        this.typeNodeFactory = typeNodeFactory;
    }

    @Override
    public ConcreteTypeNodeFactory newConfiguredInstance(TypeNodeFactory typeNodeFactory, TemplateConfiguration configuration, Types typeUtils, Elements elementUtils) {
        return new ArrayTypeNodeFactory(typeNodeFactory);
    }

    @Override
    public TypeNode createTypeNode(String fieldName, String parameterName, boolean optional, TypeMirror typeMirror, DeclaredType containingType) {
        ArrayType arrayMirror = (ArrayType)typeMirror;
        TypeMirror componentMirror = arrayMirror.getComponentType();
        TypeNode componentType = this.typeNodeFactory.createTypeNode(fieldName, parameterName, componentMirror, containingType);
        return new ArrayTypeNode(optional, componentType);
    }

    private final class ArrayTypeNode
    extends TypeNode {
        private final TypeNode componentType;

        private ArrayTypeNode(boolean optional, TypeNode componentType) {
            super(optional);
            this.componentType = componentType;
        }

        @Override
        public String getFieldName() {
            return this.componentType.getFieldName();
        }

        @Override
        public String getParameterName() {
            return this.componentType.getParameterName();
        }

        @Override
        public String getTypeName() {
            return this.componentType.getTypeName();
        }

        @Override
        public String getType() {
            return this.componentType.getType() + "[]";
        }

        @Override
        public String getTemplate() {
            return this.componentType.getTemplate();
        }

        @Override
        public boolean isMappedType() {
            return this.componentType.isMappedType();
        }

        @Override
        public TypeNodeKind getKind() {
            return TypeNodeKind.ARRAY;
        }

        @Override
        public List<TypeNode> getTypeParameters() {
            return this.componentType.getTypeParameters();
        }

        @Override
        public List<TypeNode> getChildren() {
            return this.componentType.getChildren();
        }

        @Override
        public Set<TypeNode> getTypes() {
            return this.componentType.getTypes();
        }

        @Override
        public Set<TypeNode> getImports() {
            return this.componentType.getImports();
        }

        @Override
        public Set<EnumValue> getEnumValues() {
            return this.componentType.getEnumValues();
        }

        @Override
        public boolean isDeclaredComplexType() {
            return this.componentType.isDeclaredComplexType();
        }

        @Override
        public String getTypeNameVariable() {
            return this.componentType.getTypeNameVariable() + "[]";
        }
    }
}

