/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.processor.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.leandreck.endpoints.processor.model.TypeNode;

public class MethodNode {
    private final String name;
    private final String url;
    private final boolean ignored;
    private final TypeNode returnType;
    private final TypeNode requestBodyType;
    private final List<TypeNode> pathVariableTypes;
    private final List<TypeNode> queryParameterTypes;
    private final List<String> httpMethods;
    private final Set<TypeNode> types;
    private final List<TypeNode> methodParameterTypes;

    MethodNode(String name, boolean ignored) {
        this.name = name;
        this.url = "";
        this.ignored = ignored;
        this.returnType = null;
        this.httpMethods = Collections.emptyList();
        this.requestBodyType = null;
        this.pathVariableTypes = Collections.emptyList();
        this.queryParameterTypes = Collections.emptyList();
        this.methodParameterTypes = Collections.emptyList();
        this.types = this.collectTypes();
    }

    MethodNode(String name, String url, boolean ignored, List<String> httpMethods, TypeNode returnType, TypeNode requestBodyType, List<TypeNode> pathVariableTypes, List<TypeNode> queryParameterTypes) {
        this.name = name;
        this.ignored = ignored;
        this.url = url;
        this.returnType = returnType;
        this.httpMethods = httpMethods;
        this.requestBodyType = requestBodyType;
        this.pathVariableTypes = pathVariableTypes;
        this.queryParameterTypes = queryParameterTypes;
        this.methodParameterTypes = new ArrayList<TypeNode>(pathVariableTypes.size() + queryParameterTypes.size());
        this.methodParameterTypes.addAll(pathVariableTypes);
        this.methodParameterTypes.addAll(queryParameterTypes);
        this.types = this.collectTypes();
    }

    private Set<TypeNode> collectTypes() {
        ArrayList<TypeNode> nodes = new ArrayList<TypeNode>();
        if (this.returnType != null) {
            nodes.add(this.returnType);
        }
        if (this.requestBodyType != null) {
            nodes.add(this.requestBodyType);
        }
        nodes.addAll(this.methodParameterTypes);
        return nodes.stream().flatMap(it -> it.getTypes().stream()).filter(TypeNode::isDeclaredComplexType).collect(Collectors.toSet());
    }

    public TypeNode getReturnType() {
        return this.returnType;
    }

    public List<String> getHttpMethods() {
        return Collections.unmodifiableList(this.httpMethods);
    }

    public String getName() {
        return this.name;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public String getUrl() {
        return this.url;
    }

    public TypeNode getRequestBodyType() {
        return this.requestBodyType;
    }

    public Set<TypeNode> getTypes() {
        return Collections.unmodifiableSet(this.types);
    }

    public List<TypeNode> getPathVariableTypes() {
        return Collections.unmodifiableList(this.pathVariableTypes);
    }

    public List<TypeNode> getQueryParameterTypes() {
        return Collections.unmodifiableList(this.queryParameterTypes);
    }

    public List<TypeNode> getMethodParameterTypes() {
        return Collections.unmodifiableList(this.methodParameterTypes);
    }

    public List<TypeNode> getRequiredMethodParameterTypes() {
        return Collections.unmodifiableList(this.methodParameterTypes.stream().filter(m -> !m.isOptional()).collect(Collectors.toList()));
    }

    public List<TypeNode> getOptionalMethodParameterTypes() {
        return Collections.unmodifiableList(this.methodParameterTypes.stream().filter(TypeNode::isOptional).collect(Collectors.toList()));
    }

    public List<TypeNode> getFunctionParameterTypes() {
        List functionParameters = Stream.concat(this.methodParameterTypes.stream(), Stream.of(this.requestBodyType)).filter(Objects::nonNull).filter(it -> !it.isOptional()).collect(Collectors.toList());
        Stream.concat(Stream.of(this.requestBodyType), this.methodParameterTypes.stream()).filter(Objects::nonNull).filter(TypeNode::isOptional).forEach(functionParameters::add);
        return Collections.unmodifiableList(functionParameters);
    }
}

