/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.processor;

import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;
import org.leandreck.endpoints.annotations.TypeScriptEndpoint;
import org.leandreck.endpoints.annotations.TypeScriptIgnore;
import org.leandreck.endpoints.annotations.TypeScriptTemplatesConfiguration;
import org.leandreck.endpoints.annotations.TypeScriptType;
import org.leandreck.endpoints.processor.config.MultipleConfigurationsFoundException;
import org.leandreck.endpoints.processor.config.TemplateConfiguration;
import org.leandreck.endpoints.processor.model.EndpointNode;
import org.leandreck.endpoints.processor.model.EndpointNodeFactory;
import org.leandreck.endpoints.processor.model.TypeNode;
import org.leandreck.endpoints.processor.model.typefactories.MissingConfigurationTemplateException;
import org.leandreck.endpoints.processor.printer.Engine;
import org.leandreck.endpoints.processor.printer.TypesPackage;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class TypeScriptEndpointProcessor
extends AbstractProcessor {
    private Filer filer;
    private Messager messager;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        annotations.add(TypeScriptEndpoint.class.getCanonicalName());
        annotations.add(TypeScriptIgnore.class.getCanonicalName());
        annotations.add(TypeScriptType.class.getCanonicalName());
        return annotations;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> annotated = roundEnv.getElementsAnnotatedWith(TypeScriptEndpoint.class);
        List<TypeElement> endpoints = annotated.stream().filter(element -> !ElementKind.METHOD.equals((Object)element.getKind())).map(element -> (TypeElement)element).collect(Collectors.toList());
        if (!endpoints.isEmpty()) {
            try {
                TemplateConfiguration templateConfiguration = TemplateConfiguration.buildFromEnvironment(roundEnv);
                this.processEndpoints(templateConfiguration, endpoints);
            }
            catch (MultipleConfigurationsFoundException mcfe) {
                this.printMessage("Multiple configurations found for the template locations.", new Object[0]);
                this.printConfigurationErrors(mcfe);
            }
            catch (MissingConfigurationTemplateException mcte) {
                this.printMessage(mcte.getElement(), mcte.getMessage(), new Object[0]);
            }
            catch (Exception unknown) {
                StringWriter writer = new StringWriter();
                unknown.printStackTrace(new PrintWriter(writer));
                this.printMessage("Unkown Error occured, please file a Bug https://github.com/leandreck/spring-typescript-services/issues \n%s", writer.toString());
            }
        }
        return true;
    }

    private void processEndpoints(TemplateConfiguration templateConfiguration, List<TypeElement> endpointElements) {
        Types typeUtils = this.processingEnv.getTypeUtils();
        Engine engine = new Engine(templateConfiguration);
        EndpointNodeFactory factory = new EndpointNodeFactory(templateConfiguration, typeUtils, this.processingEnv.getElementUtils());
        HashSet<EndpointNode> endpointNodes = new HashSet<EndpointNode>(endpointElements.size());
        for (TypeElement element : endpointElements) {
            EndpointNode endpointNode = factory.createEndpointNode(element);
            try (Writer out = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, "", this.toTSFilename(endpointNode.getServiceName(), ".generated.ts"), element).openWriter();){
                engine.processEndpoint(endpointNode, out);
            }
            catch (TemplateException tex) {
                this.printMessage(element, "Could not process template %s. Cause: %s", endpointNode.getTemplate(), tex.getMessage());
            }
            catch (IOException ioe) {
                this.printMessage(element, "Could not load template %s. Cause: %s", endpointNode.getTemplate(), ioe.getMessage());
            }
            endpointNodes.add(endpointNode);
        }
        TypeElement[] endpointArray = endpointElements.toArray(new TypeElement[endpointElements.size()]);
        Set<TypeNode> typeNodes = this.collectAllTypeNodes(endpointNodes);
        TypesPackage typesPackage = new TypesPackage(endpointNodes, typeNodes);
        this.writeIndexTs(engine, endpointArray, typesPackage);
        this.writeApiModuleTs(engine, endpointArray, typesPackage);
        this.writeTypeTsFiles(engine, endpointArray, typeNodes);
        this.writeServiceConfig(engine);
    }

    private Set<TypeNode> collectAllTypeNodes(Set<EndpointNode> endpointNodes) {
        HashMap typeNodeMap = new HashMap(endpointNodes.size() * 20);
        endpointNodes.stream().flatMap(endpointNode -> endpointNode.getTypes().stream()).filter(TypeNode::isDeclaredComplexType).forEach(it -> typeNodeMap.put(it.getTypeName(), it));
        return new HashSet<TypeNode>(typeNodeMap.values());
    }

    private void writeServiceConfig(Engine engine) {
        try (Writer out = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, "", "serviceconfig.ts", new Element[0]).openWriter();){
            engine.processServiceConfig(out);
        }
        catch (TemplateException | IOException ioe) {
            this.printMessage("Could not write serviceconfig.ts. Cause: %s", ioe.getMessage());
        }
    }

    private void writeTypeTsFiles(Engine engine, TypeElement[] endpointArray, Set<TypeNode> typeNodes) {
        for (TypeNode type : typeNodes) {
            try {
                Writer out = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, "", this.toTSFilename(type.getTypeName(), ".model.generated.ts"), endpointArray).openWriter();
                Throwable throwable = null;
                try {
                    engine.processTypeScriptTypeNode(type, out);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    out.close();
                }
            }
            catch (TemplateException tex) {
                this.printMessage("Could not process template %s for TypeNode %s. Cause: %s", type.getTemplate(), type.getTypeName(), tex.getMessage());
            }
            catch (IOException ioe) {
                this.printMessage("Could not load template %s for TypeNode %s. Cause: %s", type.getTemplate(), type.getTypeName(), ioe.getMessage());
            }
        }
    }

    private void writeApiModuleTs(Engine engine, TypeElement[] endpointArray, TypesPackage typesPackage) {
        try (Writer out = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, "", "api.module.ts", endpointArray).openWriter();){
            engine.processModuleTs(typesPackage, out);
        }
        catch (TemplateException tex) {
            this.printMessage("Could not process template api.module.ts. Cause: %s", tex.getMessage());
        }
        catch (IOException ioe) {
            this.printMessage("Could not load template api.module.ts. Cause: %s", ioe.getMessage());
        }
    }

    private void writeIndexTs(Engine engine, TypeElement[] endpointArray, TypesPackage typesPackage) {
        try (Writer out = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, "", "index.ts", endpointArray).openWriter();){
            engine.processIndexTs(typesPackage, out);
        }
        catch (TemplateException tex) {
            this.printMessage("Could not process template index.ts. Cause: %s", tex.getMessage());
        }
        catch (IOException ioe) {
            this.printMessage("Could not load template index.ts. Cause: %s", ioe.getMessage());
        }
    }

    private void printMessage(String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(Locale.ENGLISH, msg, args));
    }

    private void printMessage(Element element, String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(Locale.ENGLISH, msg, args), element, element.getAnnotationMirrors().stream().findFirst().orElse(null));
    }

    private String toTSFilename(String typeName, String suffix) {
        return typeName.toLowerCase(Locale.ENGLISH) + suffix;
    }

    void printConfigurationErrors(MultipleConfigurationsFoundException mcfe) {
        mcfe.getElementsWithConfiguration().stream().filter(Objects::nonNull).forEach(element -> {
            TypeScriptTemplatesConfiguration annotation = element.getAnnotation(TypeScriptTemplatesConfiguration.class);
            this.printMessage((Element)element, "TypeScriptTemplatesConfiguration: [apiModuleTemplate=%s, endpointTemplate=%s, enumerationTemplate=%s, indexTemplate=%s, interfaceTemplate=%s]", (Object)annotation.apimodule(), (Object)annotation.endpoint(), (Object)annotation.enumeration(), (Object)annotation.index(), (Object)annotation.interfaces());
        });
    }
}

