/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.processor.printer;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.io.Writer;
import org.leandreck.endpoints.processor.config.TemplateConfiguration;
import org.leandreck.endpoints.processor.model.EndpointNode;
import org.leandreck.endpoints.processor.model.TypeNode;
import org.leandreck.endpoints.processor.printer.TypesPackage;

public class Engine {
    private final Configuration freemarkerConfiguration;
    private final TemplateConfiguration templateConfiguration;

    public Engine(TemplateConfiguration configuration) {
        this.templateConfiguration = configuration;
        this.freemarkerConfiguration = new Configuration(Configuration.VERSION_2_3_23);
        this.freemarkerConfiguration.setDefaultEncoding("UTF-8");
        this.freemarkerConfiguration.setClassForTemplateLoading(this.getClass(), "/");
        this.freemarkerConfiguration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.freemarkerConfiguration.setLogTemplateExceptions(false);
    }

    public void processEndpoint(EndpointNode clazz, Writer out) throws IOException, TemplateException {
        Template service = this.freemarkerConfiguration.getTemplate(clazz.getTemplate());
        service.process((Object)clazz, out);
        out.append("\n");
    }

    public void processIndexTs(TypesPackage params, Writer out) throws IOException, TemplateException {
        Template service = this.freemarkerConfiguration.getTemplate(this.templateConfiguration.getIndexTemplate());
        service.process((Object)params, out);
        out.append("\n");
    }

    public void processModuleTs(TypesPackage params, Writer out) throws IOException, TemplateException {
        Template service = this.freemarkerConfiguration.getTemplate(this.templateConfiguration.getApiModuleTemplate());
        service.process((Object)params, out);
        out.append("\n");
    }

    public void processTypeScriptTypeNode(TypeNode node, Writer out) throws IOException, TemplateException {
        Template temp = this.freemarkerConfiguration.getTemplate(node.getTemplate());
        temp.process((Object)node, out);
        out.append("\n");
    }
}

