/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.processor.model.typefactories;

import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.leandreck.endpoints.processor.config.TemplateConfiguration;
import org.leandreck.endpoints.processor.model.EnumValue;
import org.leandreck.endpoints.processor.model.TypeNode;
import org.leandreck.endpoints.processor.model.TypeNodeFactory;
import org.leandreck.endpoints.processor.model.typefactories.ConcreteTypeNodeFactory;
import org.leandreck.endpoints.processor.model.typefactories.TypeNodeKind;
import org.leandreck.endpoints.processor.model.typefactories.TypeNodeUtils;

final class TypeVarTypeNodeFactory
implements ConcreteTypeNodeFactory {
    private final TypeNodeFactory typeNodeFactory;
    private final TemplateConfiguration configuration;
    private final Types typeUtils;
    private final TypeMirror objectMirror;

    TypeVarTypeNodeFactory() {
        this.typeUtils = null;
        this.configuration = null;
        this.typeNodeFactory = null;
        this.objectMirror = null;
    }

    private TypeVarTypeNodeFactory(TypeNodeFactory typeNodeFactory, TemplateConfiguration configuration, Types typeUtils, Elements elementUtils) {
        this.typeNodeFactory = typeNodeFactory;
        this.configuration = configuration;
        this.typeUtils = typeUtils;
        this.objectMirror = TypeNodeUtils.getObjectMirror(elementUtils);
    }

    @Override
    public ConcreteTypeNodeFactory newConfiguredInstance(TypeNodeFactory typeNodeFactory, TemplateConfiguration configuration, Types typeUtils, Elements elementUtils) {
        return new TypeVarTypeNodeFactory(typeNodeFactory, configuration, typeUtils, elementUtils);
    }

    @Override
    public TypeNode createTypeNode(String fieldName, String parameterName, boolean optional, TypeMirror typeMirror, TypeMirror containingType) {
        Element element = this.typeUtils.asElement(typeMirror);
        TypeMirror boundMirror = this.typeUtils.asMemberOf((DeclaredType)containingType, element);
        TypeNode boundType = this.typeNodeFactory.createTypeNode(fieldName, parameterName, boundMirror, containingType);
        return new TypeVarTypeNode(optional, element.getSimpleName().toString(), boundType);
    }

    private final class TypeVarTypeNode
    extends TypeNode {
        private final String typeNameVariable;
        private final TypeNode boundType;

        private TypeVarTypeNode(boolean optional, String typeNameVariable, TypeNode boundType) {
            super(optional);
            this.typeNameVariable = typeNameVariable;
            this.boundType = boundType;
        }

        @Override
        public String getFieldName() {
            return this.boundType.getFieldName();
        }

        @Override
        public String getParameterName() {
            return this.boundType.getParameterName();
        }

        @Override
        public String getTypeName() {
            return this.boundType.getTypeName();
        }

        @Override
        public String getType() {
            return this.boundType.getType();
        }

        @Override
        public String getTemplate() {
            return this.boundType.getTemplate();
        }

        @Override
        public boolean isMappedType() {
            return this.boundType.isMappedType();
        }

        @Override
        public TypeNodeKind getKind() {
            return TypeNodeKind.TYPEVAR;
        }

        @Override
        public List<TypeNode> getTypeParameters() {
            return this.boundType.getTypeParameters();
        }

        @Override
        public List<TypeNode> getChildren() {
            return this.boundType.getChildren();
        }

        @Override
        public Set<TypeNode> getTypes() {
            return this.boundType.getTypes();
        }

        @Override
        public Set<TypeNode> getImports() {
            return this.boundType.getImports();
        }

        @Override
        public Set<EnumValue> getEnumValues() {
            return this.boundType.getEnumValues();
        }

        @Override
        public boolean isDeclaredComplexType() {
            return this.boundType.isDeclaredComplexType();
        }

        @Override
        public String getTypeNameVariable() {
            return this.typeNameVariable;
        }
    }
}

