/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.processor.model.typefactories;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.leandreck.endpoints.annotations.TypeScriptType;
import org.leandreck.endpoints.processor.config.TemplateConfiguration;
import org.leandreck.endpoints.processor.model.TypeNode;
import org.leandreck.endpoints.processor.model.TypeNodeFactory;
import org.leandreck.endpoints.processor.model.typefactories.ConcreteTypeNodeFactory;
import org.leandreck.endpoints.processor.model.typefactories.TypeNodeKind;
import org.leandreck.endpoints.processor.model.typefactories.TypeNodeUtils;

class MappedTypeNodeFactory
implements ConcreteTypeNodeFactory {
    private final Types typeUtils;

    MappedTypeNodeFactory() {
        this.typeUtils = null;
    }

    private MappedTypeNodeFactory(TypeNodeFactory typeNodeFactory, TemplateConfiguration configuration, Types typeUtils, Elements elementUtils) {
        this.typeUtils = typeUtils;
    }

    @Override
    public ConcreteTypeNodeFactory newConfiguredInstance(TypeNodeFactory typeNodeFactory, TemplateConfiguration configuration, Types typeUtils, Elements elementUtils) {
        return new MappedTypeNodeFactory(typeNodeFactory, configuration, typeUtils, elementUtils);
    }

    @Override
    public TypeNode createTypeNode(String fieldName, String parameterName, boolean optional, TypeMirror typeMirror, TypeMirror containingType) {
        TypeElement typeElement = (TypeElement)this.typeUtils.asElement(typeMirror);
        TypeScriptType typeScriptTypeAnnotation = TypeNodeUtils.getAnnotationForClass(typeMirror, TypeScriptType.class, this.typeUtils);
        String typeName = TypeNodeUtils.defineName(typeMirror, typeScriptTypeAnnotation, this::defineNameFromMapped);
        return new MappedTypeNode(optional, fieldName, parameterName, typeName);
    }

    private String defineNameFromMapped(TypeMirror typeMirror) {
        String typeName;
        TypeKind kind = typeMirror.getKind();
        if (kind.isPrimitive() || TypeKind.VOID.equals((Object)kind)) {
            typeName = TypeNodeKind.getMapping(kind.name());
        } else {
            String key = this.typeUtils.asElement(typeMirror).getSimpleName().toString();
            typeName = TypeNodeKind.getMapping(key);
        }
        return typeName;
    }

    class MappedTypeNode
    extends TypeNode {
        private final String fieldName;
        private final String parameterName;
        private final String typeName;

        MappedTypeNode(boolean optional, String fieldName, String parameterName, String typeName) {
            super(optional);
            this.fieldName = fieldName;
            this.parameterName = parameterName;
            this.typeName = typeName;
        }

        @Override
        public String getFieldName() {
            return this.fieldName;
        }

        @Override
        public String getParameterName() {
            return this.parameterName;
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }

        @Override
        public String getType() {
            return this.typeName;
        }

        @Override
        public String getTemplate() {
            return "NO_TEMPLATE";
        }

        @Override
        public boolean isMappedType() {
            return true;
        }

        @Override
        public TypeNodeKind getKind() {
            return TypeNodeKind.MAPPED;
        }

        @Override
        public List<TypeNode> getTypeParameters() {
            return Collections.emptyList();
        }

        @Override
        public List<TypeNode> getChildren() {
            return Collections.emptyList();
        }

        @Override
        public Set<TypeNode> getTypes() {
            return Collections.emptySet();
        }

        @Override
        public Set<TypeNode> getImports() {
            return Collections.emptySet();
        }
    }
}

