/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.processor.model;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.leandreck.endpoints.annotations.TypeScriptIgnore;
import org.leandreck.endpoints.processor.config.TemplateConfiguration;
import org.leandreck.endpoints.processor.model.TypeNode;
import org.leandreck.endpoints.processor.model.VariableAnnotations;
import org.leandreck.endpoints.processor.model.typefactories.ConcreteTypeNodeFactory;
import org.leandreck.endpoints.processor.model.typefactories.TypeNodeKind;
import org.leandreck.endpoints.processor.model.typefactories.TypeNodeUtils;

public final class TypeNodeFactory {
    private final Types typeUtils;
    private final Elements elementUtils;
    private final TemplateConfiguration configuration;
    private final Map<TypeNodeKind, ConcreteTypeNodeFactory> factories;

    TypeNodeFactory(TemplateConfiguration configuration, Types typeUtils, Elements elementUtils) {
        this.configuration = configuration;
        this.typeUtils = typeUtils;
        this.elementUtils = elementUtils;
        this.factories = this.initFactories();
    }

    private Map<TypeNodeKind, ConcreteTypeNodeFactory> initFactories() {
        HashMap<TypeNodeKind, ConcreteTypeNodeFactory> factories = new HashMap<TypeNodeKind, ConcreteTypeNodeFactory>(TypeNodeKind.values().length * 2);
        Arrays.stream(TypeNodeKind.values()).forEach(it -> {
            try {
                factories.put((TypeNodeKind)((Object)it), it.getTypeNodeFactory().newConfiguredInstance(this, this.configuration, this.typeUtils, this.elementUtils));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return factories;
    }

    public TypeNode createTypeNode(TypeMirror typeMirror) {
        return this.createTypeNode(typeMirror, null);
    }

    public TypeNode createTypeNode(TypeMirror typeMirror, TypeMirror containingType) {
        String fieldName = "TYPE-ROOT";
        return this.initType("TYPE-ROOT", null, false, typeMirror, containingType);
    }

    public TypeNode createTypeNode(String fieldName, String parameterName, TypeMirror typeMirror, TypeMirror containingType) {
        return this.initType(fieldName, parameterName, false, typeMirror, containingType);
    }

    TypeNode createTypeNode(VariableElement variableElement, String parameterName, TypeMirror containingType) {
        TypeMirror typeMirror = variableElement.asType();
        String fieldName = variableElement.getSimpleName().toString();
        return this.initType(fieldName, parameterName, VariableAnnotations.isOptionalByAnnotation(variableElement), typeMirror, containingType);
    }

    public List<TypeNode> defineChildren(TypeElement typeElement, TypeMirror typeMirror) {
        List<String> publicGetter = TypeNodeFactory.definePublicGetter(typeElement, typeMirror, this.typeUtils);
        return ElementFilter.fieldsIn(typeElement.getEnclosedElements()).stream().filter(c -> c.getAnnotation(TypeScriptIgnore.class) == null).filter(c -> !c.getModifiers().contains((Object)Modifier.TRANSIENT)).filter(c -> this.filterVariableElements((VariableElement)c, publicGetter)).map(it -> this.createTypeNode((VariableElement)it, null, typeMirror)).collect(Collectors.toList());
    }

    private static List<String> definePublicGetter(TypeElement typeElement, TypeMirror typeMirror, Types typeUtils) {
        List<String> publicGetters = ElementFilter.methodsIn(typeElement.getEnclosedElements()).stream().filter(g -> g.getSimpleName().toString().startsWith("get") || g.getSimpleName().toString().startsWith("is")).filter(g -> g.getModifiers().contains((Object)Modifier.PUBLIC)).filter(g -> !g.getModifiers().contains((Object)Modifier.ABSTRACT)).map(g -> g.getSimpleName().toString()).collect(Collectors.toList());
        if (TypeNodeFactory.isLombokAnnotatedType(typeMirror, typeUtils)) {
            ElementFilter.fieldsIn(typeElement.getEnclosedElements()).stream().filter(g -> !g.getModifiers().contains((Object)Modifier.STATIC)).map(g -> g.getSimpleName().toString()).forEach(publicGetters::add);
        }
        return publicGetters;
    }

    private static boolean isLombokAnnotatedType(TypeMirror typeMirror, Types typeUtils) {
        return Arrays.stream(new String[]{"lombok.Data", "lombok.Value", "lombok.Getter"}).anyMatch(annotationName -> {
            try {
                Class<?> dataAnnotationClass = Class.forName(annotationName);
                Object dataAnnotation = TypeNodeUtils.getAnnotationForClass(typeMirror, dataAnnotationClass, typeUtils);
                return dataAnnotation != null;
            }
            catch (Exception exception) {
                return false;
            }
        });
    }

    private boolean filterVariableElements(VariableElement variableElement, List<String> publicGetter) {
        return publicGetter.stream().map(g -> g.toLowerCase().endsWith(variableElement.getSimpleName().toString().toLowerCase())).reduce(false, (a, b) -> a != false || b != false);
    }

    private TypeNode initType(String fieldName, String parameterName, boolean optional, TypeMirror typeMirror, TypeMirror containingType) {
        try {
            TypeNodeKind typeNodeKind = this.defineKind(typeMirror);
            ConcreteTypeNodeFactory nodeFactory = this.factories.get((Object)typeNodeKind);
            return nodeFactory.createTypeNode(fieldName, parameterName, optional, typeMirror, containingType);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private TypeNodeKind defineKind(TypeMirror typeMirror) {
        TypeNodeKind typeNodeKind;
        if (typeMirror == null) {
            return TypeNodeKind.NULL;
        }
        TypeKind kind = typeMirror.getKind();
        switch (kind) {
            case ARRAY: {
                typeNodeKind = TypeNodeKind.ARRAY;
                break;
            }
            case TYPEVAR: {
                typeNodeKind = TypeNodeKind.TYPEVAR;
                break;
            }
            case DECLARED: {
                typeNodeKind = this.defineDeclaredTypeNodeKind(typeMirror);
                break;
            }
            default: {
                typeNodeKind = TypeNodeKind.containsMapping(kind.name()) ? TypeNodeKind.MAPPED : TypeNodeKind.SIMPLE;
            }
        }
        return typeNodeKind;
    }

    private TypeNodeKind defineDeclaredTypeNodeKind(TypeMirror typeMirror) {
        DeclaredType declaredType;
        ElementKind elementKind = this.typeUtils.asElement(typeMirror).getKind();
        TypeMirror collectionMirror = this.elementUtils.getTypeElement("java.util.Collection").asType();
        DeclaredType mapMirror = this.typeUtils.getDeclaredType(this.elementUtils.getTypeElement("java.util.Map"), new TypeMirror[0]);
        TypeNodeKind typeNodeKind = ElementKind.ENUM.equals((Object)elementKind) ? TypeNodeKind.ENUM : (this.typeUtils.isAssignable(typeMirror, this.typeUtils.erasure(collectionMirror)) ? TypeNodeKind.COLLECTION : (this.typeUtils.isAssignable(typeMirror, this.typeUtils.erasure(mapMirror)) ? TypeNodeKind.MAP : (TypeNodeKind.containsMapping((declaredType = (DeclaredType)typeMirror).asElement().getSimpleName().toString()) ? TypeNodeKind.MAPPED : (declaredType.asElement().asType().toString().equals("java.util.Optional<T>") || declaredType.asElement().asType().toString().equals("org.springframework.http.ResponseEntity<T>") ? TypeNodeKind.OPTIONAL : TypeNodeKind.SIMPLE))));
        return typeNodeKind;
    }
}

