/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.processor.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.leandreck.endpoints.annotations.TypeScriptIgnore;
import org.leandreck.endpoints.processor.config.TemplateConfiguration;
import org.leandreck.endpoints.processor.model.MethodNode;
import org.leandreck.endpoints.processor.model.RequestMapping;
import org.leandreck.endpoints.processor.model.RequestMappingFactory;
import org.leandreck.endpoints.processor.model.StringUtil;
import org.leandreck.endpoints.processor.model.TypeNode;
import org.leandreck.endpoints.processor.model.TypeNodeFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

class MethodNodeFactory {
    private final TypeNodeFactory typeNodeFactory;
    private final RequestMappingFactory requestMappingFactory;

    MethodNodeFactory(TemplateConfiguration configuration, Types typeUtils, Elements elementUtils) {
        this.typeNodeFactory = new TypeNodeFactory(configuration, typeUtils, elementUtils);
        this.requestMappingFactory = new RequestMappingFactory();
    }

    MethodNode createMethodNode(ExecutableElement methodElement) {
        RequestMapping requestMapping = this.requestMappingFactory.createRequestMapping(methodElement);
        String name = MethodNodeFactory.defineName(methodElement);
        boolean ignored = MethodNodeFactory.defineIgnored(methodElement, requestMapping);
        if (ignored) {
            return new MethodNode(name, "", true, null, null);
        }
        String url = MethodNodeFactory.defineUrl(requestMapping);
        List<String> httpMethods = MethodNodeFactory.defineHttpMethods(requestMapping);
        TypeNode returnType = this.defineReturnType(methodElement);
        List<? extends VariableElement> parameters = methodElement.getParameters();
        TypeMirror containingType = methodElement.asType();
        TypeNode requestBodyType = this.defineRequestBodyType(parameters, containingType);
        List<TypeNode> pathVariables = this.definePathVariableTypes(parameters, containingType);
        List<TypeNode> queryParams = this.defineQueryParamsTypes(parameters, containingType);
        return new MethodNode(name, url, false, httpMethods, returnType, requestBodyType, pathVariables, queryParams);
    }

    private TypeNode defineReturnType(ExecutableElement methodElement) {
        TypeMirror returnMirror = methodElement.getReturnType();
        return this.typeNodeFactory.createTypeNode(returnMirror);
    }

    private List<TypeNode> definePathVariableTypes(List<? extends VariableElement> parameters, TypeMirror containingType) {
        return parameters.stream().filter(p -> p.getAnnotation(PathVariable.class) != null).map(it -> this.typeNodeFactory.createTypeNode((VariableElement)it, StringUtil.definedValue(it.getAnnotation(PathVariable.class).name(), it.getAnnotation(PathVariable.class).value()), containingType)).collect(Collectors.toList());
    }

    private List<TypeNode> defineQueryParamsTypes(List<? extends VariableElement> parameters, TypeMirror containingType) {
        return parameters.stream().filter(p -> p.getAnnotation(RequestParam.class) != null).filter(it -> !it.asType().toString().equals("org.springframework.web.multipart.MultipartFile")).map(it -> this.typeNodeFactory.createTypeNode((VariableElement)it, StringUtil.definedValue(it.getAnnotation(RequestParam.class).name(), it.getAnnotation(RequestParam.class).value()), containingType)).collect(Collectors.toList());
    }

    private TypeNode defineRequestBodyType(List<? extends VariableElement> parameters, TypeMirror containingType) {
        TypeNode requestBodyType;
        Optional<VariableElement> optionalRequestBody = parameters.stream().filter(it -> it.getAnnotation(RequestBody.class) != null || it.asType().toString().equals("org.springframework.web.multipart.MultipartFile")).findFirst();
        if (optionalRequestBody.isPresent()) {
            VariableElement paramElement = optionalRequestBody.get();
            requestBodyType = this.typeNodeFactory.createTypeNode(paramElement, null, containingType);
        } else {
            requestBodyType = this.typeNodeFactory.createTypeNode("body", null, null, null);
        }
        return requestBodyType;
    }

    private static List<String> defineHttpMethods(RequestMapping requestMapping) {
        ArrayList<String> methods = new ArrayList<String>();
        if (requestMapping != null) {
            return Arrays.stream(requestMapping.method()).map(requestMethod -> requestMethod.toString().toLowerCase()).collect(Collectors.toList());
        }
        return methods;
    }

    private static boolean defineIgnored(ExecutableElement methodElement, RequestMapping requestMapping) {
        boolean hasIgnoreAnnotation = methodElement.getAnnotation(TypeScriptIgnore.class) != null;
        boolean hasRequestMappingAnnotation = requestMapping != null;
        boolean producesJson = hasRequestMappingAnnotation && Arrays.stream(requestMapping.produces()).map(value -> value.startsWith("application/json")).reduce(false, (a, b) -> a != false || b != false) != false;
        boolean isPublic = methodElement.getModifiers().contains((Object)Modifier.PUBLIC);
        return hasIgnoreAnnotation || !isPublic || !hasRequestMappingAnnotation || !producesJson;
    }

    private static String defineUrl(RequestMapping requestMapping) {
        String[] mappings;
        if (requestMapping != null && (mappings = requestMapping.value()).length > 0) {
            return mappings[0];
        }
        return "";
    }

    private static String defineName(ExecutableElement methodElement) {
        return methodElement.getSimpleName().toString();
    }
}

